/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Electricity;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ToxicGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArcaneArmor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barkskin;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Berserk;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bleeding;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ChampionEnemy;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Charm;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Chill;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Corrosion;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Doom;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Dread;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FireImbue;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Frost;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FrostImbue;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Fury;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Hex;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Hunger;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LifeLink;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LostInventory;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicalSleep;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Ooze;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Poison;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Preparation;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShieldBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Slow;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SnipersMark;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Speed;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Stamina;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Terror;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vertigo;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Weakness;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.rogue.DeathMark;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.warrior.Endure;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Elemental;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.AntiMagic;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.Potential;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfCleansing;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfElements;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRetribution;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfChallenge;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfPsionicBlast;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfFireblast;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfFrost;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLightning;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Blazing;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Blocking;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Grim;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Shocking;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.darts.ShockingDart;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Chasm;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Door;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GrimTrap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Char
extends Actor {
    public int pos = 0;
    public CharSprite sprite;
    public int HT;
    public int HP;
    protected float baseSpeed = 1.0f;
    protected PathFinder.Path path;
    public int paralysed = 0;
    public boolean rooted = false;
    public boolean flying = false;
    public int invisible = 0;
    public Alignment alignment;
    public int viewDistance = 8;
    public boolean[] fieldOfView = null;
    private HashSet<Buff> buffs = new HashSet();
    protected static final String POS = "pos";
    protected static final String TAG_HP = "HP";
    protected static final String TAG_HT = "HT";
    protected static final String TAG_SHLD = "SHLD";
    protected static final String BUFFS = "buffs";
    public static int INFINITE_ACCURACY = 1000000;
    public static int INFINITE_EVASION = 1000000;
    private int cachedShield = 0;
    public boolean needsShieldUpdate = true;
    public boolean deathMarked = false;
    protected final HashSet<Class> resistances = new HashSet();
    protected final HashSet<Class> immunities = new HashSet();
    protected HashSet<Property> properties = new HashSet();

    @Override
    protected boolean act() {
        if (this.fieldOfView == null || this.fieldOfView.length != Dungeon.level.length()) {
            this.fieldOfView = new boolean[Dungeon.level.length()];
        }
        Dungeon.level.updateFieldOfView(this, this.fieldOfView);
        if (this.properties().contains((Object)Property.IMMOVABLE)) {
            this.throwItems();
        }
        return false;
    }

    protected void throwItems() {
        Heap heap = (Heap)Dungeon.level.heaps.get(this.pos);
        if (heap != null && heap.type == Heap.Type.HEAP) {
            int n;
            while (!Dungeon.level.passable[n = this.pos + PathFinder.NEIGHBOURS8[Random.Int(8)]] && !Dungeon.level.avoid[n]) {
            }
            Dungeon.level.drop((Item)heap.pickUp(), (int)n).sprite.drop(this.pos);
        }
    }

    public String name() {
        return Messages.get(this, "name", new Object[0]);
    }

    public boolean canInteract(Char c) {
        if (Dungeon.level.adjacent(this.pos, c.pos)) {
            return true;
        }
        return c instanceof Hero && this.alignment == Alignment.ALLY && Dungeon.level.distance(this.pos, c.pos) <= 2 * Dungeon.hero.pointsInTalent(Talent.ALLY_WARP);
    }

    public boolean interact(Char c) {
        if (!Dungeon.level.passable[this.pos] && !c.flying) {
            return true;
        }
        if (this.properties().contains((Object)Property.LARGE) && !Dungeon.level.openSpace[c.pos] || c.properties().contains((Object)Property.LARGE) && !Dungeon.level.openSpace[this.pos]) {
            return true;
        }
        int curPos = this.pos;
        if (c == Dungeon.hero && Dungeon.hero.hasTalent(Talent.ALLY_WARP)) {
            PathFinder.buildDistanceMap(c.pos, BArray.or(Dungeon.level.passable, Dungeon.level.avoid, null));
            if (PathFinder.distance[this.pos] == Integer.MAX_VALUE) {
                return true;
            }
            ScrollOfTeleportation.appear(this, c.pos);
            ScrollOfTeleportation.appear(c, curPos);
            Dungeon.observe();
            GameScene.updateFog();
            return true;
        }
        if (this.rooted || c.rooted || this.buff(Vertigo.class) != null || c.buff(Vertigo.class) != null) {
            return true;
        }
        this.moveSprite(this.pos, c.pos);
        this.move(c.pos);
        c.sprite.move(c.pos, curPos);
        c.move(curPos);
        c.spend(1.0f / c.speed());
        if (c == Dungeon.hero) {
            if (Dungeon.hero.subClass == HeroSubClass.FREERUNNER) {
                Buff.affect(Dungeon.hero, Momentum.class).gainStack();
            }
            Dungeon.hero.busy();
        }
        return true;
    }

    protected boolean moveSprite(int from, int to) {
        if (this.sprite.isVisible() && (Dungeon.level.heroFOV[from] || Dungeon.level.heroFOV[to])) {
            this.sprite.move(from, to);
            return true;
        }
        this.sprite.turnTo(from, to);
        this.sprite.place(to);
        return true;
    }

    public void hitSound(float pitch) {
        Sample.INSTANCE.play("sounds/hit.mp3", 1.0f, pitch);
    }

    public boolean blockSound(float pitch) {
        return false;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(POS, this.pos);
        bundle.put(TAG_HP, this.HP);
        bundle.put(TAG_HT, this.HT);
        bundle.put(BUFFS, this.buffs);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.pos = bundle.getInt(POS);
        this.HP = bundle.getInt(TAG_HP);
        this.HT = bundle.getInt(TAG_HT);
        for (Bundlable b : bundle.getCollection(BUFFS)) {
            if (b == null) continue;
            ((Buff)b).attachTo(this);
        }
    }

    public final boolean attack(Char enemy) {
        return this.attack(enemy, 1.0f, 0.0f, 1.0f);
    }

    public boolean attack(Char enemy, float dmgMulti, float dmgBonus, float accMulti) {
        boolean visibleFight;
        if (enemy == null) {
            return false;
        }
        boolean bl = visibleFight = Dungeon.level.heroFOV[this.pos] || Dungeon.level.heroFOV[enemy.pos];
        if (enemy.isInvulnerable(this.getClass())) {
            if (visibleFight) {
                enemy.sprite.showStatus(65280, Messages.get(this, "invulnerable", new Object[0]), new Object[0]);
                Sample.INSTANCE.play("sounds/hit_parry.mp3", 1.0f, Random.Float(0.96f, 1.05f));
            }
            return false;
        }
        if (Char.hit(this, enemy, accMulti)) {
            int dmg;
            Preparation prep;
            Blocking.BlockBuff block;
            int dr = enemy.drRoll();
            Barkskin bark = enemy.buff(Barkskin.class);
            if (bark != null) {
                dr += Random.NormalIntRange(0, bark.level());
            }
            if ((block = enemy.buff(Blocking.BlockBuff.class)) != null) {
                dr += block.blockingRoll();
            }
            if (this instanceof Hero) {
                Hero h = (Hero)this;
                if (h.belongings.weapon() instanceof MissileWeapon && h.subClass == HeroSubClass.SNIPER && !Dungeon.level.adjacent(h.pos, enemy.pos)) {
                    dr = 0;
                }
            }
            if ((prep = this.buff(Preparation.class)) != null) {
                dmg = prep.damageRoll(this);
                if (this == Dungeon.hero && Dungeon.hero.hasTalent(Talent.BOUNTY_HUNTER)) {
                    Buff.affect(Dungeon.hero, Talent.BountyHunterTracker.class, 0.0f);
                }
            } else {
                dmg = this.damageRoll();
            }
            dmg = Math.round((float)dmg * dmgMulti);
            Berserk berserk = this.buff(Berserk.class);
            if (berserk != null) {
                dmg = berserk.damageFactor(dmg);
            }
            if (this.buff(Fury.class) != null) {
                dmg = (int)((float)dmg * 1.5f);
            }
            dmg = (int)((float)dmg + dmgBonus);
            Endure.EndureTracker endure = this.buff(Endure.EndureTracker.class);
            if (endure != null) {
                dmg = endure.damageFactor(dmg);
            }
            if ((endure = enemy.buff(Endure.EndureTracker.class)) != null) {
                dmg = endure.adjustDamageTaken(dmg);
            }
            if (enemy.buff(ScrollOfChallenge.ChallengeArena.class) != null) {
                dmg = (int)((float)dmg * 0.67f);
            }
            int effectiveDamage = enemy.defenseProc(this, dmg);
            effectiveDamage = Math.max(effectiveDamage - dr, 0);
            if (enemy.buff(Vulnerable.class) != null) {
                effectiveDamage = (int)((float)effectiveDamage * 1.33f);
            }
            effectiveDamage = this.attackProc(enemy, effectiveDamage);
            if (visibleFight && (effectiveDamage > 0 || !enemy.blockSound(Random.Float(0.96f, 1.05f)))) {
                this.hitSound(Random.Float(0.87f, 1.15f));
            }
            if (!enemy.isAlive()) {
                return true;
            }
            enemy.damage(effectiveDamage, this);
            if (this.buff(FireImbue.class) != null) {
                this.buff(FireImbue.class).proc(enemy);
            }
            if (this.buff(FrostImbue.class) != null) {
                this.buff(FrostImbue.class).proc(enemy);
            }
            if (enemy.isAlive() && enemy.alignment != this.alignment && prep != null && prep.canKO(enemy)) {
                enemy.HP = 0;
                if (!enemy.isAlive()) {
                    enemy.die(this);
                } else {
                    enemy.damage(-1, this);
                    DeathMark.processFearTheReaper(enemy);
                }
                enemy.sprite.showStatus(0xFF0000, Messages.get(Preparation.class, "assassinated", new Object[0]), new Object[0]);
            }
            enemy.sprite.bloodBurstA(this.sprite.center(), effectiveDamage);
            enemy.sprite.flash();
            if (!enemy.isAlive() && visibleFight) {
                if (enemy == Dungeon.hero) {
                    if (this == Dungeon.hero) {
                        return true;
                    }
                    Dungeon.fail(this.getClass());
                    GLog.n(Messages.capitalize(Messages.get(Char.class, "kill", this.name())), new Object[0]);
                } else if (this == Dungeon.hero) {
                    GLog.i(Messages.capitalize(Messages.get(Char.class, "defeat", enemy.name())), new Object[0]);
                }
            }
            return true;
        }
        enemy.sprite.showStatus(0xFFFF00, enemy.defenseVerb(), new Object[0]);
        if (visibleFight) {
            Sample.INSTANCE.play("sounds/miss.mp3");
        }
        return false;
    }

    public static final boolean hit(Char attacker, Char defender, boolean magic) {
        return Char.hit(attacker, defender, magic ? 2.0f : 1.0f);
    }

    public static boolean hit(Char attacker, Char defender, float accMulti) {
        float acuStat = attacker.attackSkill(defender);
        float defStat = defender.defenseSkill(attacker);
        if (defStat >= (float)INFINITE_EVASION) {
            return false;
        }
        if (acuStat >= (float)INFINITE_ACCURACY) {
            return true;
        }
        float acuRoll = Random.Float(acuStat);
        if (attacker.buff(Bless.class) != null) {
            acuRoll *= 1.25f;
        }
        if (attacker.buff(Hex.class) != null) {
            acuRoll *= 0.8f;
        }
        for (ChampionEnemy buff : attacker.buffs(ChampionEnemy.class)) {
            acuRoll *= buff.evasionAndAccuracyFactor();
        }
        float defRoll = Random.Float(defStat);
        if (defender.buff(Bless.class) != null) {
            defRoll *= 1.25f;
        }
        if (defender.buff(Hex.class) != null) {
            defRoll *= 0.8f;
        }
        for (ChampionEnemy buff : defender.buffs(ChampionEnemy.class)) {
            defRoll *= buff.evasionAndAccuracyFactor();
        }
        return acuRoll * accMulti >= defRoll;
    }

    public int attackSkill(Char target) {
        return 0;
    }

    public int defenseSkill(Char enemy) {
        return 0;
    }

    public String defenseVerb() {
        return Messages.get(this, "def_verb", new Object[0]);
    }

    public int drRoll() {
        return 0;
    }

    public int damageRoll() {
        return 1;
    }

    public int attackProc(Char enemy, int damage) {
        if (this.buff(Weakness.class) != null) {
            damage = (int)((float)damage * 0.67f);
        }
        for (ChampionEnemy buff : this.buffs(ChampionEnemy.class)) {
            damage = (int)((float)damage * buff.meleeDamageFactor());
            buff.onAttackProc(enemy);
        }
        return damage;
    }

    public int defenseProc(Char enemy, int damage) {
        return damage;
    }

    public float speed() {
        float speed = this.baseSpeed;
        if (this.buff(Cripple.class) != null) {
            speed /= 2.0f;
        }
        if (this.buff(Stamina.class) != null) {
            speed *= 1.5f;
        }
        if (this.buff(Adrenaline.class) != null) {
            speed *= 2.0f;
        }
        if (this.buff(Haste.class) != null) {
            speed *= 3.0f;
        }
        if (this.buff(Dread.class) != null) {
            speed *= 2.0f;
        }
        return speed;
    }

    public int shielding() {
        if (!this.needsShieldUpdate) {
            return this.cachedShield;
        }
        this.cachedShield = 0;
        for (ShieldBuff s : this.buffs(ShieldBuff.class)) {
            this.cachedShield += s.shielding();
        }
        this.needsShieldUpdate = false;
        return this.cachedShield;
    }

    public void damage(int dmg, Object src) {
        Endure.EndureTracker endure;
        Class<?> srcClass;
        Charm c;
        Dread dread;
        Terror t;
        if (!this.isAlive() || dmg < 0) {
            return;
        }
        if (this.isInvulnerable(src.getClass())) {
            this.sprite.showStatus(65280, Messages.get(this, "invulnerable", new Object[0]), new Object[0]);
            return;
        }
        for (ChampionEnemy championEnemy : this.buffs(ChampionEnemy.class)) {
            dmg = (int)Math.ceil((float)dmg * championEnemy.damageTakenFactor());
        }
        if (!(src instanceof LifeLink) && this.buff(LifeLink.class) != null) {
            HashSet<LifeLink> links = this.buffs(LifeLink.class);
            for (LifeLink link : links.toArray(new LifeLink[0])) {
                if (Actor.findById(link.object) != null) continue;
                links.remove(link);
                link.detach();
            }
            dmg = (int)Math.ceil((float)dmg / (float)(links.size() + 1));
            for (LifeLink link : links) {
                Char ch = (Char)Actor.findById(link.object);
                ch.damage(dmg, link);
                if (ch.isAlive()) continue;
                link.detach();
            }
        }
        if ((t = this.buff(Terror.class)) != null) {
            t.recover();
        }
        if ((dread = this.buff(Dread.class)) != null) {
            dread.recover();
        }
        if ((c = this.buff(Charm.class)) != null) {
            c.recover(src);
        }
        if (this.buff(Frost.class) != null) {
            Buff.detach(this, Frost.class);
        }
        if (this.buff(MagicalSleep.class) != null) {
            Buff.detach(this, MagicalSleep.class);
        }
        if (this.buff(Doom.class) != null && !this.isImmune(Doom.class)) {
            dmg *= 2;
        }
        if (this.alignment != Alignment.ALLY && this.buff(DeathMark.DeathMarkTracker.class) != null) {
            dmg = (int)((float)dmg * 1.25f);
        }
        dmg = this.isImmune(srcClass = src.getClass()) ? 0 : Math.round((float)dmg * this.resist(srcClass));
        if (AntiMagic.RESISTS.contains(src.getClass()) && this.buff(ArcaneArmor.class) != null && (dmg -= Random.NormalIntRange(0, this.buff(ArcaneArmor.class).level())) < 0) {
            dmg = 0;
        }
        if (this.buff(Paralysis.class) != null) {
            this.buff(Paralysis.class).processDamage(dmg);
        }
        if ((endure = this.buff(Endure.EndureTracker.class)) != null) {
            dmg = endure.enforceDamagetakenLimit(dmg);
        }
        int shielded = dmg;
        if (!(src instanceof Hunger)) {
            ShieldBuff s;
            Iterator<ShieldBuff> iterator = this.buffs(ShieldBuff.class).iterator();
            while (iterator.hasNext() && (dmg = (s = iterator.next()).absorbDamage(dmg)) != 0) {
            }
        }
        shielded -= dmg;
        this.HP -= dmg;
        if (this.sprite != null) {
            this.sprite.showStatus(this.HP > this.HT / 2 ? 0xFF8800 : 0xFF0000, Integer.toString(dmg + shielded), new Object[0]);
        }
        if (this.HP < 0) {
            this.HP = 0;
        }
        if (!this.isAlive()) {
            this.die(src);
        } else if (this.HP == 0 && this.buff(DeathMark.DeathMarkTracker.class) != null) {
            DeathMark.processFearTheReaper(this);
        }
    }

    public void destroy() {
        this.HP = 0;
        Actor.remove(this);
        for (Char ch : Actor.chars().toArray(new Char[0])) {
            if (ch.buff(Charm.class) != null && ch.buff(Charm.class).object == this.id()) {
                ch.buff(Charm.class).detach();
            }
            if (ch.buff(Dread.class) != null && ch.buff(Dread.class).object == this.id()) {
                ch.buff(Dread.class).detach();
            }
            if (ch.buff(Terror.class) != null && ch.buff(Terror.class).object == this.id()) {
                ch.buff(Terror.class).detach();
            }
            if (ch.buff(SnipersMark.class) == null || ch.buff(SnipersMark.class).object != this.id()) continue;
            ch.buff(SnipersMark.class).detach();
        }
    }

    public void die(Object src) {
        this.destroy();
        if (src != Chasm.class) {
            this.sprite.die();
        }
    }

    public boolean isAlive() {
        return this.HP > 0 || this.deathMarked;
    }

    @Override
    protected void spend(float time) {
        float timeScale = 1.0f;
        if (this.buff(Slow.class) != null) {
            timeScale *= 0.5f;
        } else if (this.buff(Chill.class) != null) {
            timeScale *= this.buff(Chill.class).speedFactor();
        }
        if (this.buff(Speed.class) != null) {
            timeScale *= 2.0f;
        }
        super.spend(time / timeScale);
    }

    public synchronized HashSet<Buff> buffs() {
        return new HashSet<Buff>(this.buffs);
    }

    public synchronized <T extends Buff> HashSet<T> buffs(Class<T> c) {
        HashSet<Buff> filtered = new HashSet<Buff>();
        for (Buff b : this.buffs) {
            if (!c.isInstance(b)) continue;
            filtered.add(b);
        }
        return filtered;
    }

    public synchronized <T extends Buff> T buff(Class<T> c) {
        for (Buff b : this.buffs) {
            if (b.getClass() != c) continue;
            return (T)b;
        }
        return null;
    }

    public synchronized boolean isCharmedBy(Char ch) {
        int chID = ch.id();
        for (Buff b : this.buffs) {
            if (!(b instanceof Charm) || ((Charm)b).object != chID) continue;
            return true;
        }
        return false;
    }

    public synchronized void add(Buff buff) {
        if (this.buff(PotionOfCleansing.Cleanse.class) != null && buff.type == Buff.buffType.NEGATIVE && !(buff instanceof AllyBuff) && !(buff instanceof LostInventory)) {
            return;
        }
        this.buffs.add(buff);
        if (Actor.chars().contains(this)) {
            Actor.add(buff);
        }
        if (this.sprite != null && buff.announced) {
            switch (buff.type) {
                case POSITIVE: {
                    this.sprite.showStatus(65280, buff.toString(), new Object[0]);
                    break;
                }
                case NEGATIVE: {
                    this.sprite.showStatus(0xFF0000, buff.toString(), new Object[0]);
                    break;
                }
                default: {
                    this.sprite.showStatus(0xFFFF00, buff.toString(), new Object[0]);
                }
            }
        }
    }

    public synchronized void remove(Buff buff) {
        this.buffs.remove(buff);
        Actor.remove(buff);
    }

    public synchronized void remove(Class<? extends Buff> buffClass) {
        for (Buff buff : this.buffs(buffClass)) {
            this.remove(buff);
        }
    }

    @Override
    protected synchronized void onRemove() {
        for (Buff buff : this.buffs.toArray(new Buff[this.buffs.size()])) {
            buff.detach();
        }
    }

    public synchronized void updateSpriteState() {
        for (Buff buff : this.buffs) {
            buff.fx(true);
        }
    }

    public float stealth() {
        return 0.0f;
    }

    public final void move(int step) {
        this.move(step, true);
    }

    public void move(int step, boolean travelling) {
        if (travelling && Dungeon.level.adjacent(step, this.pos) && this.buff(Vertigo.class) != null) {
            this.sprite.interruptMotion();
            int newPos = this.pos + PathFinder.NEIGHBOURS8[Random.Int(8)];
            if (!Dungeon.level.passable[newPos] && !Dungeon.level.avoid[newPos] || this.properties().contains((Object)Property.LARGE) && !Dungeon.level.openSpace[newPos] || Actor.findChar(newPos) != null) {
                return;
            }
            this.sprite.move(this.pos, newPos);
            step = newPos;
        }
        if (Dungeon.level.map[this.pos] == 6) {
            Door.leave(this.pos);
        }
        this.pos = step;
        if (this != Dungeon.hero) {
            this.sprite.visible = Dungeon.level.heroFOV[this.pos];
        }
        Dungeon.level.occupyCell(this);
    }

    public int distance(Char other) {
        return Dungeon.level.distance(this.pos, other.pos);
    }

    public void onMotionComplete() {
    }

    public void onAttackComplete() {
        this.next();
    }

    public void onOperateComplete() {
        this.next();
    }

    public float resist(Class effect) {
        HashSet<Class> resists = new HashSet<Class>(this.resistances);
        for (Property p : this.properties()) {
            resists.addAll(p.resistances());
        }
        for (Buff b : this.buffs()) {
            resists.addAll(b.resistances());
        }
        float result = 1.0f;
        for (Class c : resists) {
            if (!c.isAssignableFrom(effect)) continue;
            result *= 0.5f;
        }
        return result * RingOfElements.resist(this, effect);
    }

    public boolean isImmune(Class effect) {
        HashSet<Class> immunes = new HashSet<Class>(this.immunities);
        for (Property p : this.properties()) {
            immunes.addAll(p.immunities());
        }
        for (Buff b : this.buffs()) {
            immunes.addAll(b.immunities());
        }
        for (Class c : immunes) {
            if (!c.isAssignableFrom(effect)) continue;
            return true;
        }
        return false;
    }

    public boolean isInvulnerable(Class effect) {
        return false;
    }

    public HashSet<Property> properties() {
        HashSet<Property> props = new HashSet<Property>(this.properties);
        if (this.buff(ChampionEnemy.Giant.class) != null) {
            props.add(Property.LARGE);
        }
        return props;
    }

    public static boolean hasProp(Char ch, Property p) {
        return ch != null && ch.properties().contains((Object)p);
    }

    public static enum Property {
        BOSS(new HashSet<Class>(Arrays.asList(Grim.class, GrimTrap.class, ScrollOfRetribution.class, ScrollOfPsionicBlast.class)), new HashSet<Class>(Arrays.asList(AllyBuff.class, Dread.class))),
        MINIBOSS(new HashSet<Class>(), new HashSet<Class>(Arrays.asList(AllyBuff.class, Dread.class))),
        UNDEAD,
        DEMONIC,
        INORGANIC(new HashSet<Class>(), new HashSet<Class>(Arrays.asList(Bleeding.class, ToxicGas.class, Poison.class))),
        FIERY(new HashSet<Class>(Arrays.asList(WandOfFireblast.class, Elemental.FireElemental.class)), new HashSet<Class>(Arrays.asList(Burning.class, Blazing.class))),
        ICY(new HashSet<Class>(Arrays.asList(WandOfFrost.class, Elemental.FrostElemental.class)), new HashSet<Class>(Arrays.asList(Frost.class, Chill.class))),
        ACIDIC(new HashSet<Class>(Arrays.asList(Corrosion.class)), new HashSet<Class>(Arrays.asList(Ooze.class))),
        ELECTRIC(new HashSet<Class>(Arrays.asList(WandOfLightning.class, Shocking.class, Potential.class, Electricity.class, ShockingDart.class, Elemental.ShockElemental.class)), new HashSet<Class>()),
        LARGE,
        IMMOVABLE;

        private HashSet<Class> resistances;
        private HashSet<Class> immunities;

        private Property() {
            this(new HashSet<Class>(), new HashSet<Class>());
        }

        private Property(HashSet<Class> resistances, HashSet<Class> immunities) {
            this.resistances = resistances;
            this.immunities = immunities;
        }

        public HashSet<Class> resistances() {
            return new HashSet<Class>(this.resistances);
        }

        public HashSet<Class> immunities() {
            return new HashSet<Class>(this.immunities);
        }
    }

    public static enum Alignment {
        ENEMY,
        NEUTRAL,
        ALLY;

    }
}

