/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.blobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Corrosion;
import com.shatteredpixel.shatteredpixeldungeon.effects.BlobEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.utils.Bundle;

public class CorrosiveGas
extends Blob {
    private int strength = 0;
    private static final String STRENGTH = "strength";

    @Override
    protected void evolve() {
        super.evolve();
        if (this.volume == 0) {
            this.strength = 0;
        } else {
            for (int i = this.area.left; i < this.area.right; ++i) {
                for (int j = this.area.top; j < this.area.bottom; ++j) {
                    Char ch;
                    int cell = i + j * Dungeon.level.width();
                    if (this.cur[cell] <= 0 || (ch = Actor.findChar(cell)) == null || ch.isImmune(this.getClass())) continue;
                    Buff.affect(ch, Corrosion.class).set(2.0f, this.strength);
                }
            }
        }
    }

    public CorrosiveGas setStrength(int str) {
        if (str > this.strength) {
            this.strength = str;
        }
        return this;
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.strength = bundle.getInt(STRENGTH);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(STRENGTH, this.strength);
    }

    @Override
    public void use(BlobEmitter emitter) {
        super.use(emitter);
        emitter.pour(Speck.factory(108), 0.4f);
    }

    @Override
    public String tileDesc() {
        return Messages.get(this, "desc", new Object[0]);
    }
}

