/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.blobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Bee;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Piranha;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Statue;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Wraith;
import com.shatteredpixel.shatteredpixeldungeon.effects.BlobEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SacrificialParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SacrificeRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class SacrificialFire
extends Blob {
    BlobEmitter curEmitter;
    private int bonusSpawns;
    private static final String BONUS_SPAWNS = "bonus_spawns";

    public SacrificialFire() {
        this.actPriority = -21;
        this.bonusSpawns = 3;
    }

    @Override
    protected void evolve() {
        for (int i = this.area.top - 1; i <= this.area.bottom; ++i) {
            for (int j = this.area.left - 1; j <= this.area.right; ++j) {
                int cell = j + i * Dungeon.level.width();
                if (!Dungeon.level.insideMap(cell)) continue;
                this.off[cell] = this.cur[cell];
                this.volume += this.off[cell];
                Char ch = Actor.findChar(cell);
                if (ch != null && this.off[cell] > 0) {
                    if (Dungeon.level.heroFOV[cell] && ch.buff(Marked.class) == null) {
                        CellEmitter.get(cell).burst(SacrificialParticle.FACTORY, 5);
                    }
                    Buff.prolong(ch, Marked.class, 2.0f);
                }
                if (this.off[cell] <= 0 || !Dungeon.level.heroFOV[cell] || Dungeon.level.mobCount() != 0 || this.bonusSpawns <= 0 || !Dungeon.level.spawnMob(4)) continue;
                --this.bonusSpawns;
            }
        }
        int max = 5 + Dungeon.depth * 5;
        this.curEmitter.pour(SacrificialParticle.FACTORY, 0.01f + (float)this.volume / (float)max * 0.09f);
    }

    @Override
    public void use(BlobEmitter emitter) {
        super.use(emitter);
        this.curEmitter = emitter;
        int max = 5 + Dungeon.depth * 5;
        this.curEmitter.pour(SacrificialParticle.FACTORY, 0.01f + (float)this.volume / (float)max * 0.09f);
    }

    @Override
    public String tileDesc() {
        return Messages.get(this, "desc", new Object[0]);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(BONUS_SPAWNS, this.bonusSpawns);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.bonusSpawns = bundle.getInt(BONUS_SPAWNS);
    }

    public static void sacrifice(Char ch) {
        SacrificialFire fire = (SacrificialFire)Dungeon.level.blobs.get(SacrificialFire.class);
        if (fire != null && fire.cur[ch.pos] > 0) {
            int exp = 0;
            if (ch instanceof Mob) {
                exp = ch instanceof Statue || ch instanceof Mimic ? 1 + Dungeon.depth : (ch instanceof Piranha || ch instanceof Bee ? 1 + Dungeon.depth / 2 : (ch instanceof Wraith ? 1 + Dungeon.depth / 3 : ((Mob)ch).EXP));
                exp *= Random.IntRange(2, 3);
            } else if (ch instanceof Hero) {
                exp = 1000000;
            }
            if (exp > 0) {
                int volume = fire.cur[ch.pos] - exp;
                if (volume > 0) {
                    int n = ch.pos;
                    fire.cur[n] = fire.cur[n] - exp;
                    fire.volume -= exp;
                    ++fire.bonusSpawns;
                    CellEmitter.get(ch.pos).burst(SacrificialParticle.FACTORY, 20);
                    Sample.INSTANCE.play("sounds/burning.mp3");
                    GLog.w(Messages.get(SacrificialFire.class, "worthy", new Object[0]), new Object[0]);
                } else {
                    fire.clear(ch.pos);
                    for (int i : PathFinder.NEIGHBOURS9) {
                        CellEmitter.get(ch.pos + i).burst(SacrificialParticle.FACTORY, 20);
                    }
                    Sample.INSTANCE.play("sounds/burning.mp3");
                    Sample.INSTANCE.play("sounds/burning.mp3");
                    Sample.INSTANCE.play("sounds/burning.mp3");
                    GLog.w(Messages.get(SacrificialFire.class, "reward", new Object[0]), new Object[0]);
                    Dungeon.level.drop((Item)SacrificeRoom.prize((Level)Dungeon.level), (int)ch.pos).sprite.drop();
                }
            } else {
                GLog.w(Messages.get(SacrificialFire.class, "unworthy", new Object[0]), new Object[0]);
            }
        }
    }

    public static class Marked
    extends FlavourBuff {
        public static final float DURATION = 2.0f;

        @Override
        public void detach() {
            if (!this.target.isAlive()) {
                SacrificialFire.sacrifice(this.target);
            }
            super.detach();
        }
    }
}

