/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShieldBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.items.BrokenSeal;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.GameMath;
import java.text.DecimalFormat;
import java.util.Iterator;

public class Berserk
extends Buff {
    private State state = State.NORMAL;
    private static final float LEVEL_RECOVER_START = 2.0f;
    private float levelRecovery;
    public int powerLossBuffer = 0;
    private float power = 0.0f;
    private static final String STATE = "state";
    private static final String LEVEL_RECOVERY = "levelrecovery";
    private static final String POWER = "power";
    private static final String POWER_BUFFER = "power_buffer";

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(STATE, this.state);
        bundle.put(POWER, this.power);
        bundle.put(POWER_BUFFER, this.powerLossBuffer);
        if (this.state == State.RECOVERING) {
            bundle.put(LEVEL_RECOVERY, this.levelRecovery);
        }
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.state = bundle.getEnum(STATE, State.class);
        this.power = bundle.getFloat(POWER);
        this.powerLossBuffer = bundle.getInt(POWER_BUFFER);
        if (this.state == State.RECOVERING) {
            this.levelRecovery = bundle.getFloat(LEVEL_RECOVERY);
        }
    }

    @Override
    public boolean act() {
        if (this.berserking()) {
            ShieldBuff buff = this.target.buff(BrokenSeal.WarriorShield.class);
            if (this.target.HP <= 0) {
                int dmg = 1 + (int)Math.ceil((float)this.target.shielding() * 0.05f);
                if (buff != null && buff.shielding() > 0) {
                    buff.absorbDamage(dmg);
                } else {
                    ShieldBuff s;
                    Iterator<ShieldBuff> iterator = this.target.buffs(ShieldBuff.class).iterator();
                    while (iterator.hasNext() && (dmg = (s = iterator.next()).absorbDamage(dmg)) != 0) {
                    }
                }
                if (this.target.shielding() <= 0) {
                    this.target.die(this);
                    if (!this.target.isAlive()) {
                        Dungeon.fail(this.getClass());
                    }
                }
            } else {
                this.state = State.RECOVERING;
                this.levelRecovery = 2.0f - (float)Dungeon.hero.pointsInTalent(Talent.BERSERKING_STAMINA) / 3.0f;
                if (buff != null) {
                    buff.absorbDamage(buff.shielding());
                }
                this.power = 0.0f;
            }
        } else if (this.state == State.NORMAL) {
            if (this.powerLossBuffer > 0) {
                --this.powerLossBuffer;
            } else {
                this.power = (float)((double)this.power - (double)(GameMath.gate(0.1f, this.power, 1.0f) * 0.067f) * Math.pow((float)this.target.HP / (float)this.target.HT, 2.0));
                if (this.power <= 0.0f) {
                    this.detach();
                }
            }
        }
        this.spend(1.0f);
        return true;
    }

    public float rageAmount() {
        return Math.min(1.0f, this.power);
    }

    public int damageFactor(int dmg) {
        float bonus = Math.min(1.5f, 1.0f + this.power / 2.0f);
        return Math.round((float)dmg * bonus);
    }

    public boolean berserking() {
        BrokenSeal.WarriorShield shield;
        if (this.target.HP == 0 && this.state == State.NORMAL && this.power >= 1.0f && (shield = this.target.buff(BrokenSeal.WarriorShield.class)) != null) {
            this.state = State.BERSERK;
            int shieldAmount = shield.maxShield() * 8;
            shieldAmount = Math.round((float)shieldAmount * (1.0f + (float)Dungeon.hero.pointsInTalent(Talent.BERSERKING_STAMINA) / 4.0f));
            shield.supercharge(shieldAmount);
            SpellSprite.show(this.target, 4);
            Sample.INSTANCE.play("sounds/challenge.mp3");
            GameScene.flash(0xFF0000);
        }
        return this.state == State.BERSERK && this.target.shielding() > 0;
    }

    public void damage(int damage) {
        if (this.state == State.RECOVERING) {
            return;
        }
        float maxPower = 1.0f + 0.1f * (float)((Hero)this.target).pointsInTalent(Talent.ENDLESS_RAGE);
        this.power = Math.min(maxPower, this.power + (float)damage / (float)this.target.HT / 3.0f);
        BuffIndicator.refreshHero();
        this.powerLossBuffer = 3;
    }

    public void recover(float percent) {
        if (this.levelRecovery > 0.0f) {
            this.levelRecovery -= percent;
            if (this.levelRecovery <= 0.0f) {
                this.state = State.NORMAL;
                this.levelRecovery = 0.0f;
            }
        }
    }

    @Override
    public int icon() {
        return 40;
    }

    @Override
    public void tintIcon(Image icon) {
        switch (this.state) {
            default: {
                if (this.power < 1.0f) {
                    icon.hardlight(1.0f, 0.5f, 0.0f);
                    break;
                }
                icon.hardlight(1.0f, 0.0f, 0.0f);
                break;
            }
            case BERSERK: {
                icon.hardlight(1.0f, 0.0f, 0.0f);
                break;
            }
            case RECOVERING: {
                icon.hardlight(0.0f, 0.0f, 1.0f);
            }
        }
    }

    @Override
    public float iconFadePercent() {
        switch (this.state) {
            default: {
                return Math.max(0.0f, 1.0f - this.power);
            }
            case BERSERK: {
                return 0.0f;
            }
            case RECOVERING: 
        }
        return 1.0f - this.levelRecovery / 2.0f;
    }

    @Override
    public String iconTextDisplay() {
        switch (this.state) {
            default: {
                return (int)(this.power * 100.0f) + "%";
            }
            case RECOVERING: 
        }
        return new DecimalFormat("#.#").format(this.levelRecovery);
    }

    public String toString() {
        switch (this.state) {
            default: {
                return Messages.get(this, "angered", new Object[0]);
            }
            case BERSERK: {
                return Messages.get(this, "berserk", new Object[0]);
            }
            case RECOVERING: 
        }
        return Messages.get(this, "recovering", new Object[0]);
    }

    @Override
    public String desc() {
        float dispDamage = (float)this.damageFactor(10000) / 100.0f - 100.0f;
        switch (this.state) {
            default: {
                return Messages.get(this, "angered_desc", Math.floor(this.power * 100.0f), Float.valueOf(dispDamage));
            }
            case BERSERK: {
                return Messages.get(this, "berserk_desc", new Object[0]);
            }
            case RECOVERING: 
        }
        return Messages.get(this, "recovering_desc", Float.valueOf(this.levelRecovery));
    }

    private static enum State {
        NORMAL,
        BERSERK,
        RECOVERING;

    }
}

