/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SoulMark;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;

public class Corruption
extends AllyBuff {
    private float buildToDamage;

    public Corruption() {
        this.type = Buff.buffType.NEGATIVE;
        this.announced = true;
        this.buildToDamage = 0.0f;
    }

    public static void corruptionHeal(Char target) {
        target.HP = target.HT;
        for (Buff buff : target.buffs()) {
            if (buff.type != Buff.buffType.NEGATIVE || buff instanceof SoulMark) continue;
            buff.detach();
        }
    }

    @Override
    public boolean act() {
        this.buildToDamage += (float)this.target.HT / 200.0f;
        int damage = (int)this.buildToDamage;
        this.buildToDamage -= (float)damage;
        if (damage > 0) {
            this.target.damage(damage, this);
        }
        this.spend(1.0f);
        return true;
    }

    @Override
    public void fx(boolean on) {
        if (on) {
            this.target.sprite.add(CharSprite.State.DARKENED);
        } else if (this.target.invisible == 0) {
            this.target.sprite.remove(CharSprite.State.DARKENED);
        }
    }

    @Override
    public int icon() {
        return 36;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", new Object[0]);
    }
}

