/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Chill;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Frost;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SnowParticle;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;

public class FrostImbue
extends FlavourBuff {
    public static final float DURATION = 50.0f;

    public FrostImbue() {
        this.type = Buff.buffType.POSITIVE;
        this.announced = true;
        this.immunities.add(Frost.class);
        this.immunities.add(Chill.class);
    }

    public void proc(Char enemy) {
        Buff.affect(enemy, Chill.class, 2.0f);
        enemy.sprite.emitter().burst(SnowParticle.FACTORY, 2);
    }

    @Override
    public int icon() {
        return 15;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (50.0f - this.visualcooldown()) / 50.0f);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.dispTurns());
    }
}

