/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.watabou.utils.Bundle;
import com.watabou.utils.GameMath;

public class Healing
extends Buff {
    private int healingLeft;
    private float percentHealPerTick;
    private int flatHealPerTick;
    private static final String LEFT = "left";
    private static final String PERCENT = "percent";
    private static final String FLAT = "flat";

    public Healing() {
        this.actPriority = -1;
        this.type = Buff.buffType.POSITIVE;
    }

    @Override
    public boolean act() {
        this.target.HP = Math.min(this.target.HT, this.target.HP + this.healingThisTick());
        if (this.target.HP == this.target.HT && this.target instanceof Hero) {
            ((Hero)this.target).resting = false;
        }
        this.healingLeft -= this.healingThisTick();
        if (this.healingLeft <= 0) {
            this.detach();
        }
        this.spend(1.0f);
        return true;
    }

    private int healingThisTick() {
        return (int)GameMath.gate(1.0f, Math.round((float)this.healingLeft * this.percentHealPerTick) + this.flatHealPerTick, this.healingLeft);
    }

    public void setHeal(int amount, float percentPerTick, int flatPerTick) {
        this.healingLeft = amount;
        this.percentHealPerTick = percentPerTick;
        this.flatHealPerTick = flatPerTick;
    }

    public void increaseHeal(int amount) {
        this.healingLeft += amount;
    }

    @Override
    public void fx(boolean on) {
        if (on) {
            this.target.sprite.add(CharSprite.State.HEALING);
        } else {
            this.target.sprite.remove(CharSprite.State.HEALING);
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(LEFT, this.healingLeft);
        bundle.put(PERCENT, this.percentHealPerTick);
        bundle.put(FLAT, this.flatHealPerTick);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.healingLeft = bundle.getInt(LEFT);
        this.percentHealPerTick = bundle.getFloat(PERCENT);
        this.flatHealPerTick = bundle.getInt(FLAT);
    }

    @Override
    public int icon() {
        return 44;
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString(this.healingLeft);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.healingThisTick(), this.healingLeft);
    }
}

