/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LockedFloor;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.ChaliceOfBlood;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfEnergy;

public class Regeneration
extends Buff {
    private static final float REGENERATION_DELAY = 10.0f;

    public Regeneration() {
        this.actPriority = -1;
    }

    @Override
    public boolean act() {
        if (this.target.isAlive()) {
            if (this.target.HP < this.regencap() && !((Hero)this.target).isStarving()) {
                LockedFloor lock = this.target.buff(LockedFloor.class);
                if (this.target.HP > 0 && (lock == null || lock.regenOn())) {
                    ++this.target.HP;
                    if (this.target.HP == this.regencap()) {
                        ((Hero)this.target).resting = false;
                    }
                }
            }
            ChaliceOfBlood.chaliceRegen regenBuff = Dungeon.hero.buff(ChaliceOfBlood.chaliceRegen.class);
            float delay = 10.0f;
            if (regenBuff != null) {
                if (regenBuff.isCursed()) {
                    delay *= 1.5f;
                } else {
                    delay -= (float)regenBuff.itemLevel() * 0.9f;
                    delay /= RingOfEnergy.artifactChargeMultiplier(this.target);
                }
            }
            this.spend(delay);
        } else {
            this.diactivate();
        }
        return true;
    }

    public int regencap() {
        return this.target.HT;
    }
}

