/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.utils.Bundle;

public class WellFed
extends Buff {
    int left;
    private static final String LEFT = "left";

    public WellFed() {
        this.type = Buff.buffType.POSITIVE;
        this.announced = true;
    }

    @Override
    public boolean act() {
        --this.left;
        if (this.left < 0) {
            this.detach();
            return true;
        }
        if (this.left % 18 == 0) {
            this.target.HP = Math.min(this.target.HT, this.target.HP + 1);
        }
        this.spend(1.0f);
        return true;
    }

    public void reset() {
        this.left = 450;
        if (Dungeon.isChallenged(1)) {
            this.left /= 3;
        }
    }

    @Override
    public int icon() {
        return 43;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (450.0f - (float)this.left) / 450.0f);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString(this.left);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.left + 1);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(LEFT, this.left);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.left = bundle.getInt(LEFT);
    }
}

