/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LostInventory;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.KindofMisc;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRemoveCurse;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Iterator;

public class Belongings
implements Iterable<Item> {
    private Hero owner;
    public Backpack backpack;
    public KindOfWeapon weapon = null;
    public Armor armor = null;
    public Artifact artifact = null;
    public KindofMisc misc = null;
    public Ring ring = null;
    public KindOfWeapon thrownWeapon = null;
    private static final String WEAPON = "weapon";
    private static final String ARMOR = "armor";
    private static final String ARTIFACT = "artifact";
    private static final String MISC = "misc";
    private static final String RING = "ring";

    public Belongings(Hero owner) {
        this.owner = owner;
        this.backpack = new Backpack();
        this.backpack.owner = owner;
    }

    public KindOfWeapon weapon() {
        boolean lostInvent;
        if (this.thrownWeapon != null) {
            return this.thrownWeapon;
        }
        boolean bl = lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        if (!lostInvent || this.weapon != null && this.weapon.keptThoughLostInvent) {
            return this.weapon;
        }
        return null;
    }

    public Armor armor() {
        boolean lostInvent;
        boolean bl = lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        if (!lostInvent || this.armor != null && this.armor.keptThoughLostInvent) {
            return this.armor;
        }
        return null;
    }

    public Artifact artifact() {
        boolean lostInvent;
        boolean bl = lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        if (!lostInvent || this.artifact != null && this.artifact.keptThoughLostInvent) {
            return this.artifact;
        }
        return null;
    }

    public KindofMisc misc() {
        boolean lostInvent;
        boolean bl = lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        if (!lostInvent || this.misc != null && this.misc.keptThoughLostInvent) {
            return this.misc;
        }
        return null;
    }

    public Ring ring() {
        boolean lostInvent;
        boolean bl = lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        if (!lostInvent || this.ring != null && this.ring.keptThoughLostInvent) {
            return this.ring;
        }
        return null;
    }

    public void storeInBundle(Bundle bundle) {
        this.backpack.storeInBundle(bundle);
        bundle.put(WEAPON, this.weapon);
        bundle.put(ARMOR, this.armor);
        bundle.put(ARTIFACT, this.artifact);
        bundle.put(MISC, this.misc);
        bundle.put(RING, this.ring);
    }

    public void restoreFromBundle(Bundle bundle) {
        this.backpack.clear();
        this.backpack.restoreFromBundle(bundle);
        this.weapon = (KindOfWeapon)bundle.get(WEAPON);
        if (this.weapon() != null) {
            this.weapon().activate(this.owner);
        }
        this.armor = (Armor)bundle.get(ARMOR);
        if (this.armor() != null) {
            this.armor().activate(this.owner);
        }
        this.artifact = (Artifact)bundle.get(ARTIFACT);
        if (this.artifact() != null) {
            this.artifact().activate(this.owner);
        }
        this.misc = (KindofMisc)bundle.get(MISC);
        if (this.misc() != null) {
            this.misc().activate(this.owner);
        }
        this.ring = (Ring)bundle.get(RING);
        if (this.ring() != null) {
            this.ring().activate(this.owner);
        }
    }

    public static void preview(GamesInProgress.Info info, Bundle bundle) {
        Armor armor;
        info.armorTier = bundle.contains(ARMOR) ? ((armor = (Armor)bundle.get(ARMOR)) instanceof ClassArmor ? 6 : armor.tier) : 0;
    }

    public ArrayList<Bag> getBags() {
        ArrayList<Bag> result = new ArrayList<Bag>();
        result.add(this.backpack);
        for (Item i : this) {
            if (!(i instanceof Bag)) continue;
            result.add((Bag)i);
        }
        return result;
    }

    public <T extends Item> T getItem(Class<T> itemClass) {
        boolean lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        for (Item item : this) {
            if (!itemClass.isInstance(item) || lostInvent && !item.keptThoughLostInvent) continue;
            return (T)item;
        }
        return null;
    }

    public <T extends Item> ArrayList<T> getAllItems(Class<T> itemClass) {
        ArrayList<Item> result = new ArrayList<Item>();
        boolean lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        for (Item item : this) {
            if (!itemClass.isInstance(item) || lostInvent && !item.keptThoughLostInvent) continue;
            result.add(item);
        }
        return result;
    }

    public boolean contains(Item contains) {
        boolean lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        for (Item item : this) {
            if (contains != item || lostInvent && !item.keptThoughLostInvent) continue;
            return true;
        }
        return false;
    }

    public Item getSimilar(Item similar) {
        boolean lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        for (Item item : this) {
            if (similar == item || !similar.isSimilar(item) || lostInvent && !item.keptThoughLostInvent) continue;
            return item;
        }
        return null;
    }

    public ArrayList<Item> getAllSimilar(Item similar) {
        ArrayList<Item> result = new ArrayList<Item>();
        boolean lostInvent = this.owner != null && this.owner.buff(LostInventory.class) != null;
        for (Item item : this) {
            if (item == similar || !similar.isSimilar(item) || lostInvent && !item.keptThoughLostInvent) continue;
            result.add(item);
        }
        return result;
    }

    public void identify() {
        for (Item item : this) {
            item.identify();
        }
    }

    public void observe() {
        if (this.weapon() != null) {
            this.weapon().identify();
            Badges.validateItemLevelAquired(this.weapon());
        }
        if (this.armor() != null) {
            this.armor().identify();
            Badges.validateItemLevelAquired(this.armor());
        }
        if (this.artifact() != null) {
            this.artifact().identify();
            Badges.validateItemLevelAquired(this.artifact());
        }
        if (this.misc() != null) {
            this.misc().identify();
            Badges.validateItemLevelAquired(this.misc());
        }
        if (this.ring() != null) {
            this.ring().identify();
            Badges.validateItemLevelAquired(this.ring());
        }
        for (Item item : this.backpack) {
            if (!(item instanceof EquipableItem) && !(item instanceof Wand)) continue;
            item.cursedKnown = true;
        }
        Item.updateQuickslot();
    }

    public void uncurseEquipped() {
        ScrollOfRemoveCurse.uncurse(this.owner, this.armor(), this.weapon(), this.artifact(), this.misc(), this.ring());
    }

    public Item randomUnequipped() {
        if (this.owner.buff(LostInventory.class) != null) {
            return null;
        }
        return (Item)Random.element(this.backpack.items);
    }

    public int charge(float charge) {
        int count = 0;
        for (Wand.Charger charger : this.owner.buffs(Wand.Charger.class)) {
            charger.gainCharge(charge);
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ItemIterator();
    }

    private class ItemIterator
    implements Iterator<Item> {
        private int index = 0;
        private Iterator<Item> backpackIterator;
        private Item[] equipped;
        private int backpackIndex;

        private ItemIterator() {
            this.backpackIterator = Belongings.this.backpack.iterator();
            this.equipped = new Item[]{Belongings.this.weapon, Belongings.this.armor, Belongings.this.artifact, Belongings.this.misc, Belongings.this.ring};
            this.backpackIndex = this.equipped.length;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.index; i < this.backpackIndex; ++i) {
                if (this.equipped[i] == null) continue;
                return true;
            }
            return this.backpackIterator.hasNext();
        }

        @Override
        public Item next() {
            while (this.index < this.backpackIndex) {
                Item item;
                if ((item = this.equipped[this.index++]) == null) continue;
                return item;
            }
            return this.backpackIterator.next();
        }

        @Override
        public void remove() {
            switch (this.index) {
                case 0: {
                    Belongings.this.weapon = null;
                    this.equipped[0] = null;
                    break;
                }
                case 1: {
                    Belongings.this.armor = null;
                    this.equipped[1] = null;
                    break;
                }
                case 2: {
                    Belongings.this.artifact = null;
                    this.equipped[2] = null;
                    break;
                }
                case 3: {
                    Belongings.this.misc = null;
                    this.equipped[3] = null;
                    break;
                }
                case 4: {
                    Belongings.this.ring = null;
                    this.equipped[4] = null;
                    break;
                }
                default: {
                    this.backpackIterator.remove();
                }
            }
        }
    }

    public static class Backpack
    extends Bag {
        @Override
        public int capacity() {
            int cap = super.capacity();
            for (Item item : this.items) {
                if (!(item instanceof Bag)) continue;
                ++cap;
            }
            return cap;
        }
    }
}

