/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Bones;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AdrenalineSurge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Amok;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AnkhInvulnerability;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Awareness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barkskin;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Berserk;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Combo;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Drowsy;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Foresight;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.HoldFast;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Hunger;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LostInventory;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MindVision;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Regeneration;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SnipersMark;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vertigo;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroAction;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.huntress.NaturesPower;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.warrior.Endure;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Monk;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Snake;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.CheckedCell;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.items.Amulet;
import com.shatteredpixel.shatteredpixeldungeon.items.Ankh;
import com.shatteredpixel.shatteredpixeldungeon.items.Dewdrop;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.AntiMagic;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.Brimstone;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.Viscosity;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.AlchemistsToolkit;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.CapeOfThorns;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.CloakOfShadows;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.DriedRose;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.EtherealChains;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.HornOfPlenty;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.MasterThievesArmband;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TalismanOfForesight;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TimekeepersHourglass;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.MagicalHolster;
import com.shatteredpixel.shatteredpixeldungeon.items.journal.Guidebook;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.CrystalKey;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.GoldenKey;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.IronKey;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.Key;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.SkeletonKey;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfExperience;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs.ElixirOfMight;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfDivineInspiration;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfAccuracy;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfEvasion;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfForce;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfFuror;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfHaste;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfMight;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfTenacity;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.Scroll;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfMagicMapping;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfChallenge;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLivingEarth;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Flail;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.Terrain;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Chasm;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.ShadowCaster;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Earthroot;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.shatteredpixel.shatteredpixeldungeon.scenes.AlchemyScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.SurfaceScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.HeroSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickSlotButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.StatusPane;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndHero;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndMessage;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndResurrect;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTradeItem;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.GameMath;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;

public class Hero
extends Char {
    public static final int MAX_LEVEL = 30;
    public static final int STARTING_STR = 10;
    private static final float TIME_TO_REST = 1.0f;
    private static final float TIME_TO_SEARCH = 2.0f;
    private static final float HUNGER_FOR_SEARCH = 6.0f;
    public HeroClass heroClass;
    public HeroSubClass subClass;
    public ArmorAbility armorAbility;
    public ArrayList<LinkedHashMap<Talent, Integer>> talents;
    public LinkedHashMap<Talent, Talent> metamorphedTalents;
    private int attackSkill;
    private int defenseSkill;
    public boolean ready;
    private boolean damageInterrupt;
    public HeroAction curAction;
    public HeroAction lastAction;
    private Char enemy;
    public boolean resting;
    public Belongings belongings;
    public int STR;
    public float awareness;
    public int lvl;
    public int exp;
    public int HTBoost;
    private ArrayList<Mob> visibleEnemies;
    public ArrayList<Mob> mindVisionEnemies;
    private String name;
    public LinkedHashMap<String, Integer> upgrades;
    public LinkedHashMap<Integer, LinkedHashMap<String, Integer>> crafted;
    private static final String CLASS = "class";
    private static final String SUBCLASS = "subClass";
    private static final String ABILITY = "armorAbility";
    private static final String ATTACK = "attackSkill";
    private static final String DEFENSE = "defenseSkill";
    private static final String STRENGTH = "STR";
    private static final String LEVEL = "lvl";
    private static final String EXPERIENCE = "exp";
    private static final String HTBOOST = "htboost";
    private boolean walkingToVisibleTrapInFog;
    public boolean justMoved;
    private Berserk berserk;

    public void trackUpgrade(Item item, int amt) {
        this.trackUpgrade(item.analyticsName(), amt);
    }

    public void trackUpgrade(String name, int amt) {
        if (Statistics.deepestFloor > 25) {
            return;
        }
        if (this.upgrades.containsKey(name)) {
            this.upgrades.put(name, this.upgrades.get(name) + amt);
        } else {
            this.upgrades.put(name, amt);
        }
    }

    public void trackCraft(Item item, int amt) {
        this.trackCraft(item.analyticsName(), amt);
    }

    public void trackCraft(String name, int amt) {
        LinkedHashMap<Object, Object> craftsThisRegion;
        if (Statistics.deepestFloor > 25) {
            return;
        }
        int region = (int)Math.ceil((float)Statistics.deepestFloor / 5.0f);
        if (this.crafted.containsKey(region)) {
            craftsThisRegion = this.crafted.get(region);
        } else {
            craftsThisRegion = new LinkedHashMap();
            this.crafted.put(region, craftsThisRegion);
        }
        if (craftsThisRegion.containsKey(name)) {
            craftsThisRegion.put(name, (Integer)craftsThisRegion.get(name) + amt);
        } else {
            craftsThisRegion.put(name, amt);
        }
    }

    public Hero() {
        this.actPriority = 0;
        this.alignment = Char.Alignment.ALLY;
        this.heroClass = HeroClass.ROGUE;
        this.subClass = HeroSubClass.NONE;
        this.armorAbility = null;
        this.talents = new ArrayList();
        this.metamorphedTalents = new LinkedHashMap();
        this.attackSkill = 10;
        this.defenseSkill = 5;
        this.ready = false;
        this.damageInterrupt = true;
        this.curAction = null;
        this.lastAction = null;
        this.resting = false;
        this.lvl = 1;
        this.exp = 0;
        this.HTBoost = 0;
        this.mindVisionEnemies = new ArrayList();
        this.name = SPDSettings.heroName();
        this.upgrades = new LinkedHashMap();
        this.crafted = new LinkedHashMap();
        this.walkingToVisibleTrapInFog = false;
        this.justMoved = false;
        this.HT = 20;
        this.HP = 20;
        this.STR = 10;
        this.belongings = new Belongings(this);
        this.visibleEnemies = new ArrayList();
    }

    public void updateHT(boolean boostHP) {
        int curHT = this.HT;
        this.HT = 20 + 5 * (this.lvl - 1) + this.HTBoost;
        float multiplier = RingOfMight.HTMultiplier(this);
        this.HT = Math.round(multiplier * (float)this.HT);
        if (this.buff(ElixirOfMight.HTBoost.class) != null) {
            this.HT += this.buff(ElixirOfMight.HTBoost.class).boost();
        }
        if (boostHP) {
            this.HP += Math.max(this.HT - curHT, 0);
        }
        this.HP = Math.min(this.HP, this.HT);
    }

    public int STR() {
        int strBonus = 0;
        strBonus += RingOfMight.strengthBonus(this);
        AdrenalineSurge buff = this.buff(AdrenalineSurge.class);
        if (buff != null) {
            strBonus += buff.boost();
        }
        if (this.hasTalent(Talent.STRONGMAN)) {
            strBonus += (int)Math.floor((float)this.STR * (0.03f + 0.05f * (float)this.pointsInTalent(Talent.STRONGMAN)));
        }
        return this.STR + strBonus;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(CLASS, this.heroClass);
        bundle.put(SUBCLASS, this.subClass);
        bundle.put(ABILITY, this.armorAbility);
        Talent.storeTalentsInBundle(bundle, this);
        bundle.put(ATTACK, this.attackSkill);
        bundle.put(DEFENSE, this.defenseSkill);
        bundle.put(STRENGTH, this.STR);
        bundle.put(LEVEL, this.lvl);
        bundle.put(EXPERIENCE, this.exp);
        bundle.put(HTBOOST, this.HTBoost);
        if (!this.name.equals("")) {
            bundle.put("name", this.name);
        }
        bundle.put("up_names", this.upgrades.keySet().toArray(new String[0]));
        int[] upVals = new int[this.upgrades.size()];
        int i = 0;
        for (Integer val : this.upgrades.values()) {
            upVals[i] = val;
            ++i;
        }
        bundle.put("up_vals", upVals);
        for (int region : this.crafted.keySet()) {
            bundle.put("craft_names_" + region, this.crafted.get(region).keySet().toArray(new String[0]));
            int[] craftVals = new int[this.crafted.get(region).size()];
            i = 0;
            for (Integer val : this.crafted.get(region).values()) {
                craftVals[i] = val;
                ++i;
            }
            bundle.put("craft_vals_" + region, craftVals);
        }
        this.belongings.storeInBundle(bundle);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        this.lvl = bundle.getInt(LEVEL);
        this.exp = bundle.getInt(EXPERIENCE);
        this.HTBoost = bundle.getInt(HTBOOST);
        super.restoreFromBundle(bundle);
        this.heroClass = bundle.getEnum(CLASS, HeroClass.class);
        this.subClass = bundle.getEnum(SUBCLASS, HeroSubClass.class);
        this.armorAbility = (ArmorAbility)bundle.get(ABILITY);
        Talent.restoreTalentsFromBundle(bundle, this);
        this.attackSkill = bundle.getInt(ATTACK);
        this.defenseSkill = bundle.getInt(DEFENSE);
        this.STR = bundle.getInt(STRENGTH);
        String string = this.name = bundle.contains("name") ? bundle.getString("name") : "";
        if (bundle.contains("up_names")) {
            String[] upNames = bundle.getStringArray("up_names");
            int[] upVals = bundle.getIntArray("up_vals");
            for (int i = 0; i < upNames.length && i < upVals.length; ++i) {
                this.upgrades.put(upNames[i], upVals[i]);
            }
        }
        for (int region = 1; region <= 5; ++region) {
            if (!bundle.contains("craft_names_" + region)) continue;
            String[] craftNames = bundle.getStringArray("craft_names_" + region);
            int[] craftVals = bundle.getIntArray("craft_vals_" + region);
            LinkedHashMap<String, Integer> craftsInRegion = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < craftNames.length && i < craftVals.length; ++i) {
                craftsInRegion.put(craftNames[i], craftVals[i]);
            }
            this.crafted.put(region, craftsInRegion);
        }
        this.belongings.restoreFromBundle(bundle);
    }

    public static void preview(GamesInProgress.Info info, Bundle bundle) {
        info.level = bundle.getInt(LEVEL);
        info.str = bundle.getInt(STRENGTH);
        info.exp = bundle.getInt(EXPERIENCE);
        info.hp = bundle.getInt("HP");
        info.ht = bundle.getInt("HT");
        info.shld = bundle.getInt("SHLD");
        info.heroClass = bundle.getEnum(CLASS, HeroClass.class);
        info.subClass = bundle.getEnum(SUBCLASS, HeroSubClass.class);
        Belongings.preview(info, bundle);
        info.name = bundle.contains("name") ? bundle.getString("name") : "";
    }

    public boolean hasTalent(Talent talent) {
        return this.pointsInTalent(talent) > 0;
    }

    public int pointsInTalent(Talent talent) {
        for (LinkedHashMap<Talent, Integer> tier : this.talents) {
            for (Talent f : tier.keySet()) {
                if (f != talent) continue;
                return tier.get((Object)f);
            }
        }
        return 0;
    }

    public void upgradeTalent(Talent talent) {
        for (LinkedHashMap<Talent, Integer> tier : this.talents) {
            for (Talent f : tier.keySet()) {
                if (f != talent) continue;
                tier.put(talent, tier.get((Object)talent) + 1);
            }
        }
        Talent.onTalentUpgraded(this, talent);
    }

    public int talentPointsSpent(int tier) {
        int total = 0;
        for (int i : this.talents.get(tier - 1).values()) {
            total += i;
        }
        return total;
    }

    public int talentPointsAvailable(int tier) {
        if (this.lvl < Talent.tierLevelThresholds[tier] - 1 || tier == 3 && this.subClass == HeroSubClass.NONE || tier == 4 && this.armorAbility == null) {
            return 0;
        }
        if (this.lvl >= Talent.tierLevelThresholds[tier + 1]) {
            return Talent.tierLevelThresholds[tier + 1] - Talent.tierLevelThresholds[tier] - this.talentPointsSpent(tier) + this.bonusTalentPoints(tier);
        }
        return 1 + this.lvl - Talent.tierLevelThresholds[tier] - this.talentPointsSpent(tier) + this.bonusTalentPoints(tier);
    }

    public int bonusTalentPoints(int tier) {
        if (this.lvl < Talent.tierLevelThresholds[tier] - 1 || tier == 3 && this.subClass == HeroSubClass.NONE || tier == 4 && this.armorAbility == null) {
            return 0;
        }
        if (this.buff(PotionOfDivineInspiration.DivineInspirationTracker.class) != null && this.buff(PotionOfDivineInspiration.DivineInspirationTracker.class).isBoosted(tier)) {
            return 2;
        }
        return 0;
    }

    public String className() {
        return this.subClass == null || this.subClass == HeroSubClass.NONE ? this.heroClass.title() : this.subClass.title();
    }

    @Override
    public String name() {
        return this.name.equals("") ? this.className() : this.name;
    }

    @Override
    public void hitSound(float pitch) {
        if (this.belongings.weapon() != null) {
            this.belongings.weapon().hitSound(pitch);
        } else if (RingOfForce.getBuffedBonus(this, RingOfForce.Force.class) > 0) {
            super.hitSound(pitch * GameMath.gate(0.75f, 1.25f - 0.025f * (float)this.STR(), 1.0f));
        } else {
            super.hitSound(pitch * 1.1f);
        }
    }

    @Override
    public boolean blockSound(float pitch) {
        if (this.belongings.weapon() != null && this.belongings.weapon().defenseFactor(this) >= 4) {
            Sample.INSTANCE.play("sounds/hit_parry.mp3", 1.0f, pitch);
            return true;
        }
        return super.blockSound(pitch);
    }

    public void live() {
        for (Buff b : this.buffs()) {
            if (b.revivePersists) continue;
            b.detach();
        }
        Buff.affect(this, Regeneration.class);
        Buff.affect(this, Hunger.class);
    }

    public int tier() {
        if (this.belongings.armor() instanceof ClassArmor) {
            return 6;
        }
        if (this.belongings.armor() != null) {
            return this.belongings.armor().tier;
        }
        return 0;
    }

    public boolean shoot(Char enemy, MissileWeapon wep) {
        this.enemy = enemy;
        this.belongings.thrownWeapon = wep;
        boolean hit = this.attack(enemy);
        Invisibility.dispel();
        this.belongings.thrownWeapon = null;
        if (hit && this.subClass == HeroSubClass.GLADIATOR) {
            Buff.affect(this, Combo.class).hit(enemy);
        }
        return hit;
    }

    @Override
    public int attackSkill(Char target) {
        KindOfWeapon wep = this.belongings.weapon();
        float accuracy = 1.0f;
        accuracy *= RingOfAccuracy.accuracyMultiplier(this);
        if (wep instanceof MissileWeapon) {
            accuracy = Dungeon.level.adjacent(this.pos, target.pos) ? (accuracy *= 0.5f + 0.2f * (float)this.pointsInTalent(Talent.POINT_BLANK)) : (accuracy *= 1.5f);
        }
        if (wep != null) {
            return (int)((float)this.attackSkill * accuracy * wep.accuracyFactor(this));
        }
        return (int)((float)this.attackSkill * accuracy);
    }

    @Override
    public int defenseSkill(Char enemy) {
        if (this.buff(Combo.ParryTracker.class) != null) {
            if (this.canAttack(enemy)) {
                Buff.affect((Char)this, Combo.RiposteTracker.class).enemy = enemy;
            }
            return INFINITE_EVASION;
        }
        float evasion = this.defenseSkill;
        evasion *= RingOfEvasion.evasionMultiplier(this);
        if (this.paralysed > 0) {
            evasion /= 2.0f;
        }
        if (this.belongings.armor() != null) {
            evasion = this.belongings.armor().evasionFactor(this, evasion);
        }
        return Math.round(evasion);
    }

    @Override
    public String defenseVerb() {
        Combo.ParryTracker parry = this.buff(Combo.ParryTracker.class);
        if (parry == null) {
            return super.defenseVerb();
        }
        parry.parried = true;
        if (this.buff(Combo.class).getComboCount() < 9 || this.pointsInTalent(Talent.ENHANCED_COMBO) < 2) {
            parry.detach();
        }
        return Messages.get(Monk.class, "parried", new Object[0]);
    }

    @Override
    public int drRoll() {
        int dr = 0;
        if (this.belongings.armor() != null) {
            int armDr = Random.NormalIntRange(this.belongings.armor().DRMin(), this.belongings.armor().DRMax());
            if (this.STR() < this.belongings.armor().STRReq()) {
                armDr -= 2 * (this.belongings.armor().STRReq() - this.STR());
            }
            if (armDr > 0) {
                dr += armDr;
            }
        }
        if (this.belongings.weapon() != null) {
            int wepDr = Random.NormalIntRange(0, this.belongings.weapon().defenseFactor(this));
            if (this.STR() < ((Weapon)this.belongings.weapon()).STRReq()) {
                wepDr -= 2 * (((Weapon)this.belongings.weapon()).STRReq() - this.STR());
            }
            if (wepDr > 0) {
                dr += wepDr;
            }
        }
        if (this.buff(HoldFast.class) != null) {
            dr += Random.NormalIntRange(0, 2 * this.pointsInTalent(Talent.HOLD_FAST));
        }
        return dr;
    }

    @Override
    public int damageRoll() {
        int dmg;
        KindOfWeapon wep = this.belongings.weapon();
        if (wep != null) {
            dmg = wep.damageRoll(this);
            if (!(wep instanceof MissileWeapon)) {
                dmg += RingOfForce.armedDamageBonus(this);
            }
        } else {
            dmg = RingOfForce.damageRoll(this);
        }
        if (dmg < 0) {
            dmg = 0;
        }
        return dmg;
    }

    @Override
    public float speed() {
        Momentum momentum;
        float speed = super.speed();
        speed *= RingOfHaste.speedMultiplier(this);
        if (this.belongings.armor() != null) {
            speed = this.belongings.armor().speedFactor(this, speed);
        }
        if ((momentum = this.buff(Momentum.class)) != null) {
            ((HeroSprite)this.sprite).sprint(momentum.freerunning() ? 1.5f : 1.0f);
            speed *= momentum.speedMultiplier();
        } else {
            ((HeroSprite)this.sprite).sprint(1.0f);
        }
        NaturesPower.naturesPowerTracker natStrength = this.buff(NaturesPower.naturesPowerTracker.class);
        if (natStrength != null) {
            speed *= 2.0f + 0.25f * (float)this.pointsInTalent(Talent.GROWING_POWER);
        }
        return speed;
    }

    public boolean canSurpriseAttack() {
        if (this.belongings.weapon() == null || !(this.belongings.weapon() instanceof Weapon)) {
            return true;
        }
        if (this.STR() < ((Weapon)this.belongings.weapon()).STRReq()) {
            return false;
        }
        return !(this.belongings.weapon() instanceof Flail);
    }

    public boolean canAttack(Char enemy) {
        if (enemy == null || this.pos == enemy.pos || !Actor.chars().contains(enemy)) {
            return false;
        }
        if (Dungeon.level.adjacent(this.pos, enemy.pos)) {
            return true;
        }
        KindOfWeapon wep = Dungeon.hero.belongings.weapon();
        if (wep != null) {
            return wep.canReach(this, enemy.pos);
        }
        return false;
    }

    public float attackDelay() {
        if (this.buff(Talent.LethalMomentumTracker.class) != null) {
            this.buff(Talent.LethalMomentumTracker.class).detach();
            return 0.0f;
        }
        if (this.belongings.weapon() != null) {
            return this.belongings.weapon().delayFactor(this);
        }
        return 1.0f / RingOfFuror.attackSpeedMultiplier(this);
    }

    @Override
    public void spend(float time) {
        this.justMoved = false;
        TimekeepersHourglass.timeFreeze freeze = this.buff(TimekeepersHourglass.timeFreeze.class);
        if (freeze != null) {
            freeze.processTime(time);
            return;
        }
        Swiftthistle.TimeBubble bubble = this.buff(Swiftthistle.TimeBubble.class);
        if (bubble != null) {
            bubble.processTime(time);
            return;
        }
        super.spend(time);
    }

    public void spendAndNext(float time) {
        this.busy();
        this.spend(time);
        this.next();
    }

    @Override
    public boolean act() {
        boolean actResult;
        this.fieldOfView = Dungeon.level.heroFOV;
        if (this.buff(Endure.EndureTracker.class) != null) {
            this.buff(Endure.EndureTracker.class).endEnduring();
        }
        if (!this.ready) {
            if (!this.resting || this.buff(MindVision.class) != null || this.buff(Awareness.class) != null) {
                Dungeon.observe();
            } else {
                Dungeon.level.updateFieldOfView(this, this.fieldOfView);
            }
        }
        this.checkVisibleMobs();
        BuffIndicator.refreshHero();
        if (this.paralysed > 0) {
            this.curAction = null;
            this.spendAndNext(1.0f);
            return false;
        }
        if (this.curAction == null) {
            if (this.resting) {
                this.spend(1.0f);
                this.next();
            } else {
                this.ready();
            }
            actResult = false;
        } else {
            this.resting = false;
            this.ready = false;
            actResult = this.curAction instanceof HeroAction.Move ? this.actMove((HeroAction.Move)this.curAction) : (this.curAction instanceof HeroAction.Interact ? this.actInteract((HeroAction.Interact)this.curAction) : (this.curAction instanceof HeroAction.Buy ? this.actBuy((HeroAction.Buy)this.curAction) : (this.curAction instanceof HeroAction.PickUp ? this.actPickUp((HeroAction.PickUp)this.curAction) : (this.curAction instanceof HeroAction.OpenChest ? this.actOpenChest((HeroAction.OpenChest)this.curAction) : (this.curAction instanceof HeroAction.Unlock ? this.actUnlock((HeroAction.Unlock)this.curAction) : (this.curAction instanceof HeroAction.Descend ? this.actDescend((HeroAction.Descend)this.curAction) : (this.curAction instanceof HeroAction.Ascend ? this.actAscend((HeroAction.Ascend)this.curAction) : (this.curAction instanceof HeroAction.Attack ? this.actAttack((HeroAction.Attack)this.curAction) : (this.curAction instanceof HeroAction.Alchemy ? this.actAlchemy((HeroAction.Alchemy)this.curAction) : false)))))))));
        }
        if (this.hasTalent(Talent.BARKSKIN) && Dungeon.level.map[this.pos] == 30) {
            Buff.affect(this, Barkskin.class).set(this.lvl * this.pointsInTalent(Talent.BARKSKIN) / 2, 1);
        }
        return actResult;
    }

    public void busy() {
        this.ready = false;
    }

    private void ready() {
        if (this.sprite.looping()) {
            this.sprite.idle();
        }
        this.curAction = null;
        this.damageInterrupt = true;
        this.ready = true;
        AttackIndicator.updateState();
        GameScene.ready();
    }

    public void interrupt() {
        if (this.isAlive() && this.curAction != null && (this.curAction instanceof HeroAction.Move && this.curAction.dst != this.pos || this.curAction instanceof HeroAction.Ascend || this.curAction instanceof HeroAction.Descend)) {
            this.lastAction = this.curAction;
        }
        this.curAction = null;
        GameScene.resetKeyHold();
    }

    public void resume() {
        this.curAction = this.lastAction;
        this.lastAction = null;
        this.damageInterrupt = false;
        this.next();
    }

    private boolean actMove(HeroAction.Move action) {
        if (this.getCloser(action.dst)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actInteract(HeroAction.Interact action) {
        Char ch = action.ch;
        if (ch.canInteract(this)) {
            this.ready();
            this.sprite.turnTo(this.pos, ch.pos);
            return ch.interact(this);
        }
        if (this.fieldOfView[ch.pos] && this.getCloser(ch.pos)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actBuy(HeroAction.Buy action) {
        int dst = action.dst;
        if (this.pos == dst) {
            this.ready();
            final Heap heap = (Heap)Dungeon.level.heaps.get(dst);
            if (heap != null && heap.type == Heap.Type.FOR_SALE && heap.size() == 1) {
                Game.runOnRenderThread(new Callback(){

                    @Override
                    public void call() {
                        GameScene.show(new WndTradeItem(heap));
                    }
                });
            }
            return false;
        }
        if (this.getCloser(dst)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actAlchemy(HeroAction.Alchemy action) {
        int dst = action.dst;
        if (Dungeon.level.distance(dst, this.pos) <= 1) {
            this.ready();
            AlchemistsToolkit.kitEnergy kit = this.buff(AlchemistsToolkit.kitEnergy.class);
            if (kit != null && kit.isCursed()) {
                GLog.w(Messages.get(AlchemistsToolkit.class, "cursed", new Object[0]), new Object[0]);
                return false;
            }
            AlchemyScene.clearToolkit();
            ShatteredPixelDungeon.switchScene(AlchemyScene.class);
            return false;
        }
        if (this.getCloser(dst)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actPickUp(HeroAction.PickUp action) {
        int dst = action.dst;
        if (this.pos == dst) {
            Heap heap = (Heap)Dungeon.level.heaps.get(this.pos);
            if (heap != null) {
                Item item = heap.peek();
                if (item.doPickUp(this)) {
                    heap.pickUp();
                    if (!(item instanceof Dewdrop || item instanceof TimekeepersHourglass.sandBag || item instanceof DriedRose.Petal || item instanceof Key)) {
                        boolean important;
                        boolean bl = important = item.unique && item.isIdentified() && (item instanceof Scroll || item instanceof Potion);
                        if (important) {
                            GLog.p(Messages.get(this, "you_now_have", item.name()), new Object[0]);
                        } else {
                            GLog.i(Messages.get(this, "you_now_have", item.name()), new Object[0]);
                        }
                    }
                    this.curAction = null;
                } else {
                    if (!(item instanceof Dewdrop || item instanceof TimekeepersHourglass.sandBag || item instanceof DriedRose.Petal || item instanceof Key)) {
                        GLog.newLine();
                        GLog.n(Messages.get(this, "you_cant_have", item.name()), new Object[0]);
                    }
                    heap.sprite.drop();
                    this.ready();
                }
            } else {
                this.ready();
            }
            return false;
        }
        if (this.getCloser(dst)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actOpenChest(HeroAction.OpenChest action) {
        int dst = action.dst;
        if (Dungeon.level.adjacent(this.pos, dst) || this.pos == dst) {
            Heap heap = (Heap)Dungeon.level.heaps.get(dst);
            if (heap != null && heap.type != Heap.Type.HEAP && heap.type != Heap.Type.FOR_SALE) {
                if (heap.type == Heap.Type.LOCKED_CHEST && Notes.keyCount(new GoldenKey(Dungeon.depth)) < 1 || heap.type == Heap.Type.CRYSTAL_CHEST && Notes.keyCount(new CrystalKey(Dungeon.depth)) < 1) {
                    GLog.w(Messages.get(this, "locked_chest", new Object[0]), new Object[0]);
                    this.ready();
                    return false;
                }
                switch (heap.type) {
                    case TOMB: {
                        Sample.INSTANCE.play("sounds/tomb.mp3");
                        Camera.main.shake(1.0f, 0.5f);
                        break;
                    }
                    case SKELETON: 
                    case REMAINS: {
                        break;
                    }
                    default: {
                        Sample.INSTANCE.play("sounds/unlock.mp3");
                    }
                }
                this.sprite.operate(dst);
            } else {
                this.ready();
            }
            return false;
        }
        if (this.getCloser(dst)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actUnlock(HeroAction.Unlock action) {
        int doorCell = action.dst;
        if (Dungeon.level.adjacent(this.pos, doorCell)) {
            boolean hasKey = false;
            int door = Dungeon.level.map[doorCell];
            if (door == 10 && Notes.keyCount(new IronKey(Dungeon.depth)) > 0) {
                hasKey = true;
            } else if (door == 31 && Notes.keyCount(new CrystalKey(Dungeon.depth)) > 0) {
                hasKey = true;
            } else if (door == 21 && Notes.keyCount(new SkeletonKey(Dungeon.depth)) > 0) {
                hasKey = true;
            }
            if (hasKey) {
                this.sprite.operate(doorCell);
                Sample.INSTANCE.play("sounds/unlock.mp3");
            } else {
                GLog.w(Messages.get(this, "locked_door", new Object[0]), new Object[0]);
                this.ready();
            }
            return false;
        }
        if (this.getCloser(doorCell)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actDescend(HeroAction.Descend action) {
        int stairs = action.dst;
        if (this.rooted) {
            Camera.main.shake(1.0f, 1.0f);
            this.ready();
            return false;
        }
        if (Dungeon.level.map[this.pos] == 8 || Dungeon.level.map[this.pos] == 22) {
            Swiftthistle.TimeBubble timeBubble;
            this.curAction = null;
            TimekeepersHourglass.timeFreeze timeFreeze2 = this.buff(TimekeepersHourglass.timeFreeze.class);
            if (timeFreeze2 != null) {
                timeFreeze2.disarmPressedTraps();
            }
            if ((timeBubble = this.buff(Swiftthistle.TimeBubble.class)) != null) {
                timeBubble.disarmPressedTraps();
            }
            InterlevelScene.mode = InterlevelScene.Mode.DESCEND;
            Game.switchScene(InterlevelScene.class);
            return false;
        }
        if (this.getCloser(stairs)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actAscend(HeroAction.Ascend action) {
        int stairs = action.dst;
        if (this.rooted) {
            Camera.main.shake(1.0f, 1.0f);
            this.ready();
            return false;
        }
        if (Dungeon.level.map[this.pos] == 7) {
            if (Dungeon.depth == 1) {
                if (this.belongings.getItem(Amulet.class) == null) {
                    Game.runOnRenderThread(new Callback(){

                        @Override
                        public void call() {
                            GameScene.show(new WndMessage(Messages.get(Hero.this, "leave", new Object[0])));
                        }
                    });
                    this.ready();
                } else {
                    Badges.silentValidateHappyEnd();
                    Dungeon.win(Amulet.class);
                    Dungeon.deleteGame(GamesInProgress.curSlot, true);
                    Game.switchScene(SurfaceScene.class);
                }
            } else {
                Swiftthistle.TimeBubble timeBubble;
                this.curAction = null;
                TimekeepersHourglass.timeFreeze timeFreeze2 = this.buff(TimekeepersHourglass.timeFreeze.class);
                if (timeFreeze2 != null) {
                    timeFreeze2.disarmPressedTraps();
                }
                if ((timeBubble = this.buff(Swiftthistle.TimeBubble.class)) != null) {
                    timeBubble.disarmPressedTraps();
                }
                InterlevelScene.mode = InterlevelScene.Mode.ASCEND;
                Game.switchScene(InterlevelScene.class);
            }
            return false;
        }
        if (this.getCloser(stairs)) {
            return true;
        }
        this.ready();
        return false;
    }

    private boolean actAttack(HeroAction.Attack action) {
        this.enemy = action.target;
        if (this.enemy.isAlive() && this.canAttack(this.enemy) && !this.isCharmedBy(this.enemy)) {
            this.sprite.attack(this.enemy.pos);
            return false;
        }
        if (this.fieldOfView[this.enemy.pos] && this.getCloser(this.enemy.pos)) {
            return true;
        }
        this.ready();
        return false;
    }

    public Char enemy() {
        return this.enemy;
    }

    public void rest(boolean fullRest) {
        this.spendAndNext(1.0f);
        if (!fullRest) {
            if (this.hasTalent(Talent.HOLD_FAST)) {
                Buff.affect(this, HoldFast.class);
            }
            if (this.sprite != null) {
                this.sprite.showStatus(0xFFFFFF, Messages.get(this, "wait", new Object[0]), new Object[0]);
            }
        }
        this.resting = fullRest;
    }

    @Override
    public int attackProc(final Char enemy, int damage) {
        damage = super.attackProc(enemy, damage);
        final KindOfWeapon wep = this.belongings.weapon();
        if (wep != null) {
            damage = wep.proc(this, enemy, damage);
        }
        if (this.buff(Talent.SpiritBladesTracker.class) != null && Random.Int(10) < 3 * this.pointsInTalent(Talent.SPIRIT_BLADES)) {
            SpiritBow bow = this.belongings.getItem(SpiritBow.class);
            if (bow != null) {
                damage = bow.proc(this, enemy, damage);
            }
            this.buff(Talent.SpiritBladesTracker.class).detach();
        }
        damage = Talent.onAttackProc(this, enemy, damage);
        switch (this.subClass) {
            case SNIPER: {
                if (!(wep instanceof MissileWeapon) || wep instanceof SpiritBow.SpiritArrow || enemy == this) break;
                Actor.add(new Actor(){
                    {
                        this.actPriority = 100;
                    }

                    @Override
                    protected boolean act() {
                        if (enemy.isAlive()) {
                            int bonusTurns = Hero.this.hasTalent(Talent.SHARED_UPGRADES) ? wep.buffedLvl() : 0;
                            Buff.prolong(Hero.this, SnipersMark.class, 4.0f + (float)bonusTurns).set(enemy.id(), bonusTurns);
                        }
                        Actor.remove(this);
                        return true;
                    }
                });
                break;
            }
        }
        return damage;
    }

    @Override
    public int defenseProc(Char enemy, int damage) {
        WandOfLivingEarth.RockArmor rockArmor;
        Earthroot.Armor armor;
        if (damage > 0 && this.subClass == HeroSubClass.BERSERKER) {
            Berserk berserk = Buff.affect(this, Berserk.class);
            berserk.damage(damage);
        }
        if (this.belongings.armor() != null) {
            damage = this.belongings.armor().proc(enemy, this, damage);
        }
        if ((armor = this.buff(Earthroot.Armor.class)) != null) {
            damage = armor.absorb(damage);
        }
        if ((rockArmor = this.buff(WandOfLivingEarth.RockArmor.class)) != null) {
            damage = rockArmor.absorb(damage);
        }
        return damage;
    }

    @Override
    public void damage(int dmg, Object src) {
        CapeOfThorns.Thorns thorns;
        if (this.buff(TimekeepersHourglass.timeStasis.class) != null) {
            return;
        }
        if (!(src instanceof Hunger) && !(src instanceof Viscosity.DeferedDamage) && this.damageInterrupt) {
            this.interrupt();
            this.resting = false;
        }
        if (this.buff(Drowsy.class) != null) {
            Buff.detach(this, Drowsy.class);
            GLog.w(Messages.get(this, "pain_resist", new Object[0]), new Object[0]);
        }
        Endure.EndureTracker endure = this.buff(Endure.EndureTracker.class);
        if (!(src instanceof Char)) {
            if (endure != null) {
                dmg = endure.adjustDamageTaken(dmg);
            }
            if (this.buff(ScrollOfChallenge.ChallengeArena.class) != null) {
                dmg = (int)((float)dmg * 0.67f);
            }
        }
        if ((thorns = this.buff(CapeOfThorns.Thorns.class)) != null) {
            dmg = thorns.proc(dmg, src instanceof Char ? (Char)src : null, this);
        }
        dmg = (int)Math.ceil((float)dmg * RingOfTenacity.damageMultiplier(this));
        if (this.belongings.armor() != null && this.belongings.armor().hasGlyph(AntiMagic.class, this) && AntiMagic.RESISTS.contains(src.getClass())) {
            dmg -= AntiMagic.drRoll(this.belongings.armor().buffedLvl());
        }
        if (this.buff(Talent.WarriorFoodImmunity.class) != null) {
            if (this.pointsInTalent(Talent.IRON_STOMACH) == 1) {
                dmg = Math.round((float)dmg * 0.25f);
            } else if (this.pointsInTalent(Talent.IRON_STOMACH) == 2) {
                dmg = Math.round((float)dmg * 0.0f);
            }
        }
        int preHP = this.HP + this.shielding();
        super.damage(dmg, src);
        int postHP = this.HP + this.shielding();
        int effectiveDamage = preHP - postHP;
        if (effectiveDamage <= 0) {
            return;
        }
        float percentDMG = (float)effectiveDamage / (float)preHP;
        float percentHP = 1.0f - (float)(this.HT - postHP) / (float)this.HT;
        float flashIntensity = 0.25f * (percentDMG * percentDMG) / percentHP;
        if (flashIntensity >= 0.05f) {
            flashIntensity = Math.min(0.33333334f, flashIntensity);
            GameScene.flash((int)(255.0f * flashIntensity) << 16);
            if (this.isAlive()) {
                if (flashIntensity >= 0.16666667f) {
                    Sample.INSTANCE.play("sounds/health_critical.mp3", 0.33333334f + flashIntensity * 2.0f);
                } else {
                    Sample.INSTANCE.play("sounds/health_warn.mp3", 0.33333334f + flashIntensity * 4.0f);
                }
            }
        }
    }

    public void checkVisibleMobs() {
        ArrayList<Mob> visible = new ArrayList<Mob>();
        boolean newMob = false;
        Mob target = null;
        for (Mob m : Dungeon.level.mobs.toArray(new Mob[0])) {
            if (!this.fieldOfView[m.pos] || m.alignment != Char.Alignment.ENEMY) continue;
            visible.add(m);
            if (!this.visibleEnemies.contains(m)) {
                newMob = true;
            }
            if (this.mindVisionEnemies.contains(m) || QuickSlotButton.autoAim(m) == -1) continue;
            if (target == null) {
                target = m;
            } else if (this.distance(target) > this.distance(m)) {
                target = m;
            }
            if (!(m instanceof Snake) || Dungeon.level.distance(m.pos, this.pos) > 4 || Document.ADVENTURERS_GUIDE.isPageRead("Examining")) continue;
            GLog.p(Messages.get(Guidebook.class, "hint", new Object[0]), new Object[0]);
            GameScene.flashForDocument("Examining");
            Document.ADVENTURERS_GUIDE.readPage("Examining");
        }
        Char lastTarget = QuickSlotButton.lastTarget;
        if (!(target == null || lastTarget != null && lastTarget.isAlive() && lastTarget.alignment != Char.Alignment.ALLY && this.fieldOfView[lastTarget.pos])) {
            QuickSlotButton.target(target);
        }
        if (newMob) {
            this.interrupt();
            if (this.resting) {
                Dungeon.observe();
                this.resting = false;
            }
        }
        this.visibleEnemies = visible;
    }

    public int visibleEnemies() {
        return this.visibleEnemies.size();
    }

    public Mob visibleEnemy(int index) {
        return this.visibleEnemies.get(index % this.visibleEnemies.size());
    }

    private boolean getCloser(int target) {
        if (target == this.pos) {
            return false;
        }
        if (this.rooted) {
            Camera.main.shake(1.0f, 1.0f);
            return false;
        }
        int step = -1;
        if (Dungeon.level.adjacent(this.pos, target)) {
            this.path = null;
            if (Actor.findChar(target) == null) {
                if (Dungeon.level.pit[target] && !this.flying && !Dungeon.level.solid[target]) {
                    if (!Chasm.jumpConfirmed) {
                        Chasm.heroJump(this);
                        this.interrupt();
                    } else {
                        Chasm.heroFall(target);
                    }
                    return false;
                }
                if (Dungeon.level.passable[target] || Dungeon.level.avoid[target]) {
                    step = target;
                }
                if (this.walkingToVisibleTrapInFog && Dungeon.level.traps.get(target) != null && ((Trap)Dungeon.level.traps.get((int)target)).visible) {
                    return false;
                }
            }
        } else {
            boolean newPath = false;
            if (this.path == null || this.path.isEmpty() || !Dungeon.level.adjacent(this.pos, (Integer)this.path.getFirst())) {
                newPath = true;
            } else if ((Integer)this.path.getLast() != target) {
                newPath = true;
            } else if (!Dungeon.level.passable[(Integer)this.path.get(0)] || Actor.findChar((Integer)this.path.get(0)) != null) {
                newPath = true;
            }
            if (newPath) {
                int len = Dungeon.level.length();
                boolean[] p = Dungeon.level.passable;
                boolean[] v = Dungeon.level.visited;
                boolean[] m = Dungeon.level.mapped;
                boolean[] passable = new boolean[len];
                for (int i = 0; i < len; ++i) {
                    passable[i] = p[i] && (v[i] || m[i]);
                }
                PathFinder.Path newpath = Dungeon.findPath(this, target, passable, this.fieldOfView, true);
                this.path = newpath != null && this.path != null && newpath.size() > 2 * this.path.size() ? null : newpath;
            }
            if (this.path == null) {
                return false;
            }
            step = (Integer)this.path.removeFirst();
        }
        if (step != -1) {
            if (this.subClass == HeroSubClass.FREERUNNER) {
                Buff.affect(this, Momentum.class).gainStack();
            }
            float speed = this.speed();
            this.sprite.move(this.pos, step);
            this.move(step);
            this.spend(1.0f / speed);
            this.justMoved = true;
            this.search(false);
            return true;
        }
        return false;
    }

    public boolean handle(int cell) {
        if (cell == -1) {
            return false;
        }
        if (this.fieldOfView == null || this.fieldOfView.length != Dungeon.level.length()) {
            this.fieldOfView = new boolean[Dungeon.level.length()];
            Dungeon.level.updateFieldOfView(this, this.fieldOfView);
        }
        Char ch = Actor.findChar(cell);
        Heap heap = (Heap)Dungeon.level.heaps.get(cell);
        if (Dungeon.level.map[cell] == 28 && cell != this.pos) {
            this.curAction = new HeroAction.Alchemy(cell);
        } else if (this.fieldOfView[cell] && ch instanceof Mob) {
            this.curAction = ch.alignment != Char.Alignment.ENEMY && ch.buff(Amok.class) == null ? new HeroAction.Interact(ch) : new HeroAction.Attack(ch);
        } else if (heap != null && (this.visibleEnemies.size() == 0 || cell == this.pos || heap.type != Heap.Type.HEAP && heap.type != Heap.Type.FOR_SALE)) {
            switch (heap.type) {
                case HEAP: {
                    this.curAction = new HeroAction.PickUp(cell);
                    break;
                }
                case FOR_SALE: {
                    this.curAction = heap.size() == 1 && heap.peek().value() > 0 ? new HeroAction.Buy(cell) : new HeroAction.PickUp(cell);
                    break;
                }
                default: {
                    this.curAction = new HeroAction.OpenChest(cell);
                    break;
                }
            }
        } else if (Dungeon.level.map[cell] == 10 || Dungeon.level.map[cell] == 31 || Dungeon.level.map[cell] == 21) {
            this.curAction = new HeroAction.Unlock(cell);
        } else if ((cell == Dungeon.level.exit || Dungeon.level.map[cell] == 8 || Dungeon.level.map[cell] == 22) && Dungeon.depth < 26) {
            this.curAction = new HeroAction.Descend(cell);
        } else if (cell == Dungeon.level.entrance || Dungeon.level.map[cell] == 7) {
            this.curAction = new HeroAction.Ascend(cell);
        } else {
            this.walkingToVisibleTrapInFog = !Dungeon.level.visited[cell] && !Dungeon.level.mapped[cell] && Dungeon.level.traps.get(cell) != null && ((Trap)Dungeon.level.traps.get((int)cell)).visible;
            this.curAction = new HeroAction.Move(cell);
            this.lastAction = null;
        }
        return true;
    }

    public void earnExp(int exp, Class source) {
        Berserk berserk;
        MasterThievesArmband.Thievery armband;
        AlchemistsToolkit.kitEnergy kit;
        HornOfPlenty.hornRecharge horn;
        this.exp += exp;
        float percent = (float)exp / (float)this.maxExp();
        EtherealChains.chainsRecharge chains = this.buff(EtherealChains.chainsRecharge.class);
        if (chains != null) {
            chains.gainExp(percent);
        }
        if ((horn = this.buff(HornOfPlenty.hornRecharge.class)) != null) {
            horn.gainCharge(percent);
        }
        if ((kit = this.buff(AlchemistsToolkit.kitEnergy.class)) != null) {
            kit.gainCharge(percent);
        }
        if ((armband = this.buff(MasterThievesArmband.Thievery.class)) != null) {
            armband.gainCharge(percent);
        }
        if ((berserk = this.buff(Berserk.class)) != null) {
            berserk.recover(percent);
        }
        if (source != PotionOfExperience.class) {
            for (Item i : this.belongings) {
                i.onHeroGainExp(percent, this);
            }
            if (this.buff(Talent.RejuvenatingStepsFurrow.class) != null) {
                this.buff(Talent.RejuvenatingStepsFurrow.class).countDown(percent * 200.0f);
                if (this.buff(Talent.RejuvenatingStepsFurrow.class).count() <= 0.0f) {
                    this.buff(Talent.RejuvenatingStepsFurrow.class).detach();
                }
            }
        }
        boolean levelUp = false;
        while (this.exp >= this.maxExp()) {
            this.exp -= this.maxExp();
            if (this.lvl < 30) {
                ++this.lvl;
                levelUp = true;
                if (this.buff(ElixirOfMight.HTBoost.class) != null) {
                    this.buff(ElixirOfMight.HTBoost.class).onLevelUp();
                }
                this.updateHT(true);
                ++this.attackSkill;
                ++this.defenseSkill;
                continue;
            }
            Buff.prolong(this, Bless.class, 30.0f);
            this.exp = 0;
            GLog.newLine();
            GLog.p(Messages.get(this, "level_cap", new Object[0]), new Object[0]);
            Sample.INSTANCE.play("sounds/levelup.mp3");
        }
        if (levelUp) {
            if (this.sprite != null) {
                GLog.newLine();
                GLog.p(Messages.get(this, "new_level", new Object[0]), new Object[0]);
                this.sprite.showStatus(65280, Messages.get(Hero.class, "level_up", new Object[0]), new Object[0]);
                Sample.INSTANCE.play("sounds/levelup.mp3");
                if (this.lvl < Talent.tierLevelThresholds[5]) {
                    GLog.newLine();
                    GLog.p(Messages.get(this, "new_talent", new Object[0]), new Object[0]);
                    StatusPane.talentBlink = 10.0f;
                    WndHero.lastIdx = 1;
                }
            }
            Item.updateQuickslot();
            Badges.validateLevelReached();
        }
    }

    public int maxExp() {
        return Hero.maxExp(this.lvl);
    }

    public static int maxExp(int lvl) {
        return 5 + lvl * 5;
    }

    public boolean isStarving() {
        return Buff.affect(this, Hunger.class).isStarving();
    }

    @Override
    public void add(Buff buff) {
        if (this.buff(TimekeepersHourglass.timeStasis.class) != null) {
            return;
        }
        super.add(buff);
        if (this.sprite != null && this.buffs().contains(buff)) {
            String msg = buff.heroMessage();
            if (msg != null) {
                GLog.w(msg, new Object[0]);
            }
            if (buff instanceof Paralysis || buff instanceof Vertigo) {
                this.interrupt();
            }
        }
        BuffIndicator.refreshHero();
    }

    @Override
    public void remove(Buff buff) {
        super.remove(buff);
        BuffIndicator.refreshHero();
    }

    @Override
    public float stealth() {
        float stealth = super.stealth();
        if (this.belongings.armor() != null) {
            stealth = this.belongings.armor().stealthFactor(this, stealth);
        }
        return stealth;
    }

    @Override
    public void die(Object cause) {
        this.curAction = null;
        Ankh ankh = null;
        for (Ankh i : this.belongings.getAllItems(Ankh.class)) {
            if (ankh != null && !i.isBlessed()) continue;
            ankh = i;
        }
        if (ankh != null) {
            this.interrupt();
            this.resting = false;
            if (ankh.isBlessed()) {
                this.HP = this.HT / 4;
                PotionOfHealing.cure(this);
                Buff.prolong(this, AnkhInvulnerability.class, 3.0f);
                SpellSprite.show(this, 5);
                GameScene.flash(-2130706624);
                Sample.INSTANCE.play("sounds/teleport.mp3");
                GLog.w(Messages.get(this, "revive", new Object[0]), new Object[0]);
                ++Statistics.ankhsUsed;
                ankh.detach(this.belongings.backpack);
                for (Char ch : Actor.chars()) {
                    if (!(ch instanceof DriedRose.GhostHero)) continue;
                    ((DriedRose.GhostHero)ch).sayAnhk();
                    return;
                }
            } else {
                WndResurrect.instance = new Object();
                final Ankh finalAnkh = ankh;
                Game.runOnRenderThread(new Callback(){

                    @Override
                    public void call() {
                        GameScene.show(new WndResurrect(finalAnkh));
                    }
                });
            }
            return;
        }
        Actor.fixTime();
        super.die(cause);
        Hero.reallyDie(cause);
    }

    public static void reallyDie(Object cause) {
        int length = Dungeon.level.length();
        int[] map = Dungeon.level.map;
        boolean[] visited = Dungeon.level.visited;
        boolean[] discoverable = Dungeon.level.discoverable;
        for (int i = 0; i < length; ++i) {
            int terr = map[i];
            if (!discoverable[i]) continue;
            visited[i] = true;
            if ((Terrain.flags[terr] & 8) == 0) continue;
            Dungeon.level.discover(i);
        }
        Bones.leave();
        Dungeon.observe();
        GameScene.updateFog();
        Dungeon.hero.belongings.identify();
        int pos = Dungeon.hero.pos;
        ArrayList<Integer> passable = new ArrayList<Integer>();
        int[] nArray = PathFinder.NEIGHBOURS8;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer ofs = nArray[i];
            int cell = pos + ofs;
            if (!Dungeon.level.passable[cell] && !Dungeon.level.avoid[cell] || Dungeon.level.heaps.get(cell) != null) continue;
            passable.add(cell);
        }
        Collections.shuffle(passable);
        ArrayList items = new ArrayList(Dungeon.hero.belongings.backpack.items);
        for (Integer cell : passable) {
            if (items.isEmpty()) break;
            Item item = (Item)Random.element(items);
            Dungeon.level.drop((Item)item, (int)cell.intValue()).sprite.drop(pos);
            items.remove(item);
        }
        for (Char c : Actor.chars()) {
            if (!(c instanceof DriedRose.GhostHero)) continue;
            ((DriedRose.GhostHero)c).sayHeroKilled();
        }
        GameScene.gameOver();
        if (cause instanceof Doom) {
            ((Doom)cause).onDeath();
        }
        Dungeon.deleteGame(GamesInProgress.curSlot, true);
    }

    @Override
    public boolean isAlive() {
        if (this.HP <= 0) {
            if (this.berserk == null) {
                this.berserk = this.buff(Berserk.class);
            }
            return this.berserk != null && this.berserk.berserking();
        }
        this.berserk = null;
        return super.isAlive();
    }

    @Override
    public void move(int step, boolean travelling) {
        boolean wasHighGrass = Dungeon.level.map[step] == 15;
        super.move(step, travelling);
        if (!this.flying && travelling) {
            if (Dungeon.level.water[this.pos]) {
                Sample.INSTANCE.play("sounds/water.mp3", 1.0f, Random.Float(0.8f, 1.25f));
            } else if (Dungeon.level.map[this.pos] == 14) {
                Sample.INSTANCE.play("sounds/sturdy.mp3", 1.0f, Random.Float(0.96f, 1.05f));
            } else if (Dungeon.level.map[this.pos] == 2 || Dungeon.level.map[this.pos] == 9 || Dungeon.level.map[this.pos] == 30) {
                if (step == this.pos && wasHighGrass) {
                    Sample.INSTANCE.play("sounds/trample.mp3", 1.0f, Random.Float(0.96f, 1.05f));
                } else {
                    Sample.INSTANCE.play("sounds/grass.mp3", 1.0f, Random.Float(0.96f, 1.05f));
                }
            } else {
                Sample.INSTANCE.play("sounds/step.mp3", 1.0f, Random.Float(0.96f, 1.05f));
            }
        }
    }

    @Override
    public void onAttackComplete() {
        AttackIndicator.target(this.enemy);
        boolean hit = this.attack(this.enemy);
        Invisibility.dispel();
        this.spend(this.attackDelay());
        if (hit && this.subClass == HeroSubClass.GLADIATOR) {
            Buff.affect(this, Combo.class).hit(this.enemy);
        }
        this.curAction = null;
        super.onAttackComplete();
    }

    @Override
    public void onMotionComplete() {
        GameScene.checkKeyHold();
    }

    @Override
    public void onOperateComplete() {
        if (this.curAction instanceof HeroAction.Unlock) {
            int doorCell = ((HeroAction.Unlock)this.curAction).dst;
            int door = Dungeon.level.map[doorCell];
            if (Dungeon.level.distance(this.pos, doorCell) <= 1) {
                boolean hasKey = true;
                if (door == 10) {
                    hasKey = Notes.remove(new IronKey(Dungeon.depth));
                    if (hasKey) {
                        Level.set(doorCell, 5);
                    }
                } else if (door == 31) {
                    hasKey = Notes.remove(new CrystalKey(Dungeon.depth));
                    if (hasKey) {
                        Level.set(doorCell, 1);
                        Sample.INSTANCE.play("sounds/teleport.mp3");
                        CellEmitter.get(doorCell).start(Speck.factory(101), 0.025f, 20);
                    }
                } else {
                    hasKey = Notes.remove(new SkeletonKey(Dungeon.depth));
                    if (hasKey) {
                        Level.set(doorCell, 22);
                    }
                }
                if (hasKey) {
                    GameScene.updateKeyDisplay();
                    GameScene.updateMap(doorCell);
                    this.spend(1.0f);
                }
            }
        } else if (this.curAction instanceof HeroAction.OpenChest) {
            Heap heap = (Heap)Dungeon.level.heaps.get(((HeroAction.OpenChest)this.curAction).dst);
            if (Dungeon.level.distance(this.pos, heap.pos) <= 1) {
                boolean hasKey = true;
                if (heap.type == Heap.Type.SKELETON || heap.type == Heap.Type.REMAINS) {
                    Sample.INSTANCE.play("sounds/bones.mp3");
                } else if (heap.type == Heap.Type.LOCKED_CHEST) {
                    hasKey = Notes.remove(new GoldenKey(Dungeon.depth));
                } else if (heap.type == Heap.Type.CRYSTAL_CHEST) {
                    hasKey = Notes.remove(new CrystalKey(Dungeon.depth));
                }
                if (hasKey) {
                    GameScene.updateKeyDisplay();
                    heap.open(this);
                    this.spend(1.0f);
                }
            }
        }
        this.curAction = null;
        super.onOperateComplete();
    }

    @Override
    public boolean isImmune(Class effect) {
        if (effect == Burning.class && this.belongings.armor() != null && this.belongings.armor().hasGlyph(Brimstone.class, this)) {
            return true;
        }
        return super.isImmune(effect);
    }

    @Override
    public boolean isInvulnerable(Class effect) {
        return this.buff(AnkhInvulnerability.class) != null;
    }

    public boolean search(boolean intentional) {
        boolean foresightScan;
        int distance;
        if (!this.isAlive()) {
            return false;
        }
        boolean smthFound = false;
        boolean circular = this.pointsInTalent(Talent.WIDE_SEARCH) == 1;
        int n = distance = this.heroClass == HeroClass.ROGUE ? 2 : 1;
        if (this.hasTalent(Talent.WIDE_SEARCH)) {
            ++distance;
        }
        boolean foresight = this.buff(Foresight.class) != null;
        boolean bl = foresightScan = foresight && !Dungeon.level.mapped[this.pos];
        if (foresightScan) {
            Dungeon.level.mapped[this.pos] = true;
        }
        if (foresight) {
            distance = 8;
            circular = true;
        }
        Point c = Dungeon.level.cellToPoint(this.pos);
        TalismanOfForesight.Foresight talisman = this.buff(TalismanOfForesight.Foresight.class);
        boolean cursed = talisman != null && talisman.isCursed();
        int[] rounding = ShadowCaster.rounding[distance];
        for (int y = Math.max(0, c.y - distance); y <= Math.min(Dungeon.level.height() - 1, c.y + distance); ++y) {
            int left;
            if (!circular) {
                left = c.x - distance;
            } else if (rounding[Math.abs(c.y - y)] < Math.abs(c.y - y)) {
                left = c.x - rounding[Math.abs(c.y - y)];
            } else {
                left = distance;
                while (rounding[left] < rounding[Math.abs(c.y - y)]) {
                    --left;
                }
                left = c.x - left;
            }
            int right = Math.min(Dungeon.level.width() - 1, c.x + c.x - left);
            left = Math.max(0, left);
            for (int curr = left + y * Dungeon.level.width(); curr <= right + y * Dungeon.level.width(); ++curr) {
                if (!foresight && !this.fieldOfView[curr] || curr == this.pos) continue;
                if (foresight && (!Dungeon.level.mapped[curr] || foresightScan)) {
                    GameScene.effectOverFog(new CheckedCell(curr, foresightScan ? this.pos : curr));
                } else if (intentional) {
                    GameScene.effectOverFog(new CheckedCell(curr, this.pos));
                }
                if (foresight) {
                    Dungeon.level.mapped[curr] = true;
                }
                if (!Dungeon.level.secret[curr]) continue;
                Trap trap = (Trap)Dungeon.level.traps.get(curr);
                float chance = foresight ? 1.0f : (trap != null && !trap.canBeSearched ? 0.0f : (intentional ? 1.0f : (cursed ? 0.0f : (Dungeon.level.map[curr] == 17 ? 0.4f - (float)Dungeon.depth / 250.0f : 0.2f - (float)Dungeon.depth / 100.0f))));
                if (!(Random.Float() < chance)) continue;
                int oldValue = Dungeon.level.map[curr];
                GameScene.discoverTile(curr, oldValue);
                Dungeon.level.discover(curr);
                ScrollOfMagicMapping.discover(curr);
                if (this.fieldOfView[curr]) {
                    smthFound = true;
                }
                if (talisman == null) continue;
                if (oldValue == 17) {
                    talisman.charge(2);
                    continue;
                }
                if (oldValue != 16) continue;
                talisman.charge(10);
            }
        }
        if (intentional) {
            this.sprite.showStatus(0xFFFFFF, Messages.get(this, "search", new Object[0]), new Object[0]);
            this.sprite.operate(this.pos);
            if (!Dungeon.level.locked) {
                if (cursed) {
                    GLog.n(Messages.get(this, "search_distracted", new Object[0]), new Object[0]);
                    Buff.affect(this, Hunger.class).affectHunger(-10.0f);
                } else {
                    Buff.affect(this, Hunger.class).affectHunger(-4.0f);
                }
            }
            this.spendAndNext(2.0f);
        }
        if (smthFound) {
            GLog.w(Messages.get(this, "noticed_smth", new Object[0]), new Object[0]);
            Sample.INSTANCE.play("sounds/secret.mp3");
            this.interrupt();
        }
        if (foresight) {
            GameScene.updateFog(this.pos, 9);
        }
        return smthFound;
    }

    public void resurrect() {
        this.HP = this.HT;
        this.live();
        MagicalHolster holster = this.belongings.getItem(MagicalHolster.class);
        Buff.affect(this, LostInventory.class);
        Buff.affect(this, Invisibility.class, 3.0f);
        for (Item i : this.belongings) {
            if (i instanceof EquipableItem && i.isEquipped(this)) {
                ((EquipableItem)i).activate(this);
                continue;
            }
            if (i instanceof CloakOfShadows && i.keptThoughLostInvent && this.hasTalent(Talent.LIGHT_CLOAK)) {
                ((CloakOfShadows)i).activate(this);
                continue;
            }
            if (i instanceof Wand && i.keptThoughLostInvent) {
                if (holster != null && holster.contains(i)) {
                    ((Wand)i).charge(this, 0.85f);
                    continue;
                }
                ((Wand)i).charge(this);
                continue;
            }
            if (!(i instanceof MagesStaff) || !i.keptThoughLostInvent) continue;
            ((MagesStaff)i).applyWandChargeBuff(this);
        }
    }

    @Override
    public void next() {
        if (this.isAlive()) {
            super.next();
        }
    }

    public static interface Doom {
        public void onDeath();
    }
}

