/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArtifactRecharge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.CounterBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.EnhancedRings;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LostInventory;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.RevealedArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.WandEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.Ratmogrify;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.BrokenSeal;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.CloakOfShadows;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.HornOfPlenty;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRecharging;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;

public enum Talent {
    HEARTY_MEAL(0),
    ARMSMASTERS_INTUITION(1),
    TEST_SUBJECT(2),
    IRON_WILL(3),
    IRON_STOMACH(4),
    RESTORED_WILLPOWER(5),
    RUNIC_TRANSFERENCE(6),
    LETHAL_MOMENTUM(7),
    IMPROVISED_PROJECTILES(8),
    HOLD_FAST(9, 3),
    STRONGMAN(10, 3),
    ENDLESS_RAGE(11, 3),
    BERSERKING_STAMINA(12, 3),
    ENRAGED_CATALYST(13, 3),
    CLEAVE(14, 3),
    LETHAL_DEFENSE(15, 3),
    ENHANCED_COMBO(16, 3),
    BODY_SLAM(17, 4),
    IMPACT_WAVE(18, 4),
    DOUBLE_JUMP(19, 4),
    EXPANDING_WAVE(20, 4),
    STRIKING_WAVE(21, 4),
    SHOCK_FORCE(22, 4),
    SUSTAINED_RETRIBUTION(23, 4),
    SHRUG_IT_OFF(24, 4),
    EVEN_THE_ODDS(25, 4),
    EMPOWERING_MEAL(32),
    SCHOLARS_INTUITION(33),
    TESTED_HYPOTHESIS(34),
    BACKUP_BARRIER(35),
    ENERGIZING_MEAL(36),
    ENERGIZING_UPGRADE(37),
    WAND_PRESERVATION(38),
    ARCANE_VISION(39),
    SHIELD_BATTERY(40),
    EMPOWERING_SCROLLS(41, 3),
    ALLY_WARP(42, 3),
    EMPOWERED_STRIKE(43, 3),
    MYSTICAL_CHARGE(44, 3),
    EXCESS_CHARGE(45, 3),
    SOUL_EATER(46, 3),
    SOUL_SIPHON(47, 3),
    NECROMANCERS_MINIONS(48, 3),
    BLAST_RADIUS(49, 4),
    ELEMENTAL_POWER(50, 4),
    REACTIVE_BARRIER(51, 4),
    WILD_POWER(52, 4),
    FIRE_EVERYTHING(53, 4),
    CONSERVED_MAGIC(54, 4),
    TELEFRAG(55, 4),
    REMOTE_BEACON(56, 4),
    LONGRANGE_WARP(57, 4),
    CACHED_RATIONS(64),
    THIEFS_INTUITION(65),
    SUCKER_PUNCH(66),
    PROTECTIVE_SHADOWS(67),
    MYSTICAL_MEAL(68),
    MYSTICAL_UPGRADE(69),
    WIDE_SEARCH(70),
    SILENT_STEPS(71),
    ROGUES_FORESIGHT(72),
    ENHANCED_RINGS(73, 3),
    LIGHT_CLOAK(74, 3),
    ENHANCED_LETHALITY(75, 3),
    ASSASSINS_REACH(76, 3),
    BOUNTY_HUNTER(77, 3),
    EVASIVE_ARMOR(78, 3),
    PROJECTILE_MOMENTUM(79, 3),
    SPEEDY_STEALTH(80, 3),
    HASTY_RETREAT(81, 4),
    BODY_REPLACEMENT(82, 4),
    SHADOW_STEP(83, 4),
    FEAR_THE_REAPER(84, 4),
    DEATHLY_DURABILITY(85, 4),
    DOUBLE_MARK(86, 4),
    SHADOW_BLADE(87, 4),
    CLONED_ARMOR(88, 4),
    PERFECT_COPY(89, 4),
    NATURES_BOUNTY(96),
    SURVIVALISTS_INTUITION(97),
    FOLLOWUP_STRIKE(98),
    NATURES_AID(99),
    INVIGORATING_MEAL(100),
    RESTORED_NATURE(101),
    REJUVENATING_STEPS(102),
    HEIGHTENED_SENSES(103),
    DURABLE_PROJECTILES(104),
    POINT_BLANK(105, 3),
    SEER_SHOT(106, 3),
    FARSIGHT(107, 3),
    SHARED_ENCHANTMENT(108, 3),
    SHARED_UPGRADES(109, 3),
    DURABLE_TIPS(110, 3),
    BARKSKIN(111, 3),
    SHIELDING_DEW(112, 3),
    FAN_OF_BLADES(113, 4),
    PROJECTING_BLADES(114, 4),
    SPIRIT_BLADES(115, 4),
    GROWING_POWER(116, 4),
    NATURES_WRATH(117, 4),
    WILD_MOMENTUM(118, 4),
    EAGLE_EYE(119, 4),
    GO_FOR_THE_EYES(120, 4),
    SWIFT_SPIRIT(121, 4),
    HEROIC_ENERGY(26, 4),
    RATSISTANCE(124, 4),
    RATLOMACY(125, 4),
    RATFORCEMENTS(126, 4);

    int icon;
    int maxPoints;
    public static int[] tierLevelThresholds;
    public static final int MAX_TALENT_TIERS = 4;
    private static final String TALENT_TIER = "talents_tier_";

    private Talent(int icon) {
        this(icon, 2);
    }

    private Talent(int icon, int maxPoints) {
        this.icon = icon;
        this.maxPoints = maxPoints;
    }

    public int icon() {
        if (this == HEROIC_ENERGY) {
            if (Dungeon.hero != null && Dungeon.hero.armorAbility instanceof Ratmogrify) {
                return 127;
            }
            HeroClass cls = Dungeon.hero != null ? Dungeon.hero.heroClass : GamesInProgress.selectedClass;
            switch (cls) {
                default: {
                    return 26;
                }
                case MAGE: {
                    return 58;
                }
                case ROGUE: {
                    return 90;
                }
                case HUNTRESS: 
            }
            return 122;
        }
        return this.icon;
    }

    public int maxPoints() {
        return this.maxPoints;
    }

    public String title() {
        if (this == HEROIC_ENERGY && Dungeon.hero != null && Dungeon.hero.armorAbility instanceof Ratmogrify) {
            return Messages.get((Object)this, this.name() + ".rat_title", new Object[0]);
        }
        return Messages.get((Object)this, this.name() + ".title", new Object[0]);
    }

    public String desc() {
        return Messages.get((Object)this, this.name() + ".desc", new Object[0]);
    }

    public static void onTalentUpgraded(Hero hero, Talent talent) {
        if (talent == NATURES_BOUNTY) {
            if (hero.pointsInTalent(NATURES_BOUNTY) == 1) {
                Buff.count(hero, NatureBerriesAvailable.class, 4.0f);
            } else {
                Buff.count(hero, NatureBerriesAvailable.class, 2.0f);
            }
        }
        if (talent == ARMSMASTERS_INTUITION && hero.pointsInTalent(ARMSMASTERS_INTUITION) == 2) {
            if (hero.belongings.weapon() != null) {
                hero.belongings.weapon().identify();
            }
            if (hero.belongings.armor() != null) {
                hero.belongings.armor.identify();
            }
        }
        if (talent == THIEFS_INTUITION && hero.pointsInTalent(THIEFS_INTUITION) == 2) {
            if (hero.belongings.ring instanceof Ring) {
                hero.belongings.ring.identify();
            }
            if (hero.belongings.misc instanceof Ring) {
                hero.belongings.misc.identify();
            }
            for (Item item : Dungeon.hero.belongings) {
                if (!(item instanceof Ring)) continue;
                ((Ring)item).setKnown();
            }
        }
        if (talent == THIEFS_INTUITION && hero.pointsInTalent(THIEFS_INTUITION) == 1) {
            if (hero.belongings.ring instanceof Ring) {
                hero.belongings.ring.setKnown();
            }
            if (hero.belongings.misc instanceof Ring) {
                ((Ring)hero.belongings.misc).setKnown();
            }
        }
        if (talent == LIGHT_CLOAK && hero.pointsInTalent(LIGHT_CLOAK) == 1) {
            for (Item item : Dungeon.hero.belongings.backpack) {
                if (!(item instanceof CloakOfShadows) || hero.buff(LostInventory.class) != null && !item.keptThoughLostInvent) continue;
                ((CloakOfShadows)item).activate(Dungeon.hero);
            }
        }
        if (talent == HEIGHTENED_SENSES || talent == FARSIGHT) {
            Dungeon.observe();
        }
    }

    public static void onFoodEaten(Hero hero, float foodVal, Item foodSource) {
        if (hero.hasTalent(HEARTY_MEAL)) {
            if (hero.HP <= hero.HT / 4) {
                hero.HP = Math.min(hero.HP + 1 + 2 * hero.pointsInTalent(HEARTY_MEAL), hero.HT);
                hero.sprite.emitter().burst(Speck.factory(0), 1 + hero.pointsInTalent(HEARTY_MEAL));
            } else if (hero.HP <= hero.HT / 2) {
                hero.HP = Math.min(hero.HP + 1 + hero.pointsInTalent(HEARTY_MEAL), hero.HT);
                hero.sprite.emitter().burst(Speck.factory(0), hero.pointsInTalent(HEARTY_MEAL));
            }
        }
        if (hero.hasTalent(IRON_STOMACH) && hero.cooldown() > 0.0f) {
            Buff.affect(hero, WarriorFoodImmunity.class, hero.cooldown());
        }
        if (hero.hasTalent(EMPOWERING_MEAL)) {
            Buff.affect(hero, WandEmpower.class).set(1 + hero.pointsInTalent(EMPOWERING_MEAL), 3);
            ScrollOfRecharging.charge(hero);
        }
        if (hero.hasTalent(ENERGIZING_MEAL)) {
            Buff.prolong(hero, Recharging.class, 2 + 3 * hero.pointsInTalent(ENERGIZING_MEAL));
            ScrollOfRecharging.charge(hero);
        }
        if (hero.hasTalent(MYSTICAL_MEAL)) {
            ArtifactRecharge buff = Buff.affect(hero, ArtifactRecharge.class);
            if (buff.left() < (float)(1 + 2 * hero.pointsInTalent(MYSTICAL_MEAL))) {
                Buff.affect((Char)hero, ArtifactRecharge.class).set((float)((float)(1 + 2 * hero.pointsInTalent((Talent)Talent.MYSTICAL_MEAL)))).ignoreHornOfPlenty = foodSource instanceof HornOfPlenty;
            }
            ScrollOfRecharging.charge(hero);
        }
        if (hero.hasTalent(INVIGORATING_MEAL)) {
            Buff.prolong(hero, Haste.class, 0.67f + (float)hero.pointsInTalent(INVIGORATING_MEAL));
        }
    }

    public static float itemIDSpeedFactor(Hero hero, Item item) {
        float factor = 1.0f + (float)hero.pointsInTalent(SURVIVALISTS_INTUITION) * 0.75f;
        if (item instanceof MeleeWeapon || item instanceof Armor) {
            factor *= 1.0f + (float)hero.pointsInTalent(ARMSMASTERS_INTUITION);
        }
        if (item instanceof Wand) {
            factor *= 1.0f + (float)(2 * hero.pointsInTalent(SCHOLARS_INTUITION));
        }
        if (item instanceof Ring) {
            factor *= 1.0f + (float)hero.pointsInTalent(THIEFS_INTUITION);
        }
        return factor;
    }

    public static void onHealingPotionUsed(Hero hero) {
        BrokenSeal.WarriorShield shield;
        if (hero.hasTalent(RESTORED_WILLPOWER) && (shield = hero.buff(BrokenSeal.WarriorShield.class)) != null) {
            int shieldToGive = Math.round((float)shield.maxShield() * 0.33f * (float)(1 + hero.pointsInTalent(RESTORED_WILLPOWER)));
            shield.supercharge(shieldToGive);
        }
        if (hero.hasTalent(RESTORED_NATURE)) {
            int cell;
            ArrayList<Integer> grassCells = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS8) {
                grassCells.add(hero.pos + i);
            }
            Random.shuffle(grassCells);
            Object object = grassCells.iterator();
            while (object.hasNext()) {
                cell = (Integer)object.next();
                Char ch = Actor.findChar(cell);
                if (ch != null && ch.alignment == Char.Alignment.ENEMY) {
                    Buff.affect(ch, Roots.class, 1.0f + (float)hero.pointsInTalent(RESTORED_NATURE));
                }
                if (Dungeon.level.map[cell] == 1 || Dungeon.level.map[cell] == 9 || Dungeon.level.map[cell] == 20) {
                    Level.set(cell, 2);
                    GameScene.updateMap(cell);
                }
                CellEmitter.get(cell).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            }
            if (hero.pointsInTalent(RESTORED_NATURE) == 1) {
                grassCells.remove(0);
                grassCells.remove(0);
                grassCells.remove(0);
            }
            object = grassCells.iterator();
            while (object.hasNext()) {
                cell = (Integer)object.next();
                int t = Dungeon.level.map[cell];
                if (t != 1 && t != 20 && t != 9 && t != 2 && t != 30 || Dungeon.level.plants.get(cell) != null) continue;
                Level.set(cell, 15);
                GameScene.updateMap(cell);
            }
            Dungeon.observe();
        }
    }

    public static void onUpgradeScrollUsed(Hero hero) {
        CloakOfShadows cloak;
        MagesStaff staff;
        if (hero.hasTalent(ENERGIZING_UPGRADE) && (staff = hero.belongings.getItem(MagesStaff.class)) != null) {
            staff.gainCharge(2 + 2 * hero.pointsInTalent(ENERGIZING_UPGRADE), true);
            ScrollOfRecharging.charge(Dungeon.hero);
            SpellSprite.show(hero, 2);
        }
        if (hero.hasTalent(MYSTICAL_UPGRADE) && (cloak = hero.belongings.getItem(CloakOfShadows.class)) != null) {
            cloak.overCharge(1 + hero.pointsInTalent(MYSTICAL_UPGRADE));
            ScrollOfRecharging.charge(Dungeon.hero);
            SpellSprite.show(hero, 2);
        }
    }

    public static void onArtifactUsed(Hero hero) {
        if (hero.hasTalent(ENHANCED_RINGS)) {
            Buff.prolong(hero, EnhancedRings.class, 3.0f * (float)hero.pointsInTalent(ENHANCED_RINGS));
        }
    }

    public static void onItemEquipped(Hero hero, Item item) {
        if (hero.pointsInTalent(ARMSMASTERS_INTUITION) == 2 && (item instanceof Weapon || item instanceof Armor)) {
            item.identify();
        }
        if (hero.hasTalent(THIEFS_INTUITION) && item instanceof Ring) {
            if (hero.pointsInTalent(THIEFS_INTUITION) == 2) {
                item.identify();
            } else {
                ((Ring)item).setKnown();
            }
        }
    }

    public static void onItemCollected(Hero hero, Item item) {
        if (hero.pointsInTalent(THIEFS_INTUITION) == 2 && item instanceof Ring) {
            ((Ring)item).setKnown();
        }
    }

    public static void onItemIdentified(Hero hero, Item item) {
        if (hero.hasTalent(TEST_SUBJECT)) {
            hero.HP = Math.min(hero.HP + 1 + hero.pointsInTalent(TEST_SUBJECT), hero.HT);
            Emitter e = hero.sprite.emitter();
            if (e != null) {
                e.burst(Speck.factory(0), hero.pointsInTalent(TEST_SUBJECT));
            }
        }
        if (hero.hasTalent(TESTED_HYPOTHESIS)) {
            Buff.affect(hero, Recharging.class, 1.0f + (float)hero.pointsInTalent(TESTED_HYPOTHESIS));
            ScrollOfRecharging.charge(hero);
        }
    }

    public static int onAttackProc(Hero hero, Char enemy, int dmg) {
        if (hero.hasTalent(SUCKER_PUNCH) && enemy instanceof Mob && ((Mob)enemy).surprisedBy(hero) && enemy.buff(SuckerPunchTracker.class) == null) {
            dmg += Random.IntRange(hero.pointsInTalent(SUCKER_PUNCH), 2);
            Buff.affect(enemy, SuckerPunchTracker.class);
        }
        if (hero.hasTalent(FOLLOWUP_STRIKE)) {
            if (hero.belongings.weapon() instanceof MissileWeapon) {
                Buff.affect(enemy, FollowupStrikeTracker.class);
            } else if (enemy.buff(FollowupStrikeTracker.class) != null) {
                dmg += 1 + hero.pointsInTalent(FOLLOWUP_STRIKE);
                if (!(enemy instanceof Mob) || !((Mob)enemy).surprisedBy(hero)) {
                    Sample.INSTANCE.play("sounds/hit_strong.mp3", 0.75f, 1.2f);
                }
                enemy.buff(FollowupStrikeTracker.class).detach();
            }
        }
        return dmg;
    }

    public static void initClassTalents(Hero hero) {
        Talent.initClassTalents(hero.heroClass, hero.talents, hero.metamorphedTalents);
    }

    public static void initClassTalents(HeroClass cls, ArrayList<LinkedHashMap<Talent, Integer>> talents) {
        Talent.initClassTalents(cls, talents, new LinkedHashMap<Talent, Talent>());
    }

    public static void initClassTalents(HeroClass cls, ArrayList<LinkedHashMap<Talent, Integer>> talents, LinkedHashMap<Talent, Talent> replacements) {
        while (talents.size() < 4) {
            talents.add(new LinkedHashMap());
        }
        ArrayList tierTalents = new ArrayList();
        switch (cls) {
            default: {
                Collections.addAll(tierTalents, HEARTY_MEAL, ARMSMASTERS_INTUITION, TEST_SUBJECT, IRON_WILL);
                break;
            }
            case MAGE: {
                Collections.addAll(tierTalents, EMPOWERING_MEAL, SCHOLARS_INTUITION, TESTED_HYPOTHESIS, BACKUP_BARRIER);
                break;
            }
            case ROGUE: {
                Collections.addAll(tierTalents, CACHED_RATIONS, THIEFS_INTUITION, SUCKER_PUNCH, PROTECTIVE_SHADOWS);
                break;
            }
            case HUNTRESS: {
                Collections.addAll(tierTalents, NATURES_BOUNTY, SURVIVALISTS_INTUITION, FOLLOWUP_STRIKE, NATURES_AID);
            }
        }
        for (Talent talent : tierTalents) {
            if (replacements.containsKey((Object)talent)) {
                talent = replacements.get((Object)talent);
            }
            talents.get(0).put(talent, 0);
        }
        tierTalents.clear();
        switch (cls) {
            default: {
                Collections.addAll(tierTalents, IRON_STOMACH, RESTORED_WILLPOWER, RUNIC_TRANSFERENCE, LETHAL_MOMENTUM, IMPROVISED_PROJECTILES);
                break;
            }
            case MAGE: {
                Collections.addAll(tierTalents, ENERGIZING_MEAL, ENERGIZING_UPGRADE, WAND_PRESERVATION, ARCANE_VISION, SHIELD_BATTERY);
                break;
            }
            case ROGUE: {
                Collections.addAll(tierTalents, MYSTICAL_MEAL, MYSTICAL_UPGRADE, WIDE_SEARCH, SILENT_STEPS, ROGUES_FORESIGHT);
                break;
            }
            case HUNTRESS: {
                Collections.addAll(tierTalents, INVIGORATING_MEAL, RESTORED_NATURE, REJUVENATING_STEPS, HEIGHTENED_SENSES, DURABLE_PROJECTILES);
            }
        }
        for (Talent talent : tierTalents) {
            if (replacements.containsKey((Object)talent)) {
                talent = replacements.get((Object)talent);
            }
            talents.get(1).put(talent, 0);
        }
        tierTalents.clear();
        switch (cls) {
            default: {
                Collections.addAll(tierTalents, HOLD_FAST, STRONGMAN);
                break;
            }
            case MAGE: {
                Collections.addAll(tierTalents, EMPOWERING_SCROLLS, ALLY_WARP);
                break;
            }
            case ROGUE: {
                Collections.addAll(tierTalents, ENHANCED_RINGS, LIGHT_CLOAK);
                break;
            }
            case HUNTRESS: {
                Collections.addAll(tierTalents, POINT_BLANK, SEER_SHOT);
            }
        }
        for (Talent talent : tierTalents) {
            if (replacements.containsKey((Object)talent)) {
                talent = replacements.get((Object)talent);
            }
            talents.get(2).put(talent, 0);
        }
        tierTalents.clear();
    }

    public static void initSubclassTalents(Hero hero) {
        Talent.initSubclassTalents(hero.subClass, hero.talents);
    }

    public static void initSubclassTalents(HeroSubClass cls, ArrayList<LinkedHashMap<Talent, Integer>> talents) {
        if (cls == HeroSubClass.NONE) {
            return;
        }
        while (talents.size() < 4) {
            talents.add(new LinkedHashMap());
        }
        ArrayList tierTalents = new ArrayList();
        switch (cls) {
            default: {
                Collections.addAll(tierTalents, ENDLESS_RAGE, BERSERKING_STAMINA, ENRAGED_CATALYST);
                break;
            }
            case GLADIATOR: {
                Collections.addAll(tierTalents, CLEAVE, LETHAL_DEFENSE, ENHANCED_COMBO);
                break;
            }
            case BATTLEMAGE: {
                Collections.addAll(tierTalents, EMPOWERED_STRIKE, MYSTICAL_CHARGE, EXCESS_CHARGE);
                break;
            }
            case WARLOCK: {
                Collections.addAll(tierTalents, SOUL_EATER, SOUL_SIPHON, NECROMANCERS_MINIONS);
                break;
            }
            case ASSASSIN: {
                Collections.addAll(tierTalents, ENHANCED_LETHALITY, ASSASSINS_REACH, BOUNTY_HUNTER);
                break;
            }
            case FREERUNNER: {
                Collections.addAll(tierTalents, EVASIVE_ARMOR, PROJECTILE_MOMENTUM, SPEEDY_STEALTH);
                break;
            }
            case SNIPER: {
                Collections.addAll(tierTalents, FARSIGHT, SHARED_ENCHANTMENT, SHARED_UPGRADES);
                break;
            }
            case WARDEN: {
                Collections.addAll(tierTalents, DURABLE_TIPS, BARKSKIN, SHIELDING_DEW);
            }
        }
        for (Talent talent : tierTalents) {
            talents.get(2).put(talent, 0);
        }
        tierTalents.clear();
    }

    public static void initArmorTalents(Hero hero) {
        Talent.initArmorTalents(hero.armorAbility, hero.talents);
    }

    public static void initArmorTalents(ArmorAbility abil, ArrayList<LinkedHashMap<Talent, Integer>> talents) {
        if (abil == null) {
            return;
        }
        while (talents.size() < 4) {
            talents.add(new LinkedHashMap());
        }
        for (Talent t : abil.talents()) {
            talents.get(3).put(t, 0);
        }
    }

    public static void storeTalentsInBundle(Bundle bundle, Hero hero) {
        for (int i = 0; i < 4; ++i) {
            LinkedHashMap<Talent, Integer> tier = hero.talents.get(i);
            Bundle tierBundle = new Bundle();
            for (Talent talent : tier.keySet()) {
                if (tier.get((Object)talent) > 0) {
                    tierBundle.put(talent.name(), tier.get((Object)talent));
                }
                if (!tierBundle.contains(talent.name())) continue;
                tier.put(talent, Math.min(tierBundle.getInt(talent.name()), talent.maxPoints()));
            }
            bundle.put(TALENT_TIER + (i + 1), tierBundle);
        }
        Bundle replacementsBundle = new Bundle();
        for (Talent t : hero.metamorphedTalents.keySet()) {
            replacementsBundle.put(t.name(), hero.metamorphedTalents.get((Object)t));
        }
        bundle.put("replacements", replacementsBundle);
    }

    public static void restoreTalentsFromBundle(Bundle bundle, Hero hero) {
        if (bundle.contains("replacements")) {
            Bundle replacements = bundle.getBundle("replacements");
            for (String key : replacements.getKeys()) {
                hero.metamorphedTalents.put(Talent.valueOf(key), replacements.getEnum(key, Talent.class));
            }
        }
        if (hero.heroClass != null) {
            Talent.initClassTalents(hero);
        }
        if (hero.subClass != null) {
            Talent.initSubclassTalents(hero);
        }
        if (hero.armorAbility != null) {
            Talent.initArmorTalents(hero);
        }
        for (int i = 0; i < 4; ++i) {
            Bundle tierBundle;
            LinkedHashMap<Talent, Integer> tier = hero.talents.get(i);
            Bundle bundle2 = tierBundle = bundle.contains(TALENT_TIER + (i + 1)) ? bundle.getBundle(TALENT_TIER + (i + 1)) : null;
            if (tierBundle == null) continue;
            for (Talent talent : tier.keySet()) {
                if (!tierBundle.contains(talent.name())) continue;
                tier.put(talent, Math.min(tierBundle.getInt(talent.name()), talent.maxPoints()));
            }
        }
    }

    static {
        tierLevelThresholds = new int[]{0, 2, 7, 13, 21, 31};
    }

    public static class FollowupStrikeTracker
    extends Buff {
    }

    public static class SuckerPunchTracker
    extends Buff {
    }

    public static class WarriorFoodImmunity
    extends FlavourBuff {
        public WarriorFoodImmunity() {
            this.actPriority = 1;
        }
    }

    public static class NatureBerriesAvailable
    extends CounterBuff {
        public NatureBerriesAvailable() {
            this.revivePersists = true;
        }
    }

    public static class CachedRationsDropped
    extends CounterBuff {
        public CachedRationsDropped() {
            this.revivePersists = true;
        }
    }

    public static class SpiritBladesTracker
    extends FlavourBuff {
    }

    public static class SeerShotCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return this.target.buff(RevealedArea.class) != null ? 63 : 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.7f, 0.4f, 0.7f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 20.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class RejuvenatingStepsFurrow
    extends CounterBuff {
        public RejuvenatingStepsFurrow() {
            this.revivePersists = true;
        }
    }

    public static class RejuvenatingStepsCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.0f, 0.35f, 0.15f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / (float)(15 - 5 * Dungeon.hero.pointsInTalent(REJUVENATING_STEPS)));
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class BountyHunterTracker
    extends FlavourBuff {
    }

    public static class EmpoweredStrikeTracker
    extends FlavourBuff {
    }

    public static class WandPreservationCounter
    extends CounterBuff {
        public WandPreservationCounter() {
            this.revivePersists = true;
        }
    }

    public static class StrikingWaveTracker
    extends FlavourBuff {
    }

    public static class LethalMomentumTracker
    extends FlavourBuff {
    }

    public static class ImprovisedProjectileCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.15f, 0.2f, 0.5f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 50.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }
}

