/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShieldBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Terror;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Chasm;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.BruteSprite;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class Brute
extends Mob {
    protected boolean hasRaged;
    private static final String HAS_RAGED = "has_raged";

    public Brute() {
        this.spriteClass = BruteSprite.class;
        this.HT = 40;
        this.HP = 40;
        this.defenseSkill = 15;
        this.EXP = 8;
        this.maxLvl = 16;
        this.loot = Gold.class;
        this.lootChance = 0.5f;
        this.hasRaged = false;
    }

    @Override
    public int damageRoll() {
        return this.buff(BruteRage.class) != null ? Random.NormalIntRange(15, 40) : Random.NormalIntRange(5, 25);
    }

    @Override
    public int attackSkill(Char target) {
        return 20;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange(0, 8);
    }

    @Override
    public void die(Object cause) {
        super.die(cause);
        if (cause == Chasm.class) {
            this.hasRaged = true;
        }
    }

    @Override
    public synchronized boolean isAlive() {
        if (super.isAlive()) {
            return true;
        }
        if (!this.hasRaged) {
            this.triggerEnrage();
        }
        return !this.buffs(BruteRage.class).isEmpty();
    }

    protected void triggerEnrage() {
        Buff.affect(this, BruteRage.class).setShield(this.HT / 2 + 4);
        if (Dungeon.level.heroFOV[this.pos]) {
            this.sprite.showStatus(0xFF0000, Messages.get(this, "enraged", new Object[0]), new Object[0]);
        }
        this.spend(1.0f);
        this.hasRaged = true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(HAS_RAGED, this.hasRaged);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.hasRaged = bundle.getBoolean(HAS_RAGED);
    }

    public static class BruteRage
    extends ShieldBuff {
        public BruteRage() {
            this.type = Buff.buffType.POSITIVE;
            this.immunities.add(Terror.class);
        }

        @Override
        public boolean act() {
            if (this.target.HP > 0) {
                this.detach();
                return true;
            }
            this.absorbDamage(4);
            if (this.shielding() <= 0) {
                this.target.die(null);
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public int icon() {
            return 18;
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.shielding());
        }
    }
}

