/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Fire;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Poison;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Gnoll;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Ghost;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.GnollTricksterSprite;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class GnollTrickster
extends Gnoll {
    private int combo;
    private static final String COMBO = "combo";

    public GnollTrickster() {
        this.spriteClass = GnollTricksterSprite.class;
        this.HT = 20;
        this.HP = 20;
        this.defenseSkill = 5;
        this.EXP = 5;
        this.state = this.WANDERING;
        this.loot = Generator.Category.MISSILE;
        this.lootChance = 1.0f;
        this.properties.add(Char.Property.MINIBOSS);
        this.combo = 0;
    }

    @Override
    public int attackSkill(Char target) {
        return 16;
    }

    @Override
    protected boolean canAttack(Char enemy) {
        Ballistica attack = new Ballistica(this.pos, enemy.pos, 7);
        return !Dungeon.level.adjacent(this.pos, enemy.pos) && attack.collisionPos == enemy.pos;
    }

    @Override
    public int attackProc(Char enemy, int damage) {
        damage = super.attackProc(enemy, damage);
        ++this.combo;
        int effect = Random.Int(4) + this.combo;
        if (effect > 2) {
            if (effect >= 6 && enemy.buff(Burning.class) == null) {
                if (Dungeon.level.flamable[enemy.pos]) {
                    GameScene.add(Blob.seed(enemy.pos, 4, Fire.class));
                }
                Buff.affect(enemy, Burning.class).reignite(enemy);
            } else {
                Buff.affect(enemy, Poison.class).set(effect - 2);
            }
        }
        return damage;
    }

    @Override
    protected boolean getCloser(int target) {
        this.combo = 0;
        if (this.state == this.HUNTING) {
            return this.enemySeen && this.getFurther(target);
        }
        return super.getCloser(target);
    }

    @Override
    public void aggro(Char ch) {
        if (ch == null || this.fieldOfView == null || this.fieldOfView[ch.pos]) {
            super.aggro(ch);
        }
    }

    @Override
    public Item createLoot() {
        MissileWeapon drop = (MissileWeapon)super.createLoot();
        drop.quantity((drop.quantity() + 1) / 2);
        return drop;
    }

    @Override
    public void die(Object cause) {
        super.die(cause);
        Ghost.Quest.process();
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(COMBO, this.combo);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.combo = bundle.getInt(COMBO);
    }
}

