/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.items.BrokenSeal;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.DarkGold;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.Pickaxe;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.BlacksmithRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.BlacksmithSprite;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBlacksmith;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndQuest;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Blacksmith
extends NPC {
    public Blacksmith() {
        this.spriteClass = BlacksmithSprite.class;
        this.properties.add(Char.Property.IMMOVABLE);
    }

    @Override
    protected boolean act() {
        if (Dungeon.level.heroFOV[this.pos] && !Quest.reforged) {
            Notes.add(Notes.Landmark.TROLL);
        }
        return super.act();
    }

    @Override
    public boolean interact(Char c) {
        this.sprite.turnTo(this.pos, c.pos);
        if (c != Dungeon.hero) {
            return true;
        }
        if (!Quest.given) {
            Game.runOnRenderThread(new Callback(){

                @Override
                public void call() {
                    GameScene.show(new WndQuest(Blacksmith.this, Quest.alternative ? Messages.get(Blacksmith.this, "blood_1", new Object[0]) : Messages.get(Blacksmith.this, "gold_1", new Object[0])){

                        @Override
                        public void onBackPressed() {
                            super.onBackPressed();
                            Quest.given = true;
                            Quest.completed = false;
                            Notes.add(Notes.Landmark.TROLL);
                            Pickaxe pick = new Pickaxe();
                            if (pick.doPickUp(Dungeon.hero)) {
                                GLog.i(Messages.get(Dungeon.hero, "you_now_have", pick.name()), new Object[0]);
                            } else {
                                Dungeon.level.drop((Item)pick, (int)Dungeon.hero.pos).sprite.drop();
                            }
                        }
                    });
                }
            });
        } else if (!Quest.completed) {
            if (Quest.alternative) {
                Pickaxe pick = Dungeon.hero.belongings.getItem(Pickaxe.class);
                if (pick == null) {
                    this.tell(Messages.get(this, "lost_pick", new Object[0]));
                } else if (!pick.bloodStained) {
                    this.tell(Messages.get(this, "blood_2", new Object[0]));
                } else {
                    if (pick.isEquipped(Dungeon.hero)) {
                        pick.doUnequip(Dungeon.hero, false);
                    }
                    pick.detach(Dungeon.hero.belongings.backpack);
                    this.tell(Messages.get(this, "completed", new Object[0]));
                    Quest.completed = true;
                    Quest.reforged = false;
                }
            } else {
                Pickaxe pick = Dungeon.hero.belongings.getItem(Pickaxe.class);
                DarkGold gold = Dungeon.hero.belongings.getItem(DarkGold.class);
                if (pick == null) {
                    this.tell(Messages.get(this, "lost_pick", new Object[0]));
                } else if (gold == null || gold.quantity() < 15) {
                    this.tell(Messages.get(this, "gold_2", new Object[0]));
                } else {
                    if (pick.isEquipped(Dungeon.hero)) {
                        pick.doUnequip(Dungeon.hero, false);
                    }
                    pick.detach(Dungeon.hero.belongings.backpack);
                    gold.detachAll(Dungeon.hero.belongings.backpack);
                    this.tell(Messages.get(this, "completed", new Object[0]));
                    Quest.completed = true;
                    Quest.reforged = false;
                }
            }
        } else if (!Quest.reforged) {
            Game.runOnRenderThread(new Callback(){

                @Override
                public void call() {
                    GameScene.show(new WndBlacksmith(Blacksmith.this, Dungeon.hero));
                }
            });
        } else {
            this.tell(Messages.get(this, "get_lost", new Object[0]));
        }
        return true;
    }

    private void tell(final String text) {
        Game.runOnRenderThread(new Callback(){

            @Override
            public void call() {
                GameScene.show(new WndQuest(Blacksmith.this, text));
            }
        });
    }

    public static String verify(Item item1, Item item2) {
        if (item1 == item2 && item1.quantity() == 1 && item2.quantity() == 1) {
            return Messages.get(Blacksmith.class, "same_item", new Object[0]);
        }
        if (item1.getClass() != item2.getClass()) {
            return Messages.get(Blacksmith.class, "diff_type", new Object[0]);
        }
        if (!item1.isIdentified() || !item2.isIdentified()) {
            return Messages.get(Blacksmith.class, "un_ided", new Object[0]);
        }
        if (item1.cursed || item2.cursed) {
            return Messages.get(Blacksmith.class, "cursed", new Object[0]);
        }
        if (item1.level() < 0 || item2.level() < 0) {
            return Messages.get(Blacksmith.class, "degraded", new Object[0]);
        }
        if (!item1.isUpgradable() || !item2.isUpgradable()) {
            return Messages.get(Blacksmith.class, "cant_reforge", new Object[0]);
        }
        return null;
    }

    public static void upgrade(Item item1, Item item2) {
        BrokenSeal seal;
        Item second;
        Item first;
        if (item2.level() > item1.level()) {
            first = item2;
            second = item1;
        } else {
            first = item1;
            second = item2;
        }
        Sample.INSTANCE.play("sounds/evoke.mp3");
        ScrollOfUpgrade.upgrade(Dungeon.hero);
        Item.evoke(Dungeon.hero);
        if (second.isEquipped(Dungeon.hero)) {
            ((EquipableItem)second).doUnequip(Dungeon.hero, false);
        }
        second.detach(Dungeon.hero.belongings.backpack);
        if (second instanceof Armor && (seal = ((Armor)second).checkSeal()) != null) {
            Dungeon.level.drop(seal, Dungeon.hero.pos);
        }
        if (first instanceof Weapon && ((Weapon)first).hasGoodEnchant()) {
            ((Weapon)first).upgrade(true);
        } else if (first instanceof Armor && ((Armor)first).hasGoodGlyph()) {
            ((Armor)first).upgrade(true);
        } else {
            first.upgrade();
        }
        Dungeon.hero.spendAndNext(2.0f);
        Badges.validateItemLevelAquired(first);
        Item.updateQuickslot();
        Quest.reforged = true;
        Notes.remove(Notes.Landmark.TROLL);
    }

    @Override
    public int defenseSkill(Char enemy) {
        return INFINITE_EVASION;
    }

    @Override
    public void damage(int dmg, Object src) {
    }

    @Override
    public void add(Buff buff) {
    }

    @Override
    public boolean reset() {
        return true;
    }

    public static class Quest {
        private static boolean spawned;
        private static boolean alternative;
        private static boolean given;
        private static boolean completed;
        private static boolean reforged;
        private static final String NODE = "blacksmith";
        private static final String SPAWNED = "spawned";
        private static final String ALTERNATIVE = "alternative";
        private static final String GIVEN = "given";
        private static final String COMPLETED = "completed";
        private static final String REFORGED = "reforged";

        public static void reset() {
            spawned = false;
            given = false;
            completed = false;
            reforged = false;
        }

        public static void storeInBundle(Bundle bundle) {
            Bundle node = new Bundle();
            node.put(SPAWNED, spawned);
            if (spawned) {
                node.put(ALTERNATIVE, alternative);
                node.put(GIVEN, given);
                node.put(COMPLETED, completed);
                node.put(REFORGED, reforged);
            }
            bundle.put(NODE, node);
        }

        public static void restoreFromBundle(Bundle bundle) {
            Bundle node = bundle.getBundle(NODE);
            if (!node.isNull() && (spawned = node.getBoolean(SPAWNED))) {
                alternative = node.getBoolean(ALTERNATIVE);
                given = node.getBoolean(GIVEN);
                completed = node.getBoolean(COMPLETED);
                reforged = node.getBoolean(REFORGED);
            } else {
                Quest.reset();
            }
        }

        public static ArrayList<Room> spawn(ArrayList<Room> rooms) {
            if (!spawned && Dungeon.depth > 11 && Random.Int(15 - Dungeon.depth) == 0) {
                rooms.add(new BlacksmithRoom());
                spawned = true;
                alternative = Random.Int(2) == 0;
                given = false;
            }
            return rooms;
        }
    }
}

