/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ElmoParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ImpSprite;

public class ImpShopkeeper
extends Shopkeeper {
    private boolean seenBefore;

    public ImpShopkeeper() {
        this.spriteClass = ImpSprite.class;
        this.seenBefore = false;
    }

    @Override
    protected boolean act() {
        if (!this.seenBefore && Dungeon.level.heroFOV[this.pos]) {
            this.yell(Messages.get(this, "greetings", Dungeon.hero.name()));
            this.seenBefore = true;
        }
        return super.act();
    }

    @Override
    public void flee() {
        for (Heap heap : Dungeon.level.heaps.valueList()) {
            if (heap.type != Heap.Type.FOR_SALE) continue;
            CellEmitter.get(heap.pos).burst(ElmoParticle.FACTORY, 4);
            heap.destroy();
        }
        this.destroy();
        this.sprite.emitter().burst(Speck.factory(7), 15);
        this.sprite.killAndErase();
    }
}

