/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.SheepSprite;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class Sheep
extends NPC {
    private static final String[] LINE_KEYS = new String[]{"Baa!", "Baa?", "Baa.", "Baa..."};
    public float lifespan;
    private boolean initialized;

    public Sheep() {
        this.spriteClass = SheepSprite.class;
        this.initialized = false;
    }

    @Override
    protected boolean act() {
        if (this.initialized) {
            this.HP = 0;
            this.destroy();
            this.sprite.die();
        } else {
            this.initialized = true;
            this.spend(this.lifespan + Random.Float(2.0f));
        }
        return true;
    }

    @Override
    public int defenseSkill(Char enemy) {
        return INFINITE_EVASION;
    }

    @Override
    public void damage(int dmg, Object src) {
    }

    @Override
    public void add(Buff buff) {
    }

    @Override
    public boolean interact(Char c) {
        this.sprite.showStatus(0xFFFF00, Messages.get(this, Random.element(LINE_KEYS), new Object[0]), new Object[0]);
        if (c == Dungeon.hero) {
            Dungeon.hero.spendAndNext(1.0f);
            Sample.INSTANCE.play("sounds/sheep.mp3", 1.0f, Random.Float(0.91f, 1.1f));
        }
        return true;
    }
}

