/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ElmoParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ShopkeeperSprite;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTradeItem;
import com.watabou.noosa.Game;
import com.watabou.utils.Callback;

public class Shopkeeper
extends NPC {
    private static WndBag.ItemSelector itemSelector = new WndBag.ItemSelector(){

        @Override
        public String textPrompt() {
            return Messages.get(Shopkeeper.class, "sell", new Object[0]);
        }

        @Override
        public boolean itemSelectable(Item item) {
            return Shopkeeper.canSell(item);
        }

        @Override
        public void onSelect(Item item) {
            if (item != null) {
                WndBag parentWnd = Shopkeeper.sell();
                GameScene.show(new WndTradeItem(item, parentWnd));
            }
        }
    };

    public Shopkeeper() {
        this.spriteClass = ShopkeeperSprite.class;
        this.properties.add(Char.Property.IMMOVABLE);
    }

    @Override
    protected boolean act() {
        if (Dungeon.level.heroFOV[this.pos]) {
            Notes.add(Notes.Landmark.SHOP);
        }
        this.sprite.turnTo(this.pos, Dungeon.hero.pos);
        this.spend(1.0f);
        return super.act();
    }

    @Override
    public void damage(int dmg, Object src) {
        this.flee();
    }

    @Override
    public void add(Buff buff) {
        this.flee();
    }

    public void flee() {
        this.destroy();
        Notes.remove(Notes.Landmark.SHOP);
        this.sprite.killAndErase();
        CellEmitter.get(this.pos).burst(ElmoParticle.FACTORY, 6);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (Heap heap : Dungeon.level.heaps.valueList()) {
            if (heap.type != Heap.Type.FOR_SALE) continue;
            CellEmitter.get(heap.pos).burst(ElmoParticle.FACTORY, 4);
            if (heap.size() == 1) {
                heap.destroy();
                continue;
            }
            heap.items.remove(heap.size() - 1);
            heap.type = Heap.Type.HEAP;
        }
    }

    @Override
    public boolean reset() {
        return true;
    }

    public static int sellPrice(Item item) {
        return item.value() * 5 * (Dungeon.depth / 5 + 1);
    }

    public static WndBag sell() {
        return GameScene.selectItem(itemSelector);
    }

    public static boolean canSell(Item item) {
        if (item.value() <= 0) {
            return false;
        }
        if (item.unique && !item.stackable) {
            return false;
        }
        if (item instanceof Armor && ((Armor)item).checkSeal() != null) {
            return false;
        }
        return !item.isEquipped(Dungeon.hero) || !item.cursed;
    }

    @Override
    public boolean interact(Char c) {
        if (c != Dungeon.hero) {
            return true;
        }
        Game.runOnRenderThread(new Callback(){

            @Override
            public void call() {
                Shopkeeper.sell();
            }
        });
        return true;
    }
}

