/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.CeremonialCandle;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.CorpseDust;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.Embers;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.MassGraveRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.RotGardenRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.RitualSiteRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Rotberry;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.WandmakerSprite;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndQuest;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndWandmaker;
import com.watabou.noosa.Game;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Wandmaker
extends NPC {
    public Wandmaker() {
        this.spriteClass = WandmakerSprite.class;
        this.properties.add(Char.Property.IMMOVABLE);
    }

    @Override
    protected boolean act() {
        if (Dungeon.level.heroFOV[this.pos] && Quest.wand1 != null) {
            Notes.add(Notes.Landmark.WANDMAKER);
        }
        return super.act();
    }

    @Override
    public int defenseSkill(Char enemy) {
        return INFINITE_EVASION;
    }

    @Override
    public void damage(int dmg, Object src) {
    }

    @Override
    public void add(Buff buff) {
    }

    @Override
    public boolean reset() {
        return true;
    }

    @Override
    public boolean interact(Char c) {
        this.sprite.turnTo(this.pos, Dungeon.hero.pos);
        if (c != Dungeon.hero) {
            return true;
        }
        if (Quest.given) {
            Item item;
            switch (Quest.type) {
                default: {
                    item = Dungeon.hero.belongings.getItem(CorpseDust.class);
                    break;
                }
                case 2: {
                    item = Dungeon.hero.belongings.getItem(Embers.class);
                    break;
                }
                case 3: {
                    item = Dungeon.hero.belongings.getItem(Rotberry.Seed.class);
                }
            }
            if (item != null) {
                Game.runOnRenderThread(new Callback(){

                    @Override
                    public void call() {
                        GameScene.show(new WndWandmaker(Wandmaker.this, item));
                    }
                });
            } else {
                String msg;
                switch (Quest.type) {
                    default: {
                        msg = Messages.get(this, "reminder_dust", Dungeon.hero.name());
                        break;
                    }
                    case 2: {
                        msg = Messages.get(this, "reminder_ember", Dungeon.hero.name());
                        break;
                    }
                    case 3: {
                        msg = Messages.get(this, "reminder_berry", Dungeon.hero.name());
                    }
                }
                Game.runOnRenderThread(new Callback(){

                    @Override
                    public void call() {
                        GameScene.show(new WndQuest(Wandmaker.this, msg));
                    }
                });
            }
        } else {
            String msg1 = "";
            String msg2 = "";
            switch (Dungeon.hero.heroClass) {
                case WARRIOR: {
                    msg1 = msg1 + Messages.get(this, "intro_warrior", new Object[0]);
                    break;
                }
                case ROGUE: {
                    msg1 = msg1 + Messages.get(this, "intro_rogue", new Object[0]);
                    break;
                }
                case MAGE: {
                    msg1 = msg1 + Messages.get(this, "intro_mage", Dungeon.hero.name());
                    break;
                }
                case HUNTRESS: {
                    msg1 = msg1 + Messages.get(this, "intro_huntress", new Object[0]);
                }
            }
            msg1 = msg1 + Messages.get(this, "intro_1", new Object[0]);
            switch (Quest.type) {
                case 1: {
                    msg2 = msg2 + Messages.get(this, "intro_dust", new Object[0]);
                    break;
                }
                case 2: {
                    msg2 = msg2 + Messages.get(this, "intro_ember", new Object[0]);
                    break;
                }
                case 3: {
                    msg2 = msg2 + Messages.get(this, "intro_berry", new Object[0]);
                }
            }
            msg2 = msg2 + Messages.get(this, "intro_2", new Object[0]);
            final String msg1Final = msg1;
            final String msg2Final = msg2;
            Game.runOnRenderThread(new Callback(){

                @Override
                public void call() {
                    GameScene.show(new WndQuest(Wandmaker.this, msg1Final){

                        @Override
                        public void hide() {
                            super.hide();
                            GameScene.show(new WndQuest(Wandmaker.this, msg2Final));
                        }
                    });
                }
            });
            Quest.given = true;
            Notes.add(Notes.Landmark.WANDMAKER);
        }
        return true;
    }

    public static class Quest {
        private static int type;
        private static boolean spawned;
        private static boolean given;
        public static Wand wand1;
        public static Wand wand2;
        private static final String NODE = "wandmaker";
        private static final String SPAWNED = "spawned";
        private static final String TYPE = "type";
        private static final String GIVEN = "given";
        private static final String WAND1 = "wand1";
        private static final String WAND2 = "wand2";
        private static final String RITUALPOS = "ritualpos";
        private static boolean questRoomSpawned;

        public static void reset() {
            spawned = false;
            type = 0;
            wand1 = null;
            wand2 = null;
        }

        public static void storeInBundle(Bundle bundle) {
            Bundle node = new Bundle();
            node.put(SPAWNED, spawned);
            if (spawned) {
                node.put(TYPE, type);
                node.put(GIVEN, given);
                node.put(WAND1, wand1);
                node.put(WAND2, wand2);
                if (type == 2) {
                    node.put(RITUALPOS, CeremonialCandle.ritualPos);
                }
            }
            bundle.put(NODE, node);
        }

        public static void restoreFromBundle(Bundle bundle) {
            Bundle node = bundle.getBundle(NODE);
            if (!node.isNull() && (spawned = node.getBoolean(SPAWNED))) {
                type = node.getInt(TYPE);
                given = node.getBoolean(GIVEN);
                wand1 = (Wand)node.get(WAND1);
                wand2 = (Wand)node.get(WAND2);
                if (type == 2) {
                    CeremonialCandle.ritualPos = node.getInt(RITUALPOS);
                }
            } else {
                Quest.reset();
            }
        }

        public static void spawnWandmaker(Level level, Room room) {
            if (questRoomSpawned) {
                boolean validPos;
                questRoomSpawned = false;
                Wandmaker npc = new Wandmaker();
                do {
                    validPos = true;
                    npc.pos = level.pointToCell(room.random());
                    if (npc.pos == level.entrance) {
                        validPos = false;
                    }
                    for (Point point : room.connected.values()) {
                        if (!(level.trueDistance(npc.pos, level.pointToCell(point)) <= 1.0f)) continue;
                        validPos = false;
                    }
                    if (level.traps.get(npc.pos) == null) continue;
                    validPos = false;
                } while (!validPos);
                level.mobs.add(npc);
                spawned = true;
                given = false;
                wand1 = (Wand)Generator.random(Generator.Category.WAND);
                Quest.wand1.cursed = false;
                wand1.upgrade();
                while ((wand2 = (Wand)Generator.random(Generator.Category.WAND)).getClass().equals(wand1.getClass())) {
                }
                Quest.wand2.cursed = false;
                wand2.upgrade();
            }
        }

        public static ArrayList<Room> spawnRoom(ArrayList<Room> rooms) {
            questRoomSpawned = false;
            if (!spawned && (type != 0 || Dungeon.depth > 6 && Random.Int(10 - Dungeon.depth) == 0)) {
                if (type == 0) {
                    type = Random.Int(3) + 1;
                }
                switch (type) {
                    default: {
                        rooms.add(new MassGraveRoom());
                        break;
                    }
                    case 2: {
                        rooms.add(new RitualSiteRoom());
                        break;
                    }
                    case 3: {
                        rooms.add(new RotGardenRoom());
                    }
                }
                questRoomSpawned = true;
            }
            return rooms;
        }

        public static void complete() {
            wand1 = null;
            wand2 = null;
            Notes.remove(Notes.Landmark.WANDMAKER);
        }
    }
}

