/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShieldBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndUseItem;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import java.util.ArrayList;

public class BrokenSeal
extends Item {
    public static final String AC_AFFIX = "AFFIX";
    public static final String AC_INFO = "INFO_WINDOW";
    private Armor.Glyph glyph;
    protected static WndBag.ItemSelector armorSelector = new WndBag.ItemSelector(){

        @Override
        public String textPrompt() {
            return Messages.get(BrokenSeal.class, "prompt", new Object[0]);
        }

        @Override
        public Class<? extends Bag> preferredBag() {
            return Belongings.Backpack.class;
        }

        @Override
        public boolean itemSelectable(Item item) {
            return item instanceof Armor;
        }

        @Override
        public void onSelect(Item item) {
            final BrokenSeal seal = (BrokenSeal)Item.curItem;
            if (item != null && item instanceof Armor) {
                final Armor armor = (Armor)item;
                if (!armor.levelKnown) {
                    GLog.w(Messages.get(BrokenSeal.class, "unknown_armor", new Object[0]), new Object[0]);
                } else if (!(!armor.cursed && armor.level() >= 0 || seal.getGlyph() != null && seal.getGlyph().curse())) {
                    GLog.w(Messages.get(BrokenSeal.class, "degraded_armor", new Object[0]), new Object[0]);
                } else if (armor.glyph != null && seal.getGlyph() != null && armor.glyph.getClass() != seal.getGlyph().getClass()) {
                    GameScene.show(new WndOptions(new ItemSprite(seal), Messages.get(BrokenSeal.class, "choose_title", new Object[0]), Messages.get(BrokenSeal.class, "choose_desc", new Object[0]), new String[]{armor.glyph.name(), seal.getGlyph().name()}){

                        @Override
                        protected void onSelect(int index) {
                            if (index == 0) {
                                seal.setGlyph(null);
                            }
                            GLog.p(Messages.get(BrokenSeal.class, "affix", new Object[0]), new Object[0]);
                            Dungeon.hero.sprite.operate(Dungeon.hero.pos);
                            Sample.INSTANCE.play("sounds/unlock.mp3");
                            armor.affixSeal(seal);
                            seal.detach(Dungeon.hero.belongings.backpack);
                        }
                    });
                } else {
                    GLog.p(Messages.get(BrokenSeal.class, "affix", new Object[0]), new Object[0]);
                    Dungeon.hero.sprite.operate(Dungeon.hero.pos);
                    Sample.INSTANCE.play("sounds/unlock.mp3");
                    armor.affixSeal((BrokenSeal)Item.curItem);
                    Item.curItem.detach(Dungeon.hero.belongings.backpack);
                }
            }
        }
    };
    private static final String GLYPH = "glyph";

    public BrokenSeal() {
        this.image = ItemSpriteSheet.SEAL;
        this.levelKnown = true;
        this.cursedKnown = true;
        this.unique = true;
        this.bones = false;
        this.defaultAction = AC_INFO;
    }

    public Armor.Glyph getGlyph() {
        return this.glyph;
    }

    public void setGlyph(Armor.Glyph glyph) {
        this.glyph = glyph;
    }

    public int maxShield(int armTier, int armLvl) {
        return armTier + armLvl + Dungeon.hero.pointsInTalent(Talent.IRON_WILL);
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return this.glyph != null ? this.glyph.glowing() : null;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_AFFIX);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_AFFIX)) {
            curItem = this;
            GameScene.selectItem(armorSelector);
        } else if (action.equals(AC_INFO)) {
            GameScene.show(new WndUseItem(null, this));
        }
    }

    @Override
    public boolean isUpgradable() {
        return this.level() == 0;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(GLYPH, this.glyph);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.glyph = (Armor.Glyph)bundle.get(GLYPH);
    }

    public static class WarriorShield
    extends ShieldBuff {
        private Armor armor;
        private float partialShield;

        @Override
        public synchronized boolean act() {
            if (this.shielding() < this.maxShield()) {
                this.partialShield += 0.033333335f;
            }
            while (this.partialShield >= 1.0f) {
                this.incShield();
                this.partialShield -= 1.0f;
            }
            if (this.shielding() <= 0 && this.maxShield() <= 0) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }

        public synchronized void supercharge(int maxShield) {
            if (maxShield > this.shielding()) {
                this.setShield(maxShield);
            }
        }

        public synchronized void setArmor(Armor arm) {
            this.armor = arm;
        }

        public synchronized int maxShield() {
            if (this.armor != null && this.armor.isEquipped((Hero)this.target) && this.armor.checkSeal() != null) {
                return this.armor.checkSeal().maxShield(this.armor.tier, this.armor.level());
            }
            return 0;
        }

        @Override
        public int absorbDamage(int dmg) {
            if (this.shielding() <= 0) {
                return dmg;
            }
            if (this.shielding() >= dmg) {
                this.decShield(dmg);
                dmg = 0;
            } else {
                dmg -= this.shielding();
                this.decShield(this.shielding());
            }
            return dmg;
        }
    }
}

