/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClothArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.LeatherArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.MailArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.PlateArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ScaleArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.AlchemistsToolkit;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.CapeOfThorns;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.ChaliceOfBlood;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.CloakOfShadows;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.DriedRose;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.EtherealChains;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.HornOfPlenty;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.LloydsBeacon;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.MasterThievesArmband;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.SandalsOfNature;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TalismanOfForesight;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TimekeepersHourglass;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.UnstableSpellbook;
import com.shatteredpixel.shatteredpixeldungeon.items.food.Food;
import com.shatteredpixel.shatteredpixeldungeon.items.food.MysteryMeat;
import com.shatteredpixel.shatteredpixeldungeon.items.food.Pasty;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfExperience;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfFrost;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHaste;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfInvisibility;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLevitation;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLiquidFlame;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfMindVision;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfParalyticGas;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfPurity;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfStrength;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfToxicGas;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfAccuracy;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfElements;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfEnergy;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfEvasion;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfForce;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfFuror;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfHaste;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfMight;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfTenacity;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfWealth;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.Scroll;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfIdentify;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfLullaby;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfMagicMapping;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfMirrorImage;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRage;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRecharging;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRemoveCurse;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRetribution;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTerror;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTransmutation;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.Runestone;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfAggression;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfAugmentation;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfBlast;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfBlink;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfClairvoyance;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfDeepSleep;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfDisarming;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfEnchantment;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfFear;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfFlock;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfIntuition;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfShock;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfCorrosion;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfCorruption;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfDisintegration;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfFireblast;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfFrost;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLightning;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLivingEarth;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfMagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfPrismaticLight;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfRegrowth;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfTransfusion;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfWarding;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssassinsBlade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.BattleAxe;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Crossbow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Dagger;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Dirk;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Flail;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gauntlet;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Glaive;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gloves;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Greataxe;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Greatshield;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Greatsword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HandAxe;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Longsword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Mace;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Quarterstaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RoundShield;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RunicBlade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Sai;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Scimitar;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Shortsword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Spear;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Sword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WarHammer;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Whip;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WornShortsword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Bolas;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.FishingSpear;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ForceCube;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.HeavyBoomerang;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Javelin;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Kunai;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Shuriken;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingClub;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingHammer;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingKnife;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingSpear;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingStone;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Tomahawk;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Trident;
import com.shatteredpixel.shatteredpixeldungeon.plants.Blindweed;
import com.shatteredpixel.shatteredpixeldungeon.plants.Dreamfoil;
import com.shatteredpixel.shatteredpixeldungeon.plants.Earthroot;
import com.shatteredpixel.shatteredpixeldungeon.plants.Fadeleaf;
import com.shatteredpixel.shatteredpixeldungeon.plants.Firebloom;
import com.shatteredpixel.shatteredpixeldungeon.plants.Icecap;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.plants.Rotberry;
import com.shatteredpixel.shatteredpixeldungeon.plants.Sorrowmoss;
import com.shatteredpixel.shatteredpixeldungeon.plants.Starflower;
import com.shatteredpixel.shatteredpixeldungeon.plants.Stormvine;
import com.shatteredpixel.shatteredpixeldungeon.plants.Sungrass;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.watabou.utils.Bundle;
import com.watabou.utils.GameMath;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class Generator {
    private static final float[][] floorSetTierProbs = new float[][]{{0.0f, 75.0f, 20.0f, 4.0f, 1.0f}, {0.0f, 25.0f, 50.0f, 20.0f, 5.0f}, {0.0f, 0.0f, 40.0f, 50.0f, 10.0f}, {0.0f, 0.0f, 20.0f, 40.0f, 40.0f}, {0.0f, 0.0f, 0.0f, 20.0f, 80.0f}};
    private static boolean usingFirstDeck = false;
    private static HashMap<Category, Float> categoryProbs = new LinkedHashMap<Category, Float>();
    public static final Category[] wepTiers = new Category[]{Category.WEP_T1, Category.WEP_T2, Category.WEP_T3, Category.WEP_T4, Category.WEP_T5};
    public static final Category[] misTiers = new Category[]{Category.MIS_T1, Category.MIS_T2, Category.MIS_T3, Category.MIS_T4, Category.MIS_T5};
    private static final String FIRST_DECK = "first_deck";
    private static final String GENERAL_PROBS = "general_probs";
    private static final String CATEGORY_PROBS = "_probs";

    public static void fullReset() {
        usingFirstDeck = Random.Int(2) == 0;
        Generator.generalReset();
        for (Category cat : Category.values()) {
            Generator.reset(cat);
        }
    }

    public static void generalReset() {
        for (Category cat : Category.values()) {
            categoryProbs.put(cat, Float.valueOf(usingFirstDeck ? cat.firstProb : cat.secondProb));
        }
    }

    public static void reset(Category cat) {
        if (cat.defaultProbs != null) {
            cat.probs = (float[])cat.defaultProbs.clone();
        }
    }

    public static Item random() {
        Category cat = Random.chances(categoryProbs);
        if (cat == null) {
            usingFirstDeck = !usingFirstDeck;
            Generator.generalReset();
            cat = Random.chances(categoryProbs);
        }
        categoryProbs.put(cat, Float.valueOf(categoryProbs.get((Object)cat).floatValue() - 1.0f));
        return Generator.random(cat);
    }

    public static Item random(Category cat) {
        switch (cat) {
            case ARMOR: {
                return Generator.randomArmor();
            }
            case WEAPON: {
                return Generator.randomWeapon();
            }
            case MISSILE: {
                return Generator.randomMissile();
            }
            case ARTIFACT: {
                Artifact item = Generator.randomArtifact();
                return item != null ? item : Generator.random(Category.RING);
            }
        }
        int i = Random.chances(cat.probs);
        if (i == -1) {
            Generator.reset(cat);
            i = Random.chances(cat.probs);
        }
        if (cat.defaultProbs != null) {
            int n = i;
            cat.probs[n] = cat.probs[n] - 1.0f;
        }
        return ((Item)Reflection.newInstance(cat.classes[i])).random();
    }

    public static Item randomUsingDefaults(Category cat) {
        if (cat.defaultProbs == null) {
            return Generator.random(cat);
        }
        return ((Item)Reflection.newInstance(cat.classes[Random.chances(cat.defaultProbs)])).random();
    }

    public static Item random(Class<? extends Item> cl) {
        return Reflection.newInstance(cl).random();
    }

    public static Armor randomArmor() {
        return Generator.randomArmor(Dungeon.depth / 5);
    }

    public static Armor randomArmor(int floorSet) {
        floorSet = (int)GameMath.gate(0.0f, floorSet, floorSetTierProbs.length - 1);
        Armor a = (Armor)Reflection.newInstance(Category.ARMOR.classes[Random.chances(floorSetTierProbs[floorSet])]);
        a.random();
        return a;
    }

    public static MeleeWeapon randomWeapon() {
        return Generator.randomWeapon(Dungeon.depth / 5);
    }

    public static MeleeWeapon randomWeapon(int floorSet) {
        floorSet = (int)GameMath.gate(0.0f, floorSet, floorSetTierProbs.length - 1);
        Category c = wepTiers[Random.chances(floorSetTierProbs[floorSet])];
        MeleeWeapon w = (MeleeWeapon)Reflection.newInstance(c.classes[Random.chances(c.probs)]);
        w.random();
        return w;
    }

    public static MissileWeapon randomMissile() {
        return Generator.randomMissile(Dungeon.depth / 5);
    }

    public static MissileWeapon randomMissile(int floorSet) {
        floorSet = (int)GameMath.gate(0.0f, floorSet, floorSetTierProbs.length - 1);
        Category c = misTiers[Random.chances(floorSetTierProbs[floorSet])];
        MissileWeapon w = (MissileWeapon)Reflection.newInstance(c.classes[Random.chances(c.probs)]);
        w.random();
        return w;
    }

    public static Artifact randomArtifact() {
        Category cat = Category.ARTIFACT;
        int i = Random.chances(cat.probs);
        if (i == -1) {
            return null;
        }
        int n = i;
        cat.probs[n] = cat.probs[n] - 1.0f;
        return (Artifact)((Artifact)Reflection.newInstance(cat.classes[i])).random();
    }

    public static boolean removeArtifact(Class<? extends Artifact> artifact) {
        Category cat = Category.ARTIFACT;
        for (int i = 0; i < cat.classes.length; ++i) {
            if (!cat.classes[i].equals(artifact) || !(cat.probs[i] > 0.0f)) continue;
            cat.probs[i] = 0.0f;
            return true;
        }
        return false;
    }

    public static void storeInBundle(Bundle bundle) {
        bundle.put(FIRST_DECK, usingFirstDeck);
        Float[] genProbs = categoryProbs.values().toArray(new Float[0]);
        float[] storeProbs = new float[genProbs.length];
        for (int i = 0; i < storeProbs.length; ++i) {
            storeProbs[i] = genProbs[i].floatValue();
        }
        bundle.put(GENERAL_PROBS, storeProbs);
        for (Category cat : Category.values()) {
            if (cat.defaultProbs == null) continue;
            boolean needsStore = false;
            for (int i = 0; i < cat.probs.length; ++i) {
                if (cat.probs[i] == cat.defaultProbs[i]) continue;
                needsStore = true;
                break;
            }
            if (!needsStore) continue;
            bundle.put(cat.name().toLowerCase() + CATEGORY_PROBS, cat.probs);
        }
    }

    public static void restoreFromBundle(Bundle bundle) {
        Generator.fullReset();
        usingFirstDeck = bundle.getBoolean(FIRST_DECK);
        if (bundle.contains(GENERAL_PROBS)) {
            float[] probs = bundle.getFloatArray(GENERAL_PROBS);
            for (int i = 0; i < probs.length; ++i) {
                categoryProbs.put(Category.values()[i], Float.valueOf(probs[i]));
            }
        }
        for (Category cat : Category.values()) {
            if (!bundle.contains(cat.name().toLowerCase() + CATEGORY_PROBS)) continue;
            float[] probs = bundle.getFloatArray(cat.name().toLowerCase() + CATEGORY_PROBS);
            if (cat.defaultProbs == null || probs.length != cat.defaultProbs.length) continue;
            cat.probs = probs;
        }
    }

    public static enum Category {
        WEAPON(2.0f, 2.0f, MeleeWeapon.class),
        WEP_T1(0.0f, 0.0f, MeleeWeapon.class),
        WEP_T2(0.0f, 0.0f, MeleeWeapon.class),
        WEP_T3(0.0f, 0.0f, MeleeWeapon.class),
        WEP_T4(0.0f, 0.0f, MeleeWeapon.class),
        WEP_T5(0.0f, 0.0f, MeleeWeapon.class),
        ARMOR(2.0f, 1.0f, Armor.class),
        MISSILE(1.0f, 2.0f, MissileWeapon.class),
        MIS_T1(0.0f, 0.0f, MissileWeapon.class),
        MIS_T2(0.0f, 0.0f, MissileWeapon.class),
        MIS_T3(0.0f, 0.0f, MissileWeapon.class),
        MIS_T4(0.0f, 0.0f, MissileWeapon.class),
        MIS_T5(0.0f, 0.0f, MissileWeapon.class),
        WAND(1.0f, 1.0f, Wand.class),
        RING(1.0f, 0.0f, Ring.class),
        ARTIFACT(0.0f, 1.0f, Artifact.class),
        FOOD(0.0f, 0.0f, Food.class),
        POTION(8.0f, 8.0f, Potion.class),
        SEED(1.0f, 1.0f, Plant.Seed.class),
        SCROLL(8.0f, 8.0f, Scroll.class),
        STONE(1.0f, 1.0f, Runestone.class),
        GOLD(10.0f, 10.0f, Gold.class);

        public Class<?>[] classes;
        public float[] probs;
        public float[] defaultProbs = null;
        public float firstProb;
        public float secondProb;
        public Class<? extends Item> superClass;

        private Category(float firstProb, float secondProb, Class<? extends Item> superClass) {
            this.firstProb = firstProb;
            this.secondProb = secondProb;
            this.superClass = superClass;
        }

        public static int order(Item item) {
            for (int i = 0; i < Category.values().length; ++i) {
                if (!Category.values()[i].superClass.isInstance(item)) continue;
                return i;
            }
            return Short.MAX_VALUE + item.image();
        }

        static {
            Category.GOLD.classes = new Class[]{Gold.class};
            Category.GOLD.probs = new float[]{1.0f};
            Category.POTION.classes = new Class[]{PotionOfStrength.class, PotionOfHealing.class, PotionOfMindVision.class, PotionOfFrost.class, PotionOfLiquidFlame.class, PotionOfToxicGas.class, PotionOfHaste.class, PotionOfInvisibility.class, PotionOfLevitation.class, PotionOfParalyticGas.class, PotionOfPurity.class, PotionOfExperience.class};
            Category.POTION.defaultProbs = new float[]{0.0f, 6.0f, 4.0f, 3.0f, 3.0f, 3.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 1.0f};
            Category.POTION.probs = (float[])Category.POTION.defaultProbs.clone();
            Category.SEED.classes = new Class[]{Rotberry.Seed.class, Sungrass.Seed.class, Fadeleaf.Seed.class, Icecap.Seed.class, Firebloom.Seed.class, Sorrowmoss.Seed.class, Swiftthistle.Seed.class, Blindweed.Seed.class, Stormvine.Seed.class, Earthroot.Seed.class, Dreamfoil.Seed.class, Starflower.Seed.class};
            Category.SEED.defaultProbs = new float[]{0.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 2.0f};
            Category.SEED.probs = (float[])Category.SEED.defaultProbs.clone();
            Category.SCROLL.classes = new Class[]{ScrollOfUpgrade.class, ScrollOfIdentify.class, ScrollOfRemoveCurse.class, ScrollOfMirrorImage.class, ScrollOfRecharging.class, ScrollOfTeleportation.class, ScrollOfLullaby.class, ScrollOfMagicMapping.class, ScrollOfRage.class, ScrollOfRetribution.class, ScrollOfTerror.class, ScrollOfTransmutation.class};
            Category.SCROLL.defaultProbs = new float[]{0.0f, 6.0f, 4.0f, 3.0f, 3.0f, 3.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 1.0f};
            Category.SCROLL.probs = (float[])Category.SCROLL.defaultProbs.clone();
            Category.STONE.classes = new Class[]{StoneOfEnchantment.class, StoneOfIntuition.class, StoneOfDisarming.class, StoneOfFlock.class, StoneOfShock.class, StoneOfBlink.class, StoneOfDeepSleep.class, StoneOfClairvoyance.class, StoneOfAggression.class, StoneOfBlast.class, StoneOfFear.class, StoneOfAugmentation.class};
            Category.STONE.defaultProbs = new float[]{0.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 0.0f};
            Category.STONE.probs = (float[])Category.STONE.defaultProbs.clone();
            Category.WAND.classes = new Class[]{WandOfMagicMissile.class, WandOfLightning.class, WandOfDisintegration.class, WandOfFireblast.class, WandOfCorrosion.class, WandOfBlastWave.class, WandOfLivingEarth.class, WandOfFrost.class, WandOfPrismaticLight.class, WandOfWarding.class, WandOfTransfusion.class, WandOfCorruption.class, WandOfRegrowth.class};
            Category.WAND.probs = new float[]{4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};
            Category.WEAPON.classes = new Class[0];
            Category.WEAPON.probs = new float[0];
            Category.WEP_T1.classes = new Class[]{WornShortsword.class, Gloves.class, Dagger.class, MagesStaff.class};
            Category.WEP_T1.probs = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            Category.WEP_T2.classes = new Class[]{Shortsword.class, HandAxe.class, Spear.class, Quarterstaff.class, Dirk.class};
            Category.WEP_T2.probs = new float[]{6.0f, 5.0f, 5.0f, 4.0f, 4.0f};
            Category.WEP_T3.classes = new Class[]{Sword.class, Mace.class, Scimitar.class, RoundShield.class, Sai.class, Whip.class};
            Category.WEP_T3.probs = new float[]{6.0f, 5.0f, 5.0f, 4.0f, 4.0f, 4.0f};
            Category.WEP_T4.classes = new Class[]{Longsword.class, BattleAxe.class, Flail.class, RunicBlade.class, AssassinsBlade.class, Crossbow.class};
            Category.WEP_T4.probs = new float[]{6.0f, 5.0f, 5.0f, 4.0f, 4.0f, 4.0f};
            Category.WEP_T5.classes = new Class[]{Greatsword.class, WarHammer.class, Glaive.class, Greataxe.class, Greatshield.class, Gauntlet.class};
            Category.WEP_T5.probs = new float[]{6.0f, 5.0f, 5.0f, 4.0f, 4.0f, 4.0f};
            Category.ARMOR.classes = new Class[]{ClothArmor.class, LeatherArmor.class, MailArmor.class, ScaleArmor.class, PlateArmor.class};
            Category.ARMOR.probs = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            Category.MISSILE.classes = new Class[0];
            Category.MISSILE.probs = new float[0];
            Category.MIS_T1.classes = new Class[]{ThrowingStone.class, ThrowingKnife.class};
            Category.MIS_T1.probs = new float[]{6.0f, 5.0f};
            Category.MIS_T2.classes = new Class[]{FishingSpear.class, ThrowingClub.class, Shuriken.class};
            Category.MIS_T2.probs = new float[]{6.0f, 5.0f, 4.0f};
            Category.MIS_T3.classes = new Class[]{ThrowingSpear.class, Kunai.class, Bolas.class};
            Category.MIS_T3.probs = new float[]{6.0f, 5.0f, 4.0f};
            Category.MIS_T4.classes = new Class[]{Javelin.class, Tomahawk.class, HeavyBoomerang.class};
            Category.MIS_T4.probs = new float[]{6.0f, 5.0f, 4.0f};
            Category.MIS_T5.classes = new Class[]{Trident.class, ThrowingHammer.class, ForceCube.class};
            Category.MIS_T5.probs = new float[]{6.0f, 5.0f, 4.0f};
            Category.FOOD.classes = new Class[]{Food.class, Pasty.class, MysteryMeat.class};
            Category.FOOD.probs = new float[]{4.0f, 1.0f, 0.0f};
            Category.RING.classes = new Class[]{RingOfAccuracy.class, RingOfEvasion.class, RingOfElements.class, RingOfForce.class, RingOfFuror.class, RingOfHaste.class, RingOfEnergy.class, RingOfMight.class, RingOfSharpshooting.class, RingOfTenacity.class, RingOfWealth.class};
            Category.RING.probs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            Category.ARTIFACT.classes = new Class[]{CapeOfThorns.class, ChaliceOfBlood.class, CloakOfShadows.class, HornOfPlenty.class, MasterThievesArmband.class, SandalsOfNature.class, TalismanOfForesight.class, TimekeepersHourglass.class, UnstableSpellbook.class, AlchemistsToolkit.class, DriedRose.class, LloydsBeacon.class, EtherealChains.class};
            Category.ARTIFACT.defaultProbs = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
            Category.ARTIFACT.probs = (float[])Category.ARTIFACT.defaultProbs.clone();
        }
    }
}

