/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public abstract class KindOfWeapon
extends EquipableItem {
    protected static final float TIME_TO_EQUIP = 1.0f;
    protected String hitSound = "sounds/hit.mp3";
    protected float hitSoundPitch = 1.0f;

    @Override
    public boolean isEquipped(Hero hero) {
        return hero.belongings.weapon() == this;
    }

    @Override
    public boolean doEquip(Hero hero) {
        this.detachAll(hero.belongings.backpack);
        if (hero.belongings.weapon == null || hero.belongings.weapon.doUnequip(hero, true)) {
            hero.belongings.weapon = this;
            this.activate(hero);
            Talent.onItemEquipped(hero, this);
            ActionIndicator.updateIcon();
            KindOfWeapon.updateQuickslot();
            this.cursedKnown = true;
            if (this.cursed) {
                KindOfWeapon.equipCursed(hero);
                GLog.n(Messages.get(KindOfWeapon.class, "equip_cursed", new Object[0]), new Object[0]);
            }
            hero.spendAndNext(1.0f);
            return true;
        }
        this.collect(hero.belongings.backpack);
        return false;
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            hero.belongings.weapon = null;
            return true;
        }
        return false;
    }

    public int min() {
        return this.min(this.buffedLvl());
    }

    public int max() {
        return this.max(this.buffedLvl());
    }

    public abstract int min(int var1);

    public abstract int max(int var1);

    public int damageRoll(Char owner) {
        return Random.NormalIntRange(this.min(), this.max());
    }

    public float accuracyFactor(Char owner) {
        return 1.0f;
    }

    public float delayFactor(Char owner) {
        return 1.0f;
    }

    public int reachFactor(Char owner) {
        return 1;
    }

    public boolean canReach(Char owner, int target) {
        if (Dungeon.level.distance(owner.pos, target) > this.reachFactor(owner)) {
            return false;
        }
        boolean[] passable = BArray.not(Dungeon.level.solid, null);
        for (Char ch : Actor.chars()) {
            if (ch == owner) continue;
            passable[ch.pos] = false;
        }
        PathFinder.buildDistanceMap(target, passable, this.reachFactor(owner));
        return PathFinder.distance[owner.pos] <= this.reachFactor(owner);
    }

    public int defenseFactor(Char owner) {
        return 0;
    }

    public int proc(Char attacker, Char defender, int damage) {
        return damage;
    }

    public void hitSound(float pitch) {
        Sample.INSTANCE.play(this.hitSound, 1.0f, pitch * this.hitSoundPitch);
    }
}

