/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.Splash;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.MagicalHolster;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.darts.Dart;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.watabou.noosa.audio.Sample;
import java.util.ArrayList;

public class LiquidMetal
extends Item {
    private static final String AC_APPLY = "APPLY";
    private final WndBag.ItemSelector itemSelector;

    public LiquidMetal() {
        this.image = ItemSpriteSheet.LIQUID_METAL;
        this.stackable = true;
        this.defaultAction = AC_APPLY;
        this.bones = true;
        this.itemSelector = new WndBag.ItemSelector(){

            @Override
            public String textPrompt() {
                return Messages.get(LiquidMetal.class, "prompt", new Object[0]);
            }

            @Override
            public Class<? extends Bag> preferredBag() {
                return MagicalHolster.class;
            }

            @Override
            public boolean itemSelectable(Item item) {
                return item instanceof MissileWeapon && !(item instanceof Dart);
            }

            @Override
            public void onSelect(Item item) {
                block5: {
                    float durabilityPerMetal;
                    int maxToUse;
                    MissileWeapon m;
                    block7: {
                        block6: {
                            if (item == null || !(item instanceof MissileWeapon)) break block5;
                            m = (MissileWeapon)item;
                            maxToUse = 5 * (m.tier + 1);
                            maxToUse = (int)((double)maxToUse * Math.pow(2.0, m.level()));
                            durabilityPerMetal = 100.0f / (float)maxToUse;
                            float percentDurabilityLost = 0.999f - m.durabilityLeft() / 100.0f;
                            maxToUse = (int)Math.ceil((float)maxToUse * percentDurabilityLost);
                            float durPerUse = m.durabilityPerUse() / 100.0f;
                            if (maxToUse == 0) break block6;
                            if (!(Math.ceil(m.durabilityLeft() / m.durabilityPerUse()) >= Math.ceil(100.0f / m.durabilityPerUse()))) break block7;
                        }
                        GLog.w(Messages.get(LiquidMetal.class, "already_fixed", new Object[0]), new Object[0]);
                        return;
                    }
                    if (maxToUse < LiquidMetal.this.quantity()) {
                        m.repair((float)maxToUse * durabilityPerMetal);
                        LiquidMetal.this.quantity(LiquidMetal.this.quantity() - maxToUse);
                        GLog.i(Messages.get(LiquidMetal.class, "apply", maxToUse), new Object[0]);
                    } else {
                        m.repair((float)LiquidMetal.this.quantity() * durabilityPerMetal);
                        GLog.i(Messages.get(LiquidMetal.class, "apply", LiquidMetal.this.quantity()), new Object[0]);
                        LiquidMetal.this.detachAll(Dungeon.hero.belongings.backpack);
                    }
                    Item.curUser.sprite.operate(Item.curUser.pos);
                    Sample.INSTANCE.play("sounds/drink.mp3");
                    Item.updateQuickslot();
                    Item.curUser.sprite.emitter().start(Speck.factory(2), 0.1f, 10);
                }
            }
        };
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_APPLY);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_APPLY)) {
            curUser = hero;
            GameScene.selectItem(this.itemSelector);
        }
    }

    @Override
    protected void onThrow(int cell) {
        if (Dungeon.level.map[cell] == 24 || Dungeon.level.pit[cell]) {
            super.onThrow(cell);
        } else {
            Dungeon.level.pressCell(cell);
            if (Dungeon.level.heroFOV[cell]) {
                GLog.i(Messages.get(Potion.class, "shatter", new Object[0]), new Object[0]);
                Sample.INSTANCE.play("sounds/shatter.mp3");
                Splash.at(cell, 0xBFBFBF, 5);
            }
        }
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return Math.max(1, this.quantity / 2);
    }

    public static class Recipe
    extends com.shatteredpixel.shatteredpixeldungeon.items.Recipe {
        @Override
        public boolean testIngredients(ArrayList<Item> ingredients) {
            for (Item i : ingredients) {
                if (i instanceof MissileWeapon) continue;
                return false;
            }
            return !ingredients.isEmpty();
        }

        @Override
        public int cost(ArrayList<Item> ingredients) {
            int cost = 1;
            for (Item i : ingredients) {
                cost += i.quantity();
            }
            return cost;
        }

        @Override
        public Item brew(ArrayList<Item> ingredients) {
            Item result = this.sampleOutput(ingredients);
            for (Item i : ingredients) {
                i.quantity(0);
            }
            return result;
        }

        @Override
        public Item sampleOutput(ArrayList<Item> ingredients) {
            int metalQuantity = 0;
            for (Item i : ingredients) {
                MissileWeapon m = (MissileWeapon)i;
                float quantity = m.quantity() - 1;
                quantity += 0.25f + 0.0075f * m.durabilityLeft();
                quantity = (float)((double)quantity * Math.pow(2.0, Math.min(3, m.level())));
                metalQuantity += Math.round((float)(5 * (m.tier + 1)) * quantity);
            }
            return new LiquidMetal().quantity(metalQuantity);
        }
    }
}

