/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Bundle;

public class Viscosity
extends Armor.Glyph {
    private static ItemSprite.Glowing PURPLE = new ItemSprite.Glowing(0x8844CC);

    @Override
    public int proc(Armor armor, Char attacker, Char defender, int damage) {
        int realDamage = damage - defender.drRoll();
        if (defender.buff(Talent.WarriorFoodImmunity.class) != null) {
            return damage;
        }
        if (attacker instanceof Hero && ((Hero)attacker).belongings.weapon() instanceof MissileWeapon && ((Hero)attacker).subClass == HeroSubClass.SNIPER && !Dungeon.level.adjacent(attacker.pos, defender.pos)) {
            realDamage = damage;
        }
        if (realDamage <= 0) {
            return 0;
        }
        int level = Math.max(0, armor.buffedLvl());
        float percent = (float)(level + 1) / (float)(level + 6);
        int amount = (int)Math.ceil((float)realDamage * percent);
        DeferedDamage deferred = Buff.affect(defender, DeferedDamage.class);
        deferred.prolong(amount);
        defender.sprite.showStatus(0xFF8800, Messages.get(this, "deferred", amount), new Object[0]);
        return damage - amount;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return PURPLE;
    }

    public static class DeferedDamage
    extends Buff {
        protected int damage;
        private static final String DAMAGE = "damage";

        public DeferedDamage() {
            this.type = Buff.buffType.NEGATIVE;
            this.damage = 0;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(DAMAGE, this.damage);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.damage = bundle.getInt(DAMAGE);
        }

        @Override
        public boolean attachTo(Char target) {
            if (super.attachTo(target)) {
                this.postpone(1.0f);
                return true;
            }
            return false;
        }

        public void prolong(int damage) {
            this.damage += damage;
        }

        @Override
        public int icon() {
            return 28;
        }

        @Override
        public String iconTextDisplay() {
            return Integer.toString(this.damage);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public boolean act() {
            if (this.target.isAlive()) {
                int damageThisTick = Math.max(1, (int)((float)this.damage * 0.1f));
                this.target.damage(damageThisTick, this);
                if (this.target == Dungeon.hero && !this.target.isAlive()) {
                    Badges.validateDeathFromGlyph();
                    Dungeon.fail(this.getClass());
                    GLog.n(Messages.get(this, "ondeath", new Object[0]), new Object[0]);
                }
                this.spend(1.0f);
                this.damage -= damageThisTick;
                if (this.damage <= 0) {
                    this.detach();
                }
            } else {
                this.detach();
            }
            return true;
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.damage);
        }
    }
}

