/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.bombs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Lightning;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SparkParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.bombs.Bomb;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTilemap;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class ShockBomb
extends Bomb {
    public ShockBomb() {
        this.image = ItemSpriteSheet.SHOCK_BOMB;
    }

    @Override
    public void explode(int cell) {
        super.explode(cell);
        ArrayList<Char> affected = new ArrayList<Char>();
        PathFinder.buildDistanceMap(cell, BArray.not(Dungeon.level.solid, null), 3);
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            if (PathFinder.distance[i] >= Integer.MAX_VALUE || Actor.findChar(i) == null) continue;
            affected.add(Actor.findChar(i));
        }
        for (Char ch : affected.toArray(new Char[0])) {
            Ballistica LOS = new Ballistica(cell, ch.pos, 7);
            if (LOS.collisionPos == ch.pos) continue;
            affected.remove(ch);
        }
        ArrayList<Lightning.Arc> arcs = new ArrayList<Lightning.Arc>();
        for (Char ch : affected) {
            int power = 16 - 4 * Dungeon.level.distance(ch.pos, cell);
            if (power <= 0) continue;
            int damage = Math.round((float)Random.NormalIntRange(5 + Dungeon.depth, 10 + 2 * Dungeon.depth) * ((float)power / 50.0f));
            ch.damage(damage, this);
            if (ch.isAlive()) {
                Buff.prolong(ch, Paralysis.class, power);
            }
            arcs.add(new Lightning.Arc(DungeonTilemap.tileCenterToWorld(cell), ch.sprite.center()));
        }
        CellEmitter.center(cell).burst(SparkParticle.FACTORY, 20);
        Dungeon.hero.sprite.parent.addToFront(new Lightning(arcs, null));
        Sample.INSTANCE.play("sounds/lightning.mp3");
    }

    @Override
    public int value() {
        return this.quantity * 50;
    }
}

