/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Enchanting;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.InventoryScroll;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ExoticScroll;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfEnchantment;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTitledMessage;
import com.watabou.noosa.audio.Sample;

public class ScrollOfEnchantment
extends ExoticScroll {
    protected static boolean identifiedByUse = false;
    protected WndBag.ItemSelector itemSelector;

    public ScrollOfEnchantment() {
        this.icon = ItemSpriteSheet.Icons.SCROLL_ENCHANT;
        this.unique = true;
        this.itemSelector = new WndBag.ItemSelector(){

            @Override
            public String textPrompt() {
                return Messages.get(ScrollOfEnchantment.class, "inv_title", new Object[0]);
            }

            @Override
            public Class<? extends Bag> preferredBag() {
                return Belongings.Backpack.class;
            }

            @Override
            public boolean itemSelectable(Item item) {
                return ScrollOfEnchantment.enchantable(item);
            }

            @Override
            public void onSelect(final Item item) {
                if (item instanceof Weapon) {
                    final Weapon.Enchantment[] enchants = new Weapon.Enchantment[3];
                    Class<?> existing = ((Weapon)item).enchantment != null ? ((Weapon)item).enchantment.getClass() : null;
                    enchants[0] = Weapon.Enchantment.randomCommon(existing);
                    enchants[1] = Weapon.Enchantment.randomUncommon(existing);
                    enchants[2] = Weapon.Enchantment.random(existing, enchants[0].getClass(), enchants[1].getClass());
                    GameScene.show(new WndOptions(new ItemSprite(ScrollOfEnchantment.this), Messages.titleCase(ScrollOfEnchantment.this.name()), Messages.get(ScrollOfEnchantment.class, "weapon", new Object[0]) + "\n\n" + Messages.get(ScrollOfEnchantment.class, "cancel_warn", new Object[0]), new String[]{enchants[0].name(), enchants[1].name(), enchants[2].name(), Messages.get(ScrollOfEnchantment.class, "cancel", new Object[0])}){

                        @Override
                        protected void onSelect(int index) {
                            if (index < 3) {
                                ((Weapon)item).enchant(enchants[index]);
                                GLog.p(Messages.get(StoneOfEnchantment.class, "weapon", new Object[0]), new Object[0]);
                                ((ScrollOfEnchantment)curItem).readAnimation();
                                Sample.INSTANCE.play("sounds/read.mp3");
                                Enchanting.show(curUser, item);
                                Talent.onUpgradeScrollUsed(Dungeon.hero);
                            }
                        }

                        @Override
                        protected boolean hasInfo(int index) {
                            return index < 3;
                        }

                        @Override
                        protected void onInfo(int index) {
                            GameScene.show(new WndTitledMessage(Icons.get(Icons.INFO), Messages.titleCase(enchants[index].name()), enchants[index].desc()));
                        }

                        @Override
                        public void onBackPressed() {
                        }
                    });
                } else if (item instanceof Armor) {
                    final Armor.Glyph[] glyphs = new Armor.Glyph[3];
                    Class<?> existing = ((Armor)item).glyph != null ? ((Armor)item).glyph.getClass() : null;
                    glyphs[0] = Armor.Glyph.randomCommon(existing);
                    glyphs[1] = Armor.Glyph.randomUncommon(existing);
                    glyphs[2] = Armor.Glyph.random(existing, glyphs[0].getClass(), glyphs[1].getClass());
                    GameScene.show(new WndOptions(new ItemSprite(ScrollOfEnchantment.this), Messages.titleCase(ScrollOfEnchantment.this.name()), Messages.get(ScrollOfEnchantment.class, "armor", new Object[0]) + "\n\n" + Messages.get(ScrollOfEnchantment.class, "cancel_warn", new Object[0]), new String[]{glyphs[0].name(), glyphs[1].name(), glyphs[2].name(), Messages.get(ScrollOfEnchantment.class, "cancel", new Object[0])}){

                        @Override
                        protected void onSelect(int index) {
                            if (index < 3) {
                                ((Armor)item).inscribe(glyphs[index]);
                                GLog.p(Messages.get(StoneOfEnchantment.class, "armor", new Object[0]), new Object[0]);
                                ((ScrollOfEnchantment)curItem).readAnimation();
                                Sample.INSTANCE.play("sounds/read.mp3");
                                Enchanting.show(curUser, item);
                                Talent.onUpgradeScrollUsed(Dungeon.hero);
                            }
                        }

                        @Override
                        protected boolean hasInfo(int index) {
                            return index < 3;
                        }

                        @Override
                        protected void onInfo(int index) {
                            GameScene.show(new WndTitledMessage(Icons.get(Icons.INFO), Messages.titleCase(glyphs[index].name()), glyphs[index].desc()));
                        }

                        @Override
                        public void onBackPressed() {
                        }
                    });
                } else if (!identifiedByUse) {
                    curItem.collect();
                } else {
                    ((ScrollOfEnchantment)curItem).confirmCancelation();
                }
            }
        };
    }

    @Override
    public void doRead() {
        if (!this.isKnown()) {
            this.identify();
            identifiedByUse = true;
        } else {
            identifiedByUse = false;
        }
        GameScene.selectItem(this.itemSelector);
    }

    public static boolean enchantable(Item item) {
        return item instanceof MeleeWeapon || item instanceof SpiritBow || item instanceof Armor;
    }

    private void confirmCancelation() {
        GameScene.show(new WndOptions(new ItemSprite(this), Messages.titleCase(this.name()), Messages.get(InventoryScroll.class, "warning", new Object[0]), new String[]{Messages.get(InventoryScroll.class, "yes", new Object[0]), Messages.get(InventoryScroll.class, "no", new Object[0])}){

            @Override
            protected void onSelect(int index) {
                switch (index) {
                    case 0: {
                        curUser.spendAndNext(1.0f);
                        identifiedByUse = false;
                        break;
                    }
                    case 1: {
                        GameScene.selectItem(ScrollOfEnchantment.this.itemSelector);
                    }
                }
            }

            @Override
            public void onBackPressed() {
            }
        });
    }
}

