/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TimekeepersHourglass;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfPassage;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.Spell;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;

public class BeaconOfReturning
extends Spell {
    public int returnDepth;
    public int returnPos;
    private static final ItemSprite.Glowing WHITE = new ItemSprite.Glowing(0xFFFFFF);
    private static final String DEPTH = "depth";
    private static final String POS = "pos";

    public BeaconOfReturning() {
        this.image = ItemSpriteSheet.RETURN_BEACON;
        this.returnDepth = -1;
    }

    @Override
    protected void onCast(final Hero hero) {
        if (this.returnDepth == -1) {
            this.setBeacon(hero);
        } else {
            GameScene.show(new WndOptions(new ItemSprite(this), Messages.titleCase(this.name()), Messages.get(BeaconOfReturning.class, "wnd_body", new Object[0]), new String[]{Messages.get(BeaconOfReturning.class, "wnd_set", new Object[0]), Messages.get(BeaconOfReturning.class, "wnd_return", new Object[0])}){

                @Override
                protected void onSelect(int index) {
                    if (index == 0) {
                        BeaconOfReturning.this.setBeacon(hero);
                    } else if (index == 1) {
                        BeaconOfReturning.this.returnBeacon(hero);
                    }
                }
            });
        }
    }

    @Override
    protected void onThrow(int cell) {
        this.returnDepth = -1;
        super.onThrow(cell);
    }

    @Override
    public void doDrop(Hero hero) {
        this.returnDepth = -1;
        super.doDrop(hero);
    }

    private void setBeacon(Hero hero) {
        this.returnDepth = Dungeon.depth;
        this.returnPos = hero.pos;
        hero.spend(1.0f);
        hero.busy();
        GLog.i(Messages.get(this, "set", new Object[0]), new Object[0]);
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/beacon.mp3");
        BeaconOfReturning.updateQuickslot();
    }

    private void returnBeacon(Hero hero) {
        if (Dungeon.level.locked) {
            GLog.w(Messages.get(this, "preventing", new Object[0]), new Object[0]);
            return;
        }
        for (int i = 0; i < PathFinder.NEIGHBOURS8.length; ++i) {
            Char ch = Actor.findChar(hero.pos + PathFinder.NEIGHBOURS8[i]);
            if (ch == null || ch.alignment != Char.Alignment.ENEMY) continue;
            GLog.w(Messages.get(this, "creatures", new Object[0]), new Object[0]);
            return;
        }
        if (this.returnDepth == Dungeon.depth) {
            if (!Dungeon.level.passable[this.returnPos] && !Dungeon.level.avoid[this.returnPos]) {
                this.returnPos = Dungeon.level.entrance;
            }
            ScrollOfTeleportation.appear(hero, this.returnPos);
            block1: for (Mob m : Dungeon.level.mobs) {
                if (m.pos != hero.pos) continue;
                for (int i : PathFinder.NEIGHBOURS8) {
                    if (Actor.findChar(m.pos + i) != null || !Dungeon.level.passable[m.pos + i]) continue;
                    m.pos += i;
                    m.sprite.point(m.sprite.worldToCamera(m.pos));
                    continue block1;
                }
            }
            Dungeon.level.occupyCell(hero);
            Dungeon.observe();
            GameScene.updateFog();
        } else {
            Swiftthistle.TimeBubble timeBubble;
            TimekeepersHourglass.timeFreeze timeFreeze2 = Dungeon.hero.buff(TimekeepersHourglass.timeFreeze.class);
            if (timeFreeze2 != null) {
                timeFreeze2.disarmPressedTraps();
            }
            if ((timeBubble = Dungeon.hero.buff(Swiftthistle.TimeBubble.class)) != null) {
                timeBubble.disarmPressedTraps();
            }
            InterlevelScene.mode = InterlevelScene.Mode.RETURN;
            InterlevelScene.returnDepth = this.returnDepth;
            InterlevelScene.returnPos = this.returnPos;
            Game.switchScene(InterlevelScene.class);
        }
        this.detach(hero.belongings.backpack);
    }

    @Override
    public String desc() {
        String desc = super.desc();
        if (this.returnDepth != -1) {
            desc = desc + "\n\n" + Messages.get(this, "desc_set", this.returnDepth);
        }
        return desc;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return this.returnDepth != -1 ? WHITE : null;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(DEPTH, this.returnDepth);
        if (this.returnDepth != -1) {
            bundle.put(POS, this.returnPos);
        }
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.returnDepth = bundle.getInt(DEPTH);
        this.returnPos = bundle.getInt(POS);
    }

    @Override
    public int value() {
        return Math.round((float)this.quantity * 18.0f);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ScrollOfPassage.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 6;
            this.output = BeaconOfReturning.class;
            this.outQuantity = 5;
        }
    }
}

