/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Degrade;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;

public class MagicalInfusion
extends InventorySpell {
    public MagicalInfusion() {
        this.image = ItemSpriteSheet.MAGIC_INFUSE;
        this.unique = true;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return item.isUpgradable();
    }

    @Override
    protected void onItemSelected(Item item) {
        ScrollOfUpgrade.upgrade(curUser);
        Degrade.detach(curUser, Degrade.class);
        if (item instanceof Weapon && ((Weapon)item).enchantment != null) {
            ((Weapon)item).upgrade(true);
        } else if (item instanceof Armor && ((Armor)item).glyph != null) {
            ((Armor)item).upgrade(true);
        } else {
            item.upgrade();
        }
        GLog.p(Messages.get(this, "infuse", item.name()), new Object[0]);
        Talent.onUpgradeScrollUsed(Dungeon.hero);
        Badges.validateItemLevelAquired(item);
        curUser.trackUpgrade(item, 1);
        ++Statistics.upgradesUsed;
    }

    @Override
    public int value() {
        return Math.round((float)this.quantity * 90.0f);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ScrollOfUpgrade.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 4;
            this.output = MagicalInfusion.class;
            this.outQuantity = 1;
        }
    }
}

