/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.TenguDartTrap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import java.util.ArrayList;

public class ForceCube
extends MissileWeapon {
    public ForceCube() {
        this.image = ItemSpriteSheet.FORCE_CUBE;
        this.tier = 5;
        this.baseUses = 5.0f;
        this.sticky = false;
    }

    @Override
    public void hitSound(float pitch) {
    }

    @Override
    protected void onThrow(int cell) {
        if (Dungeon.level.pit[cell]) {
            super.onThrow(cell);
            return;
        }
        this.rangedHit(null, cell);
        Dungeon.level.pressCell(cell);
        ArrayList<Char> targets = new ArrayList<Char>();
        if (Actor.findChar(cell) != null) {
            targets.add(Actor.findChar(cell));
        }
        for (int i : PathFinder.NEIGHBOURS8) {
            if (!(Dungeon.level.traps.get(cell + i) instanceof TenguDartTrap)) {
                Dungeon.level.pressCell(cell + i);
            }
            if (Actor.findChar(cell + i) == null) continue;
            targets.add(Actor.findChar(cell + i));
        }
        Object object = targets.iterator();
        while (object.hasNext()) {
            Char target = (Char)object.next();
            curUser.shoot(target, this);
            if (target != Dungeon.hero || target.isAlive()) continue;
            Dungeon.fail(this.getClass());
            GLog.n(Messages.get(this, "ondeath", new Object[0]), new Object[0]);
        }
        WandOfBlastWave.BlastWave.blast(cell);
        Sample.INSTANCE.play("sounds/blast.mp3");
    }
}

