/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard;

import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Blacksmith;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.BurningTrap;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class BlacksmithRoom
extends StandardRoom {
    @Override
    public int minWidth() {
        return Math.max(super.minWidth(), 6);
    }

    @Override
    public int minHeight() {
        return Math.max(super.minHeight(), 6);
    }

    @Override
    public void paint(Level level) {
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 18);
        Painter.fill(level, this, 2, 14);
        for (int i = 0; i < 2; ++i) {
            int pos;
            while (level.map[pos = level.pointToCell(this.random())] != 14) {
            }
            level.drop(Generator.random(Random.oneOf(Generator.Category.ARMOR, Generator.Category.WEAPON, Generator.Category.MISSILE)), pos);
        }
        for (Room.Door door : this.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
            Painter.drawInside(level, this, door, 1, 1);
        }
        Blacksmith npc = new Blacksmith();
        do {
            npc.pos = level.pointToCell(this.random(2));
        } while (level.heaps.get(npc.pos) != null);
        level.mobs.add(npc);
        for (Point p : this.getPoints()) {
            int cell = level.pointToCell(p);
            if (level.map[cell] != 18) continue;
            level.setTrap(new BurningTrap().reveal(), cell);
        }
    }
}

