/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.traps;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Statue;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;

public class DisarmingTrap
extends Trap {
    public DisarmingTrap() {
        this.color = 0;
        this.shape = 6;
    }

    @Override
    public void activate() {
        int cell;
        Heap heap = (Heap)Dungeon.level.heaps.get(this.pos);
        if (heap != null && (cell = Dungeon.level.randomRespawnCell(null)) != -1) {
            Item item = heap.pickUp();
            Heap dropped = Dungeon.level.drop(item, cell);
            dropped.type = heap.type;
            dropped.sprite.view(dropped);
            dropped.seen = true;
            for (int i : PathFinder.NEIGHBOURS9) {
                Dungeon.level.visited[cell + i] = true;
            }
            GameScene.updateFog();
            Sample.INSTANCE.play("sounds/teleport.mp3");
            CellEmitter.get(this.pos).burst(Speck.factory(2), 4);
        }
        if (Actor.findChar(this.pos) instanceof Statue) {
            Actor.findChar(this.pos).die(this);
            Sample.INSTANCE.play("sounds/teleport.mp3");
            CellEmitter.get(this.pos).burst(Speck.factory(2), 4);
        }
        if (Dungeon.hero.pos == this.pos && !Dungeon.hero.flying) {
            Hero hero = Dungeon.hero;
            KindOfWeapon weapon = hero.belongings.weapon;
            if (weapon != null && !weapon.cursed) {
                int cell2;
                int tries = 20;
                do {
                    cell2 = Dungeon.level.randomRespawnCell(null);
                    if (tries-- < 0 && cell2 != -1) break;
                    PathFinder.buildDistanceMap(this.pos, Dungeon.level.passable);
                } while (cell2 == -1 || PathFinder.distance[cell2] < 10 || PathFinder.distance[cell2] > 20);
                hero.belongings.weapon = null;
                Dungeon.quickslot.clearItem(weapon);
                weapon.updateQuickslot();
                Dungeon.level.drop((Item)weapon, (int)cell2).seen = true;
                for (int i : PathFinder.NEIGHBOURS9) {
                    Dungeon.level.mapped[cell2 + i] = true;
                }
                GameScene.updateFog(cell2, 1);
                GLog.w(Messages.get(this, "disarm", new Object[0]), new Object[0]);
                Sample.INSTANCE.play("sounds/teleport.mp3");
                CellEmitter.get(this.pos).burst(Speck.factory(2), 4);
            }
        }
    }
}

