/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SparkParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.AlchemistsToolkit;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.IconButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.ItemSlot;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndEnergizeItem;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoItem;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndJournal;
import com.watabou.gltextures.TextureCache;
import com.watabou.glwrap.Blending;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.NoosaScript;
import com.watabou.noosa.NoosaScriptNoLighting;
import com.watabou.noosa.SkinnedBlock;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.ui.Component;
import java.io.IOException;
import java.util.ArrayList;

public class AlchemyScene
extends PixelScene {
    private static final InputButton[] inputs = new InputButton[3];
    private static final CombineButton[] combines = new CombineButton[3];
    private static final OutputSlot[] outputs = new OutputSlot[3];
    private Emitter smokeEmitter;
    private Emitter bubbleEmitter;
    private Emitter sparkEmitter;
    private Emitter lowerBubbles;
    private SkinnedBlock water;
    private Image energyIcon;
    private RenderedTextBlock energyLeft;
    private IconButton energyAdd;
    private static final int BTN_SIZE = 28;
    protected WndBag.ItemSelector itemSelector;
    private static AlchemistsToolkit toolkit;

    public AlchemyScene() {
        this.inGameScene = true;
        this.itemSelector = new WndBag.ItemSelector(){

            @Override
            public String textPrompt() {
                return Messages.get(AlchemyScene.class, "select", new Object[0]);
            }

            @Override
            public boolean itemSelectable(Item item) {
                return Recipe.usableInRecipe(item);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSelect(Item item) {
                InputButton[] inputButtonArray = inputs;
                synchronized (inputButtonArray) {
                    if (item != null && inputs[0] != null) {
                        for (int i = 0; i < inputs.length; ++i) {
                            if (inputs[i].item() != null) continue;
                            if (item instanceof LiquidMetal) {
                                inputs[i].item(item.detachAll(Dungeon.hero.belongings.backpack));
                                break;
                            }
                            inputs[i].item(item.detach(Dungeon.hero.belongings.backpack));
                            break;
                        }
                        AlchemyScene.this.updateState();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() {
        super.create();
        this.water = new SkinnedBlock((float)Camera.main.width, (float)Camera.main.height, Dungeon.level.waterTex()){

            @Override
            protected NoosaScript script() {
                return NoosaScriptNoLighting.get();
            }

            @Override
            public void draw() {
                Blending.disable();
                super.draw();
                Blending.enable();
            }
        };
        this.water.autoAdjust = true;
        this.add(this.water);
        Image im = new Image(TextureCache.createGradient(0x66000000, -2013265920, -1442840576, -872415232, -16777216));
        im.angle = 90.0f;
        im.x = Camera.main.width;
        im.scale.x = (float)Camera.main.height / 5.0f;
        im.scale.y = Camera.main.width;
        this.add(im);
        this.bubbleEmitter = new Emitter();
        this.bubbleEmitter.pos(0.0f, 0.0f, Camera.main.width, Camera.main.height);
        this.bubbleEmitter.autoKill = false;
        this.add(this.bubbleEmitter);
        this.lowerBubbles = new Emitter();
        this.add(this.lowerBubbles);
        RenderedTextBlock title = PixelScene.renderTextBlock(Messages.get(this, "title", new Object[0]), 9);
        title.hardlight(0xFFFF44);
        title.setPos(((float)Camera.main.width - title.width()) / 2.0f, (20.0f - title.height()) / 2.0f);
        AlchemyScene.align(title);
        this.add(title);
        int w = 50 + Camera.main.width / 2;
        int left = (Camera.main.width - w) / 2;
        int pos = (Camera.main.height - 100) / 2;
        RenderedTextBlock desc = PixelScene.renderTextBlock(6);
        desc.maxWidth(w);
        desc.text(Messages.get(AlchemyScene.class, "text", new Object[0]));
        desc.setPos((float)left + ((float)w - desc.width()) / 2.0f, pos);
        this.add(desc);
        pos = (int)((float)pos + (desc.height() + 6.0f));
        NinePatch inputBG = Chrome.get(Chrome.Type.TOAST_TR);
        inputBG.x = left + 6;
        inputBG.y = pos;
        inputBG.size(36.0f, 96.0f);
        this.add(inputBG);
        pos += 4;
        InputButton[] inputButtonArray = inputs;
        synchronized (inputs) {
            for (int i = 0; i < inputs.length; ++i) {
                AlchemyScene.inputs[i] = new InputButton();
                inputs[i].setRect(left + 10, pos, 28.0f, 28.0f);
                this.add(inputs[i]);
                pos += 30;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            for (int i = 0; i < inputs.length; ++i) {
                AlchemyScene.combines[i] = new CombineButton(i);
                combines[i].enable(false);
                AlchemyScene.outputs[i] = new OutputSlot();
                outputs[i].item(null);
                if (i == 0) {
                    combines[i].setRect((float)left + (float)(w - 30) / 2.0f, inputs[1].top() + 5.0f, 30.0f, inputs[1].height() - 10.0f);
                    outputs[i].setRect(left + w - 28 - 10, inputs[1].top(), 28.0f, 28.0f);
                } else {
                    AlchemyScene.combines[i].visible = false;
                    AlchemyScene.outputs[i].visible = false;
                }
                this.add(combines[i]);
                this.add(outputs[i]);
            }
            this.smokeEmitter = new Emitter();
            this.smokeEmitter.pos(outputs[0].left() + 6.0f, outputs[0].top() + 6.0f, 16.0f, 16.0f);
            this.smokeEmitter.autoKill = false;
            this.add(this.smokeEmitter);
            this.lowerBubbles.pos(0.0f, pos += 10, Camera.main.width, Math.max(0, Camera.main.height - pos));
            this.lowerBubbles.pour(Speck.factory(12), 0.1f);
            ExitButton btnExit = new ExitButton(){

                @Override
                protected void onClick() {
                    Game.switchScene(GameScene.class);
                }
            };
            btnExit.setPos((float)Camera.main.width - btnExit.width(), 0.0f);
            this.add(btnExit);
            IconButton btnGuide = new IconButton(new ItemSprite(ItemSpriteSheet.ALCH_PAGE, null)){

                @Override
                protected void onClick() {
                    super.onClick();
                    AlchemyScene.this.clearSlots();
                    AlchemyScene.this.updateState();
                    AlchemyScene.this.addToFront(new Window(){
                        {
                            int h;
                            int w;
                            WndJournal.AlchemyTab t = new WndJournal.AlchemyTab();
                            if (PixelScene.landscape()) {
                                w = 200;
                                h = 130;
                            } else {
                                w = 126;
                                h = 180;
                            }
                            this.resize(w, h);
                            this.add(t);
                            t.setRect(0.0f, 0.0f, w, h);
                        }
                    });
                }

                @Override
                protected String hoverText() {
                    return Messages.titleCase(Document.ALCHEMY_GUIDE.title());
                }
            };
            btnGuide.setRect(0.0f, 0.0f, 20.0f, 20.0f);
            this.add(btnGuide);
            String energyText = Messages.get(AlchemyScene.class, "energy", new Object[0]) + " " + Dungeon.energy;
            if (toolkit != null) {
                energyText = energyText + "+" + toolkit.availableEnergy();
            }
            this.energyLeft = PixelScene.renderTextBlock(energyText, 9);
            this.energyLeft.setPos(((float)Camera.main.width - this.energyLeft.width()) / 2.0f, (float)(Camera.main.height - 8) - this.energyLeft.height());
            this.energyLeft.hardlight(0x44CCFF);
            this.add(this.energyLeft);
            this.energyIcon = new ItemSprite(toolkit != null ? ItemSpriteSheet.ARTIFACT_TOOLKIT : ItemSpriteSheet.ENERGY);
            this.energyIcon.x = this.energyLeft.left() - this.energyIcon.width();
            this.energyIcon.y = this.energyLeft.top() - (this.energyIcon.height() - this.energyLeft.height()) / 2.0f;
            AlchemyScene.align(this.energyIcon);
            this.add(this.energyIcon);
            this.energyAdd = new IconButton(Icons.get(Icons.PLUS)){

                @Override
                protected void onClick() {
                    WndEnergizeItem.openItemSelector();
                }
            };
            this.energyAdd.setRect(this.energyLeft.right(), this.energyLeft.top() - (16.0f - this.energyLeft.height()) / 2.0f, 16.0f, 16.0f);
            AlchemyScene.align(this.energyAdd);
            this.add(this.energyAdd);
            this.sparkEmitter = new Emitter();
            this.sparkEmitter.pos(this.energyLeft.left(), this.energyLeft.top(), this.energyLeft.width(), this.energyLeft.height());
            this.sparkEmitter.autoKill = false;
            this.add(this.sparkEmitter);
            this.fadeIn();
            try {
                Dungeon.saveAll();
                Badges.saveGlobal();
                Journal.saveGlobal();
            }
            catch (IOException e) {
                ShatteredPixelDungeon.reportException(e);
            }
            return;
        }
    }

    @Override
    public void update() {
        super.update();
        this.water.offset(0.0f, -5.0f * Game.elapsed);
    }

    @Override
    protected void onBackPressed() {
        Game.switchScene(GameScene.class);
    }

    private <T extends Item> ArrayList<T> filterInput(Class<? extends T> itemClass) {
        ArrayList<Item> filtered = new ArrayList<Item>();
        for (int i = 0; i < inputs.length; ++i) {
            Item item = inputs[i].item();
            if (item == null || !itemClass.isInstance(item)) continue;
            filtered.add(item);
        }
        return filtered;
    }

    private void updateState() {
        ArrayList<Item> ingredients = this.filterInput(Item.class);
        ArrayList<Recipe> recipes = Recipe.findRecipes(ingredients);
        for (int i = recipes.size(); i < combines.length; ++i) {
            combines[i].enable(false);
            outputs[i].item(null);
            if (i == 0) continue;
            AlchemyScene.combines[i].visible = false;
            AlchemyScene.outputs[i].visible = false;
        }
        if (recipes.isEmpty()) {
            combines[0].setPos(combines[0].left(), inputs[1].top() + 5.0f);
            outputs[0].setPos(outputs[0].left(), inputs[1].top());
            return;
        }
        float gap = recipes.size() == 2 ? 6.0f : 2.0f;
        float height = inputs[2].bottom() - inputs[0].top();
        float top = inputs[0].top() + (height -= (float)(recipes.size() * 28) + (float)(recipes.size() - 1) * gap) / 2.0f;
        for (int i = 0; i < recipes.size(); ++i) {
            Recipe recipe = recipes.get(i);
            int cost = recipe.cost(ingredients);
            AlchemyScene.outputs[i].visible = true;
            outputs[i].setRect(outputs[0].left(), top, 28.0f, 28.0f);
            outputs[i].item(recipe.sampleOutput(ingredients));
            top += 28.0f + gap;
            int availableEnergy = Dungeon.energy;
            if (toolkit != null) {
                availableEnergy += toolkit.availableEnergy();
            }
            AlchemyScene.combines[i].visible = true;
            combines[i].setRect(combines[0].left(), outputs[i].top() + 5.0f, 30.0f, 20.0f);
            combines[i].enable(cost <= availableEnergy, cost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void combine(int slot) {
        ArrayList<Item> ingredients = this.filterInput(Item.class);
        if (ingredients.isEmpty()) {
            return;
        }
        Recipe recipe = Recipe.findRecipes(ingredients).get(slot);
        Item result = null;
        if (recipe != null) {
            int cost = recipe.cost(ingredients);
            if (toolkit != null) {
                cost = toolkit.consumeEnergy(cost);
            }
            String energyText = Messages.get(AlchemyScene.class, "energy", new Object[0]) + " " + (Dungeon.energy -= cost);
            if (toolkit != null) {
                energyText = energyText + "+" + toolkit.availableEnergy();
            }
            this.energyLeft.text(energyText);
            this.energyLeft.setPos(((float)Camera.main.width - this.energyLeft.width()) / 2.0f, (float)(Camera.main.height - 8) - this.energyLeft.height());
            this.energyIcon.x = this.energyLeft.left() - this.energyIcon.width();
            AlchemyScene.align(this.energyIcon);
            this.energyAdd.setPos(this.energyLeft.right(), this.energyAdd.top());
            AlchemyScene.align(this.energyAdd);
            result = recipe.brew(ingredients);
        }
        if (result == null) return;
        this.bubbleEmitter.start(Speck.factory(12), 0.01f, 100);
        this.smokeEmitter.burst(Speck.factory(7), 10);
        Sample.INSTANCE.play("sounds/puff.mp3");
        int resultQuantity = result.quantity();
        if (!result.collect()) {
            Dungeon.level.drop(result, Dungeon.hero.pos);
        }
        ++Statistics.itemsCrafted;
        Badges.validateItemsCrafted();
        try {
            Dungeon.saveAll();
        }
        catch (IOException e) {
            ShatteredPixelDungeon.reportException(e);
        }
        InputButton[] inputButtonArray = inputs;
        synchronized (inputs) {
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] == null || inputs[i].item() == null) continue;
                Item item = inputs[i].item();
                if (item.quantity() <= 0) {
                    inputs[i].item(null);
                    continue;
                }
                AlchemyScene.inputs[i].slot.updateText();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.updateState();
            result.quantity(resultQuantity);
            outputs[0].item(result);
            if (result instanceof Potion && ingredients.size() == 3 && ingredients.get(0).getClass() == ingredients.get(1).getClass() && ingredients.get(0).getClass() == ingredients.get(2).getClass()) {
                Dungeon.hero.trackCraft("RandomPotion", 1);
                return;
            } else {
                Dungeon.hero.trackCraft(result, 1);
            }
            return;
        }
    }

    public void populate(ArrayList<Item> toFind, Belongings inventory) {
        this.clearSlots();
        int curslot = 0;
        for (Item finding : toFind) {
            Item detached;
            ArrayList<Item> found = inventory.getAllSimilar(finding);
            for (int needed = finding.quantity(); !found.isEmpty() && needed > 0; needed -= detached.quantity()) {
                detached = finding instanceof LiquidMetal ? found.get(0).detachAll(inventory.backpack) : found.get(0).detach(inventory.backpack);
                inputs[curslot].item(detached);
                ++curslot;
                if (detached != found.get(0)) continue;
                found.remove(0);
            }
        }
        this.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        InputButton[] inputButtonArray = inputs;
        synchronized (inputs) {
            this.clearSlots();
            for (int i = 0; i < inputs.length; ++i) {
                AlchemyScene.inputs[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                Dungeon.saveAll();
                Badges.saveGlobal();
                Journal.saveGlobal();
            }
            catch (IOException e) {
                ShatteredPixelDungeon.reportException(e);
            }
            super.destroy();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSlots() {
        InputButton[] inputButtonArray = inputs;
        synchronized (inputs) {
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] == null || inputs[i].item() == null) continue;
                Item item = inputs[i].item();
                if (!item.collect()) {
                    Dungeon.level.drop(item, Dungeon.hero.pos);
                }
                inputs[i].item(null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void createEnergy() {
        String energyText = Messages.get(AlchemyScene.class, "energy", new Object[0]) + " " + Dungeon.energy;
        if (toolkit != null) {
            energyText = energyText + "+" + toolkit.availableEnergy();
        }
        this.energyLeft.text(energyText);
        this.energyLeft.setPos(((float)Camera.main.width - this.energyLeft.width()) / 2.0f, (float)(Camera.main.height - 8) - this.energyLeft.height());
        this.energyIcon.x = this.energyLeft.left() - this.energyIcon.width();
        AlchemyScene.align(this.energyIcon);
        this.energyAdd.setPos(this.energyLeft.right(), this.energyAdd.top());
        AlchemyScene.align(this.energyAdd);
        this.bubbleEmitter.start(Speck.factory(12), 0.01f, 100);
        this.sparkEmitter.burst(SparkParticle.FACTORY, 20);
        Sample.INSTANCE.play("sounds/lightning.mp3");
        this.updateState();
    }

    public static void assignToolkit(AlchemistsToolkit toolkit) {
        AlchemyScene.toolkit = toolkit;
    }

    public static void clearToolkit() {
        toolkit = null;
    }

    private class OutputSlot
    extends Component {
        protected NinePatch bg;
        protected ItemSlot slot;

        private OutputSlot() {
        }

        @Override
        protected void createChildren() {
            this.bg = Chrome.get(Chrome.Type.TOAST_TR);
            this.add(this.bg);
            this.slot = new ItemSlot(){

                @Override
                protected void onClick() {
                    super.onClick();
                    if (this.visible && this.item != null && this.item.trueName() != null) {
                        AlchemyScene.this.addToFront(new WndInfoItem(this.item));
                    }
                }
            };
            this.slot.item(null);
            this.add(this.slot);
        }

        @Override
        protected void layout() {
            super.layout();
            this.bg.x = this.x;
            this.bg.y = this.y;
            this.bg.size(this.width(), this.height());
            this.slot.setRect(this.x + 2.0f, this.y + 2.0f, this.width() - 4.0f, this.height() - 4.0f);
        }

        public void item(Item item) {
            this.slot.item(item);
        }
    }

    private class CombineButton
    extends Component {
        protected int slot;
        protected RedButton button;
        protected RenderedTextBlock costText;

        private CombineButton(int slot) {
            this.slot = slot;
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.button = new RedButton(""){

                @Override
                protected void onClick() {
                    super.onClick();
                    AlchemyScene.this.combine(CombineButton.this.slot);
                }
            };
            this.button.icon(Icons.get(Icons.ARROW));
            this.add(this.button);
            this.costText = PixelScene.renderTextBlock(6);
            this.add(this.costText);
        }

        @Override
        protected void layout() {
            super.layout();
            this.button.setRect(this.x, this.y, this.width(), this.height());
            this.costText.setPos(this.left() + (this.width() - this.costText.width()) / 2.0f, this.top() - this.costText.height());
        }

        public void enable(boolean enabled) {
            this.enable(enabled, 0);
        }

        public void enable(boolean enabled, int cost) {
            this.button.enable(enabled);
            if (enabled) {
                this.button.icon().tint(1.0f, 1.0f, 0.0f, 1.0f);
                this.button.alpha(1.0f);
                this.costText.hardlight(0x44CCFF);
            } else {
                this.button.icon().color(0.0f, 0.0f, 0.0f);
                this.button.alpha(0.6f);
                this.costText.hardlight(0xFF0000);
            }
            if (cost == 0) {
                this.costText.visible = false;
            } else {
                this.costText.visible = true;
                this.costText.text(Messages.get(AlchemyScene.class, "energy", new Object[0]) + " " + cost);
            }
            this.layout();
        }
    }

    private class InputButton
    extends Component {
        protected NinePatch bg;
        protected ItemSlot slot;
        private Item item = null;

        private InputButton() {
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.bg = Chrome.get(Chrome.Type.RED_BUTTON);
            this.add(this.bg);
            this.slot = new ItemSlot(){

                @Override
                protected void onPointerDown() {
                    InputButton.this.bg.brightness(1.2f);
                    Sample.INSTANCE.play("sounds/click.mp3");
                }

                @Override
                protected void onPointerUp() {
                    InputButton.this.bg.resetColor();
                }

                @Override
                protected void onClick() {
                    super.onClick();
                    Item item = InputButton.this.item;
                    if (item != null) {
                        if (!item.collect()) {
                            Dungeon.level.drop(item, Dungeon.hero.pos);
                        }
                        InputButton.this.item(null);
                        AlchemyScene.this.updateState();
                    }
                    AlchemyScene.this.addToFront(WndBag.getBag(AlchemyScene.this.itemSelector));
                }

                @Override
                protected boolean onLongClick() {
                    Item item = InputButton.this.item;
                    if (item != null) {
                        AlchemyScene.this.addToFront(new WndInfoItem(item));
                        return true;
                    }
                    return false;
                }
            };
            this.slot.enable(true);
            this.add(this.slot);
        }

        @Override
        protected void layout() {
            super.layout();
            this.bg.x = this.x;
            this.bg.y = this.y;
            this.bg.size(this.width, this.height);
            this.slot.setRect(this.x + 2.0f, this.y + 2.0f, this.width - 4.0f, this.height - 4.0f);
        }

        public Item item() {
            return this.item;
        }

        public void item(Item item) {
            if (item == null) {
                this.item = null;
                this.slot.item(new WndBag.Placeholder(ItemSpriteSheet.SOMETHING));
            } else {
                this.item = item;
                this.slot.item(this.item);
            }
        }
    }
}

