/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.effects.Flare;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Amulet;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.RankingsScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.utils.Random;

public class AmuletScene
extends PixelScene {
    private static final int WIDTH = 120;
    private static final int BTN_HEIGHT = 18;
    private static final float SMALL_GAP = 2.0f;
    private static final float LARGE_GAP = 8.0f;
    public static boolean noText = false;
    private Image amulet;
    private float timer;

    public AmuletScene() {
        this.inGameScene = true;
        this.timer = 0.0f;
    }

    @Override
    public void create() {
        super.create();
        RenderedTextBlock text = null;
        if (!noText) {
            text = AmuletScene.renderTextBlock(Messages.get(this, "text", new Object[0]), 8);
            text.maxWidth(120);
            this.add(text);
        }
        this.amulet = new Image("sprites/amulet.png");
        this.add(this.amulet);
        RedButton btnExit = new RedButton(Messages.get(this, "exit", new Object[0])){

            @Override
            protected void onClick() {
                Dungeon.win(Amulet.class);
                Dungeon.deleteGame(GamesInProgress.curSlot, true);
                Game.switchScene(RankingsScene.class);
            }
        };
        btnExit.setSize(120.0f, 18.0f);
        this.add(btnExit);
        RedButton btnStay = new RedButton(Messages.get(this, "stay", new Object[0])){

            @Override
            protected void onClick() {
                AmuletScene.this.onBackPressed();
            }
        };
        btnStay.setSize(120.0f, 18.0f);
        this.add(btnStay);
        if (noText) {
            float height = this.amulet.height + 8.0f + btnExit.height() + 2.0f + btnStay.height();
            this.amulet.x = ((float)Camera.main.width - this.amulet.width) / 2.0f;
            this.amulet.y = ((float)Camera.main.height - height) / 2.0f;
            AmuletScene.align(this.amulet);
            btnExit.setPos(((float)Camera.main.width - btnExit.width()) / 2.0f, this.amulet.y + this.amulet.height + 8.0f);
            btnStay.setPos(btnExit.left(), btnExit.bottom() + 2.0f);
        } else {
            float height = this.amulet.height + 8.0f + text.height() + 8.0f + btnExit.height() + 2.0f + btnStay.height();
            this.amulet.x = ((float)Camera.main.width - this.amulet.width) / 2.0f;
            this.amulet.y = ((float)Camera.main.height - height) / 2.0f;
            AmuletScene.align(this.amulet);
            text.setPos(((float)Camera.main.width - text.width()) / 2.0f, this.amulet.y + this.amulet.height + 8.0f);
            AmuletScene.align(text);
            btnExit.setPos(((float)Camera.main.width - btnExit.width()) / 2.0f, text.top() + text.height() + 8.0f);
            btnStay.setPos(btnExit.left(), btnExit.bottom() + 2.0f);
        }
        new Flare((int)8, (float)48.0f).color((int)0xFFDDBB, (boolean)true).show((Visual)this.amulet, (float)0.0f).angularSpeed = 30.0f;
        this.fadeIn();
    }

    @Override
    protected void onBackPressed() {
        InterlevelScene.mode = InterlevelScene.Mode.CONTINUE;
        Game.switchScene(InterlevelScene.class);
    }

    @Override
    public void update() {
        float f;
        super.update();
        this.timer -= Game.elapsed;
        if (f < 0.0f) {
            this.timer = Random.Float(0.5f, 5.0f);
            Speck star = (Speck)this.recycle(Speck.class);
            star.reset(0, this.amulet.x + 10.5f, this.amulet.y + 5.5f, 101);
            this.add(star);
        }
    }
}

