/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.RankingsScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.Archs;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.IconButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.watabou.noosa.Camera;
import com.watabou.noosa.audio.Music;
import com.watabou.utils.GameMath;

public class HallOfHeroesScene
extends PixelScene {
    private static final float ROW_HEIGHT_MAX = 20.0f;
    private static final float ROW_HEIGHT_MIN = 12.0f;
    private static final float MAX_ROW_WIDTH = 160.0f;
    private static final float GAP = 4.0f;
    private Archs archs;
    public static int page = 0;
    private static final int MAX_PAGES = 4;
    public static boolean inHOH = false;

    @Override
    public void create() {
        super.create();
        inHOH = true;
        Music.INSTANCE.playTracks(new String[]{"music/theme_1.ogg", "music/theme_2.ogg"}, new float[]{1.0f, 1.0f}, false);
        HallOfHeroesScene.uiCamera.visible = false;
        int w = Camera.main.width;
        int h = Camera.main.height;
        this.archs = new Archs();
        this.archs.setSize(w, h);
        this.add(this.archs);
        Rankings.INSTANCE.loadHall();
        RenderedTextBlock title = PixelScene.renderTextBlock(Messages.get(this, "title", new Object[0]), 9);
        title.hardlight(0x3399FF);
        title.setPos(((float)w - title.width()) / 2.0f, (20.0f - title.height()) / 2.0f);
        this.add(title);
        if (!Rankings.INSTANCE.hallRecords.get(page).isEmpty()) {
            float rowHeight = GameMath.gate(12.0f, (HallOfHeroesScene.uiCamera.height - 26) / Rankings.INSTANCE.hallRecords.get(page).size(), 20.0f);
            float left = ((float)w - Math.min(160.0f, (float)w)) / 2.0f + 4.0f;
            float top = ((float)h - rowHeight * (float)Rankings.INSTANCE.hallRecords.get(page).size()) / 2.0f;
            int pos = 0;
            for (Rankings.Record rec : Rankings.INSTANCE.hallRecords.get(page)) {
                HallRecord row = new HallRecord(pos, rec);
                float offset = 0.0f;
                if (rowHeight <= 14.0f) {
                    offset = pos % 2 == 1 ? 5.0f : -5.0f;
                }
                row.setRect(left + offset, top + (float)pos * rowHeight, (float)w - left * 2.0f, rowHeight);
                this.add(row);
                ++pos;
            }
        } else {
            RenderedTextBlock noRec = PixelScene.renderTextBlock(Messages.get(this, "no_games", new Object[0]), 8);
            noRec.hardlight(0x3399FF);
            noRec.setPos(((float)w - noRec.width()) / 2.0f, ((float)h - noRec.height()) / 2.0f);
            HallOfHeroesScene.align(noRec);
            this.add(noRec);
        }
        ExitButton btnExit = new ExitButton(){

            @Override
            protected void onClick() {
                inHOH = false;
                ShatteredPixelDungeon.switchScene(RankingsScene.class);
            }
        };
        btnExit.setPos((float)Camera.main.width - btnExit.width(), 0.0f);
        this.add(btnExit);
        RenderedTextBlock pageDisp = PixelScene.renderTextBlock(Messages.get(this, "page", page + 1, 4), 8);
        pageDisp.hardlight(0x3399FF);
        pageDisp.setPos(((float)w - pageDisp.width()) / 2.0f, (float)h - pageDisp.height() - 8.0f);
        HallOfHeroesScene.align(pageDisp);
        this.add(pageDisp);
        int BTN_SIZE = 20;
        IconButton btnNext = new IconButton(Icons.RIGHTARROW.get()){

            @Override
            protected void onClick() {
                if (++page >= 4) {
                    page = 0;
                }
                ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
            }
        };
        btnNext.setRect((float)w - 8.0f - (float)BTN_SIZE, h - 1 - BTN_SIZE, BTN_SIZE, BTN_SIZE);
        this.add(btnNext);
        IconButton btnPrev = new IconButton(Icons.LEFTARROW.get()){

            @Override
            protected void onClick() {
                if (--page < 0) {
                    page = 3;
                }
                ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
            }
        };
        btnPrev.setRect(8.0f, h - 1 - BTN_SIZE, BTN_SIZE, BTN_SIZE);
        this.add(btnPrev);
        this.fadeIn();
    }

    @Override
    protected void onBackPressed() {
        inHOH = false;
        Sync.syncHallOfHeroes();
        ShatteredPixelDungeon.switchScene(TitleScene.class);
    }

    @Override
    public void onPause() {
        Sync.syncHallOfHeroes();
    }

    public class HallRecord
    extends RankingsScene.Record {
        public HallRecord(int pos, Rankings.Record rec) {
            super(pos, false, rec);
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.shield.view(ItemSpriteSheet.GRAVE, null);
        }
    }
}

