/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.IntroScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.IconButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenameButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.StyledButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndChallenges;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndHeroInfo;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndKeyBindings;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndMessage;
import com.watabou.gltextures.TextureCache;
import com.watabou.input.PointerEvent;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.PointerArea;
import com.watabou.utils.DeviceCompat;
import com.watabou.utils.GameMath;
import java.util.ArrayList;

public class HeroSelectScene
extends PixelScene {
    private Image background;
    private RenderedTextBlock prompt;
    private ArrayList<StyledButton> heroBtns = new ArrayList();
    private StyledButton startBtn;
    private IconButton infoButton;
    private IconButton renameButton;
    private IconButton challengeButton;
    private IconButton btnExit;
    private float uiAlpha;

    @Override
    public void create() {
        super.create();
        Dungeon.hero = null;
        Badges.loadGlobal();
        Journal.loadGlobal();
        this.background = new Image(HeroClass.WARRIOR.splashArt()){

            @Override
            public void update() {
                if (this.rm > 1.0f) {
                    this.rm -= Game.elapsed;
                    this.gm = this.bm = this.rm;
                } else {
                    this.bm = 1.0f;
                    this.gm = 1.0f;
                    this.rm = 1.0f;
                }
            }
        };
        this.background.scale.set((float)Camera.main.height / this.background.height);
        this.background.x = ((float)Camera.main.width - this.background.width()) / 2.0f;
        this.background.y = ((float)Camera.main.height - this.background.height()) / 2.0f;
        this.background.visible = false;
        PixelScene.align(this.background);
        this.add(this.background);
        if (this.background.x > 0.0f) {
            Image fadeLeft = new Image(TextureCache.createGradient(-16777216, 0));
            fadeLeft.x = this.background.x - 2.0f;
            fadeLeft.scale.set(4.0f, this.background.height());
            this.add(fadeLeft);
            Image fadeRight = new Image(fadeLeft);
            fadeRight.x = this.background.x + this.background.width() + 2.0f;
            fadeRight.y = this.background.y + this.background.height();
            fadeRight.angle = 180.0f;
            this.add(fadeRight);
        }
        this.startBtn = new StyledButton(Chrome.Type.GREY_BUTTON_TR, ""){

            @Override
            protected void onClick() {
                super.onClick();
                if (GamesInProgress.selectedClass == null) {
                    return;
                }
                Dungeon.hero = null;
                ActionIndicator.action = null;
                InterlevelScene.mode = InterlevelScene.Mode.DESCEND;
                if (SPDSettings.intro()) {
                    SPDSettings.intro(false);
                    Game.switchScene(IntroScene.class);
                } else {
                    Game.switchScene(InterlevelScene.class);
                }
            }
        };
        this.startBtn.icon(Icons.get(Icons.ENTER));
        this.startBtn.setSize(80.0f, 21.0f);
        this.startBtn.setPos(((float)Camera.main.width - this.startBtn.width()) / 2.0f, (float)(Camera.main.height - 24 + 2) - this.startBtn.height());
        this.add(this.startBtn);
        this.startBtn.visible = false;
        this.infoButton = new IconButton(Icons.get(Icons.INFO)){

            @Override
            protected void onClick() {
                super.onClick();
                ShatteredPixelDungeon.scene().addToFront(new WndHeroInfo(GamesInProgress.selectedClass));
            }

            @Override
            protected String hoverText() {
                return Messages.titleCase(Messages.get(WndKeyBindings.class, "hero_info", new Object[0]));
            }
        };
        this.infoButton.visible = false;
        this.infoButton.setSize(21.0f, 21.0f);
        this.add(this.infoButton);
        this.renameButton = new RenameButton();
        this.renameButton.visible = false;
        this.renameButton.setSize(21.0f, 21.0f);
        this.add(this.renameButton);
        HeroClass[] classes = HeroClass.values();
        int btnWidth = 20;
        int curX = (Camera.main.width - btnWidth * classes.length) / 2;
        if (curX > 0) {
            btnWidth += Math.min(curX / (classes.length / 2), 15);
            curX = (Camera.main.width - btnWidth * classes.length) / 2;
        }
        int heroBtnleft = curX;
        for (HeroClass cl : classes) {
            HeroBtn button = new HeroBtn(cl);
            button.setRect(curX, Camera.main.height - 24 + 3, btnWidth, 24.0f);
            curX += btnWidth;
            this.add(button);
            this.heroBtns.add(button);
        }
        this.challengeButton = new IconButton(Icons.get(SPDSettings.challenges() > 0 ? Icons.CHALLENGE_ON : Icons.CHALLENGE_OFF)){

            @Override
            protected void onClick() {
                ShatteredPixelDungeon.scene().addToFront(new WndChallenges(SPDSettings.challenges(), true){

                    @Override
                    public void onBackPressed() {
                        super.onBackPressed();
                        this.icon(Icons.get(SPDSettings.challenges() > 0 ? Icons.CHALLENGE_ON : Icons.CHALLENGE_OFF));
                    }
                });
            }

            @Override
            public void update() {
                if (!this.visible && GamesInProgress.selectedClass != null) {
                    this.visible = true;
                }
                super.update();
            }

            @Override
            protected String hoverText() {
                return Messages.titleCase(Messages.get(WndChallenges.class, "title", new Object[0]));
            }
        };
        this.challengeButton.setRect(heroBtnleft + 16, Camera.main.height - 24 - 16, 21.0f, 21.0f);
        this.challengeButton.visible = false;
        if (DeviceCompat.isDebug() || Badges.isUnlocked(Badges.Badge.VICTORY)) {
            this.add(this.challengeButton);
        } else {
            Dungeon.challenges = 0;
            SPDSettings.challenges(0);
        }
        this.btnExit = new ExitButton();
        this.btnExit.setPos((float)Camera.main.width - this.btnExit.width(), 0.0f);
        this.add(this.btnExit);
        this.btnExit.visible = !SPDSettings.intro() || Rankings.INSTANCE.totalNumber > 0;
        this.prompt = PixelScene.renderTextBlock(Messages.get(this, "title", new Object[0]), 12);
        this.prompt.hardlight(0xFFFF44);
        this.prompt.setPos(((float)Camera.main.width - this.prompt.width()) / 2.0f, (float)(Camera.main.height - 24) - this.prompt.height() - 4.0f);
        PixelScene.align(this.prompt);
        this.add(this.prompt);
        PointerArea fadeResetter = new PointerArea(0.0f, 0.0f, Camera.main.width, Camera.main.height){

            @Override
            public boolean onSignal(PointerEvent event) {
                HeroSelectScene.this.resetFade();
                return false;
            }
        };
        this.add(fadeResetter);
        this.resetFade();
        if (GamesInProgress.selectedClass != null) {
            this.setSelectedHero(GamesInProgress.selectedClass);
        }
        this.fadeIn();
    }

    private void setSelectedHero(HeroClass cl) {
        GamesInProgress.selectedClass = cl;
        this.background.texture(cl.splashArt());
        this.background.visible = true;
        this.background.hardlight(1.5f, 1.5f, 1.5f);
        this.prompt.visible = false;
        this.startBtn.visible = true;
        this.startBtn.text(Messages.titleCase(cl.title()));
        this.startBtn.textColor(0xFFFF44);
        this.startBtn.setSize(this.startBtn.reqWidth() + 8.0f, 21.0f);
        this.startBtn.setPos(((float)Camera.main.width - this.startBtn.width()) / 2.0f, this.startBtn.top());
        PixelScene.align(this.startBtn);
        this.infoButton.visible = true;
        this.infoButton.setPos(this.startBtn.right(), this.startBtn.top());
        this.renameButton.visible = Payment.isTierUnlocked(1);
        this.renameButton.setPos(((float)Camera.main.width - this.renameButton.width()) / 2.0f, this.startBtn.top() - this.renameButton.height());
        PixelScene.align(this.renameButton);
        this.challengeButton.visible = true;
        this.challengeButton.setPos(this.startBtn.left() - this.challengeButton.width(), this.startBtn.top());
    }

    @Override
    public void update() {
        super.update();
        this.btnExit.visible = !SPDSettings.intro() || Rankings.INSTANCE.totalNumber > 0;
        for (Object v : this.members) {
            if (!(v instanceof Window)) continue;
            this.resetFade();
        }
        if (GamesInProgress.selectedClass != null) {
            if (this.uiAlpha > 0.0f) {
                this.uiAlpha -= Game.elapsed / 4.0f;
            }
            float alpha = GameMath.gate(0.0f, this.uiAlpha, 1.0f);
            for (StyledButton b : this.heroBtns) {
                b.alpha(alpha);
            }
            this.startBtn.alpha(alpha);
            this.btnExit.icon().alpha(alpha);
            this.challengeButton.icon().alpha(alpha);
            this.infoButton.icon().alpha(alpha);
            this.renameButton.icon().alpha(alpha);
        }
    }

    private void resetFade() {
        this.uiAlpha = 2.0f;
    }

    @Override
    protected void onBackPressed() {
        if (this.btnExit.visible) {
            ShatteredPixelDungeon.switchScene(TitleScene.class);
        } else {
            super.onBackPressed();
        }
    }

    private class HeroBtn
    extends StyledButton {
        private HeroClass cl;
        private static final int MIN_WIDTH = 20;
        private static final int HEIGHT = 24;

        HeroBtn(HeroClass cl) {
            super(Chrome.Type.GREY_BUTTON_TR, "");
            this.cl = cl;
            this.icon(new Image(cl.spritesheet(), 0, 90, 12, 15));
        }

        @Override
        public void update() {
            super.update();
            if (this.cl != GamesInProgress.selectedClass) {
                if (!this.cl.isUnlocked()) {
                    this.icon.brightness(0.1f);
                } else {
                    this.icon.brightness(0.6f);
                }
            } else {
                this.icon.brightness(1.0f);
            }
        }

        @Override
        protected void onClick() {
            super.onClick();
            if (!this.cl.isUnlocked()) {
                ShatteredPixelDungeon.scene().addToFront(new WndMessage(this.cl.unlockMsg()));
            } else if (GamesInProgress.selectedClass == this.cl) {
                ShatteredPixelDungeon.scene().add(new WndHeroInfo(this.cl));
            } else {
                HeroSelectScene.this.setSelectedHero(this.cl);
            }
        }
    }
}

