/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.BannerSprites;
import com.shatteredpixel.shatteredpixeldungeon.effects.Fireball;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.ChangesScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.HeroSelectScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.shatteredpixel.shatteredpixeldungeon.ui.Archs;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.StyledButton;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndError;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndHardNotification;
import com.watabou.glwrap.Blending;
import com.watabou.noosa.Camera;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Music;
import com.watabou.utils.FileUtils;
import java.util.ArrayList;

public class WelcomeScene
extends PixelScene {
    private static final int LATEST_UPDATE = 600;

    @Override
    public void create() {
        super.create();
        final int previousVersion = SPDSettings.version();
        if (FileUtils.cleanTempFiles()) {
            this.add(new WndHardNotification(Icons.get(Icons.WARNING), Messages.get(WndError.class, "title", new Object[0]), Messages.get(this, "save_warning", new Object[0]), Messages.get(this, "continue", new Object[0]), 5){

                @Override
                public void hide() {
                    super.hide();
                    ShatteredPixelDungeon.resetScene();
                }
            });
            return;
        }
        if (ShatteredPixelDungeon.versionCode == previousVersion && !SPDSettings.intro()) {
            ShatteredPixelDungeon.switchNoFade(TitleScene.class);
            return;
        }
        Music.INSTANCE.playTracks(new String[]{"music/theme_1.ogg", "music/theme_2.ogg"}, new float[]{1.0f, 1.0f}, false);
        WelcomeScene.uiCamera.visible = false;
        int w = Camera.main.width;
        int h = Camera.main.height;
        Archs archs = new Archs();
        archs.setSize(w, h);
        this.add(archs);
        this.add(new ColorBlock(w, h, -2013265920));
        Image title = BannerSprites.get(BannerSprites.Type.PIXEL_DUNGEON);
        this.add(title);
        float topRegion = Math.max(title.height - 6.0f, (float)h * 0.45f);
        title.x = ((float)w - title.width()) / 2.0f;
        title.y = 2.0f + (topRegion - title.height()) / 2.0f;
        WelcomeScene.align(title);
        this.placeTorch(title.x + 22.0f, title.y + 46.0f);
        this.placeTorch(title.x + title.width - 22.0f, title.y + 46.0f);
        Image signs = new Image(BannerSprites.get(BannerSprites.Type.PIXEL_DUNGEON_SIGNS)){
            private float time;
            {
                this.time = 0.0f;
            }

            @Override
            public void update() {
                super.update();
                this.am = Math.max(0.0f, (float)Math.sin(this.time += Game.elapsed));
                if ((double)this.time >= 4.71238898038469) {
                    this.time = 0.0f;
                }
            }

            @Override
            public void draw() {
                Blending.setLightMode();
                super.draw();
                Blending.setNormalMode();
            }
        };
        signs.x = title.x + (title.width() - signs.width()) / 2.0f;
        signs.y = title.y;
        this.add(signs);
        StyledButton okay = new StyledButton(Chrome.Type.GREY_BUTTON_TR, Messages.get(this, "continue", new Object[0])){

            @Override
            protected void onClick() {
                super.onClick();
                if (previousVersion == 0 || SPDSettings.intro()) {
                    SPDSettings.version(ShatteredPixelDungeon.versionCode);
                    GamesInProgress.selectedClass = null;
                    GamesInProgress.curSlot = 1;
                    ShatteredPixelDungeon.switchScene(HeroSelectScene.class);
                } else {
                    WelcomeScene.this.updateVersion(previousVersion);
                    ShatteredPixelDungeon.switchScene(TitleScene.class);
                }
            }
        };
        float buttonY = Math.min(topRegion + (float)(PixelScene.landscape() ? 60 : 120), (float)(h - 24));
        if (previousVersion != 0 && !SPDSettings.intro()) {
            StyledButton changes = new StyledButton(Chrome.Type.GREY_BUTTON_TR, Messages.get(TitleScene.class, "changes", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    WelcomeScene.this.updateVersion(previousVersion);
                    ShatteredPixelDungeon.switchScene(ChangesScene.class);
                }
            };
            okay.setRect(title.x, buttonY, title.width() / 2.0f - 2.0f, 20.0f);
            this.add(okay);
            changes.setRect(okay.right() + 2.0f, buttonY, title.width() / 2.0f - 2.0f, 20.0f);
            changes.icon(Icons.get(Icons.CHANGES));
            this.add(changes);
        } else {
            okay.text(Messages.get(TitleScene.class, "enter", new Object[0]));
            okay.setRect(title.x, buttonY, title.width(), 20.0f);
            okay.icon(Icons.get(Icons.ENTER));
            this.add(okay);
            Sync.connectSignInOnly();
        }
        RenderedTextBlock text = PixelScene.renderTextBlock(6);
        String message = "Welcome to Shattered Pixel Dungeon's pre-release demo on Steam! This demo contains the first 10 dungeon floors and showcases the interface improvements I've made for desktop computers.\n\nYou can select 'demo info' from the main menu or game menu for more information and to give feedback. All demo save data will transfer to the full game.";
        message = previousVersion == 0 || SPDSettings.intro() ? message + "\n\nShattered is a traditional roguelike that I've been developing over the last 8 years. Each run through the dungeon is a new challenging experience, and be careful, death is permanent! Getting started is simple, but strategy is required if you want to win! Happy Dungeoneering!" : message + "\n\nYou can press the changes button below to see the most recent adjustments that I've made.";
        text.text(message, Math.min(w - 20, 300));
        float textSpace = okay.top() - topRegion - 4.0f;
        text.setPos(((float)w - text.width()) / 2.0f, topRegion + 2.0f + (textSpace - text.height()) / 2.0f);
        this.add(text);
    }

    private void placeTorch(float x, float y) {
        Fireball fb = new Fireball();
        fb.setPos(x, y);
        this.add(fb);
    }

    private void updateVersion(int previousVersion) {
        if (previousVersion < 600) {
            try {
                Rankings.INSTANCE.load();
                for (Rankings.Record rec : Rankings.INSTANCE.records.toArray(new Rankings.Record[0])) {
                    try {
                        Rankings.INSTANCE.loadGameData(rec);
                        Rankings.INSTANCE.saveGameData(rec);
                    }
                    catch (Exception e) {
                        Rankings.INSTANCE.records.remove(rec);
                        ShatteredPixelDungeon.reportException(e);
                    }
                }
                Rankings.INSTANCE.save();
            }
            catch (Exception e) {
                FileUtils.deleteFile("rankings.dat");
                ShatteredPixelDungeon.reportException(e);
            }
            try {
                Rankings.INSTANCE.loadHall();
                for (ArrayList<Rankings.Record> page : Rankings.INSTANCE.hallRecords) {
                    for (Rankings.Record rec : page.toArray(new Rankings.Record[0])) {
                        try {
                            Rankings.INSTANCE.loadGameData(rec);
                            Rankings.INSTANCE.saveGameData(rec);
                        }
                        catch (Exception e) {
                            Rankings.INSTANCE.records.remove(rec);
                            ShatteredPixelDungeon.reportException(e);
                        }
                    }
                }
                Rankings.INSTANCE.saveHall();
            }
            catch (Exception e) {
                FileUtils.deleteFile("hall.dat");
                ShatteredPixelDungeon.reportException(e);
            }
        }
        if (previousVersion <= 557) {
            Badges.loadGlobal();
            if (Badges.isUnlocked(Badges.Badge.BOSS_SLAIN_1)) {
                for (String page : Document.ADVENTURERS_GUIDE.pageNames()) {
                    Document.ADVENTURERS_GUIDE.readPage(page);
                }
            }
        }
        SPDSettings.version(ShatteredPixelDungeon.versionCode);
    }
}

