/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.services.sync;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.scenes.BadgesScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.HallOfHeroesScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.RankingsScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.SyncService;
import com.watabou.noosa.Game;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Sync {
    public static SyncService service;

    public static boolean supportsSync() {
        return service != null;
    }

    public static void connectSilentOnly() {
        Sync.connect(SyncService.ConnectionStyle.SILENT);
    }

    public static void connectSignInOnly() {
        Sync.connect(SyncService.ConnectionStyle.PROMPT_SIGNIN);
    }

    public static void connect() {
        Sync.connect(SyncService.ConnectionStyle.PROMPT_ALL);
    }

    private static void connect(final SyncService.ConnectionStyle style) {
        if (!Sync.supportsSync() || Sync.isConnected()) {
            return;
        }
        service.connect(style, new SyncService.ConnectionResultCallback(){

            @Override
            public void onSuccess() {
                SPDSettings.googlePlayGames(true);
                Sync.syncBadges();
                Sync.syncJournal();
                Sync.syncRankings();
                if (Payment.isTierUnlocked(2)) {
                    Sync.syncHallOfHeroes();
                }
                if (style == SyncService.ConnectionStyle.PROMPT_ALL) {
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }

            @Override
            public void onFail() {
                if (style == SyncService.ConnectionStyle.PROMPT_ALL) {
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        });
    }

    public static void handleConnectionResult(int resultCode, Object data) {
        if (!Sync.supportsSync()) {
            return;
        }
        service.handleConnectionResult(resultCode, data);
    }

    public static void disconnect() {
        if (!Sync.supportsSync()) {
            return;
        }
        SPDSettings.googlePlayGames(false);
        service.disconnect();
    }

    public static boolean isConnected() {
        return Sync.supportsSync() && service.isConnected();
    }

    public static boolean alwaysConnected() {
        return Sync.supportsSync() && service.alwaysConnected();
    }

    public static void syncBadges() {
        Badges.loadGlobal();
        if (!Sync.supportsSync()) {
            return;
        }
        if (!Sync.isConnected()) {
            if (SPDSettings.googlePlayGames()) {
                Sync.connectSilentOnly();
            }
            return;
        }
        service.syncBadges(new SyncService.ReceiveDataCallback(){

            @Override
            public void receiveData(byte[] data, SyncService.SendDataCallback sender) {
                int cloudVersionCode;
                HashSet<Object> cloudBadges;
                Bundle cloudBundle = null;
                try {
                    if (data.length > 0) {
                        cloudBundle = Bundle.read(new ByteArrayInputStream(data));
                        cloudBadges = Badges.restore(cloudBundle);
                        cloudVersionCode = cloudBundle.getInt("version");
                    } else {
                        cloudBadges = new HashSet();
                        cloudVersionCode = 0;
                    }
                }
                catch (Exception e) {
                    ShatteredPixelDungeon.reportException(e);
                    cloudBadges = new HashSet();
                    cloudVersionCode = 0;
                }
                boolean imported = false;
                for (Badges.Badge badge : cloudBadges) {
                    if (Badges.isUnlocked(badge)) continue;
                    Badges.addGlobal(badge);
                    imported = true;
                }
                if (imported) {
                    Badges.saveGlobal();
                    if (Game.scene() instanceof BadgesScene) {
                        ShatteredPixelDungeon.switchNoFade(BadgesScene.class);
                    }
                }
                for (Badges.Badge badge : cloudBadges) {
                    service.unlockAchievement(badge.toString());
                }
                for (Badges.Badge badge : Badges.allUnlocked()) {
                    if (ShatteredPixelDungeon.versionCode <= cloudVersionCode && cloudBadges.contains((Object)badge)) continue;
                    Bundle bundle = new Bundle();
                    Badges.store(bundle, Badges.allUnlocked());
                    bundle.put("version", ShatteredPixelDungeon.versionCode);
                    if (ShatteredPixelDungeon.versionCode < cloudVersionCode) {
                        bundle.put("version", cloudVersionCode);
                        List<String> badgeNames = Arrays.asList(bundle.getStringArray("badges"));
                        for (String cloudBadge : cloudBundle.getStringArray("badges")) {
                            if (badgeNames.contains(cloudBadge)) continue;
                            badgeNames.add(cloudBadge);
                        }
                        bundle.put("badges", badgeNames.toArray(new String[0]));
                    }
                    for (Badges.Badge unlocked : Badges.allUnlocked()) {
                        service.unlockAchievement(unlocked.toString());
                    }
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    Bundle.write(bundle, stream);
                    sender.sendData(stream.toByteArray());
                }
            }
        });
    }

    public static void syncJournal() {
        Journal.loadGlobal();
        if (!Sync.supportsSync()) {
            return;
        }
        if (!Sync.isConnected()) {
            if (SPDSettings.googlePlayGames()) {
                Sync.connectSilentOnly();
            }
            return;
        }
        service.syncJournal(new SyncService.ReceiveDataCallback(){

            @Override
            public void receiveData(byte[] data, SyncService.SendDataCallback sender) {
                int cloudVersionCode;
                HashSet<Object> cloudCatalogItems;
                HashSet<Object> cloudJournalPages;
                Bundle cloudBundle = null;
                try {
                    if (data.length > 0) {
                        cloudBundle = Bundle.read(new ByteArrayInputStream(data));
                        cloudJournalPages = new HashSet<String>(Arrays.asList(cloudBundle.getStringArray("documents")));
                        cloudCatalogItems = new HashSet<Class>(Arrays.asList(cloudBundle.getClassArray("catalog_items")));
                        cloudVersionCode = cloudBundle.getInt("version");
                    } else {
                        cloudJournalPages = new HashSet();
                        cloudCatalogItems = new HashSet();
                        cloudVersionCode = 0;
                    }
                }
                catch (Exception e) {
                    cloudJournalPages = new HashSet();
                    cloudCatalogItems = new HashSet();
                    cloudVersionCode = 0;
                }
                for (String string : cloudJournalPages) {
                    Document[] documentArray = Document.values();
                    int n = documentArray.length;
                    for (int i = 0; i < n; ++i) {
                        Document d = documentArray[i];
                        d.findPage(string);
                    }
                }
                for (Class clazz : cloudCatalogItems) {
                    Catalog.setSeen(clazz);
                }
                boolean syncNeeded = false;
                for (Document document : Document.values()) {
                    for (String string : document.pageNames()) {
                        if (!document.isPageFound(string) || cloudJournalPages.contains(string)) continue;
                        cloudJournalPages.add(string);
                        syncNeeded = true;
                    }
                }
                for (Catalog catalog : Catalog.values()) {
                    for (Class clazz : catalog.items()) {
                        if (!Catalog.isSeen(clazz) || cloudCatalogItems.contains(clazz)) continue;
                        cloudCatalogItems.add(clazz);
                        syncNeeded = true;
                    }
                }
                if (ShatteredPixelDungeon.versionCode > cloudVersionCode || syncNeeded) {
                    Bundle bundle = new Bundle();
                    bundle.put("documents", cloudJournalPages.toArray(new String[0]));
                    bundle.put("catalog_items", cloudCatalogItems.toArray(new Class[0]));
                    bundle.put("version", ShatteredPixelDungeon.versionCode);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    Bundle.write(bundle, stream);
                    sender.sendData(stream.toByteArray());
                }
            }
        });
    }

    public static void syncRankings() {
        Rankings.INSTANCE.load();
        if (!Sync.supportsSync()) {
            return;
        }
        if (!Sync.isConnected()) {
            if (SPDSettings.googlePlayGames()) {
                Sync.connectSilentOnly();
            }
            return;
        }
        service.syncRankings(new SyncService.ReceiveDataCallback(){

            @Override
            public void receiveData(byte[] data, SyncService.SendDataCallback sender) {
                ArrayList<Rankings.Record> cloudRecords = new ArrayList<Rankings.Record>();
                int cloudTotal = 0;
                int cloudWon = 0;
                try {
                    if (data.length > 0) {
                        Bundle cloudData = Bundle.read(new ByteArrayInputStream(data));
                        for (Bundlable bundlable : cloudData.getCollection("records")) {
                            cloudRecords.add((Rankings.Record)bundlable);
                        }
                        cloudTotal = cloudData.getInt("total");
                        cloudWon = cloudData.getInt("won");
                    }
                }
                catch (Exception e) {
                    ShatteredPixelDungeon.reportException(e);
                    cloudRecords = new ArrayList();
                }
                boolean syncNeeded = false;
                ArrayList<Rankings.Record> mergedRecords = new ArrayList<Rankings.Record>(Rankings.INSTANCE.records);
                for (Rankings.Record rec : cloudRecords) {
                    if (mergedRecords.contains(rec)) continue;
                    mergedRecords.add(rec);
                    syncNeeded = true;
                }
                Collections.sort(mergedRecords, Rankings.scoreComparator);
                while (mergedRecords.size() >= 11) {
                    mergedRecords.remove(mergedRecords.size() - 1);
                }
                for (Rankings.Record rec : mergedRecords) {
                    if (cloudRecords.contains(rec)) continue;
                    syncNeeded = true;
                    break;
                }
                int n = Rankings.INSTANCE.totalNumber - Rankings.INSTANCE.syncedTotal;
                int newWon = Rankings.INSTANCE.wonNumber - Rankings.INSTANCE.syncedWon;
                if (n > 0 || newWon > 0) {
                    syncNeeded = true;
                    cloudTotal += n;
                    cloudWon += newWon;
                }
                if (cloudTotal < Rankings.INSTANCE.totalNumber || cloudWon < Rankings.INSTANCE.wonNumber) {
                    syncNeeded = true;
                    cloudTotal = Rankings.INSTANCE.totalNumber;
                    cloudWon = Rankings.INSTANCE.wonNumber;
                }
                if (Rankings.INSTANCE.totalNumber != cloudTotal || Rankings.INSTANCE.wonNumber != cloudWon) {
                    syncNeeded = true;
                }
                if (syncNeeded) {
                    Bundle bundle = new Bundle();
                    bundle.put("records", mergedRecords);
                    bundle.put("total", cloudTotal);
                    bundle.put("won", cloudWon);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    Bundle.write(bundle, stream);
                    sender.sendData(stream.toByteArray());
                    ArrayList<Rankings.Record> localRecs = Rankings.INSTANCE.records;
                    int localLast = Rankings.INSTANCE.lastRecord;
                    if (localRecs.size() == 11) {
                        mergedRecords.add(localRecs.get(10));
                    }
                    localLast = localLast >= 0 && localLast < localRecs.size() ? mergedRecords.indexOf(localRecs.get(localLast)) : -1;
                    Rankings.INSTANCE.totalNumber = Rankings.INSTANCE.syncedTotal = cloudTotal;
                    Rankings.INSTANCE.wonNumber = Rankings.INSTANCE.syncedWon = cloudWon;
                    Rankings.INSTANCE.lastRecord = localLast;
                    Rankings.INSTANCE.records = mergedRecords;
                    Rankings.INSTANCE.save();
                    for (Rankings.Record rec : mergedRecords) {
                        if (localRecs.contains(rec)) continue;
                        if (ShatteredPixelDungeon.scene() == null || ShatteredPixelDungeon.scene().getClass() != RankingsScene.class) break;
                        ShatteredPixelDungeon.switchNoFade(RankingsScene.class);
                        break;
                    }
                }
            }
        });
    }

    public static void syncHallOfHeroes() {
        Rankings.INSTANCE.loadHall();
        if (!Sync.supportsSync()) {
            return;
        }
        if (!Sync.isConnected()) {
            if (SPDSettings.googlePlayGames()) {
                Sync.connectSilentOnly();
            }
            return;
        }
        service.syncHallOfHeroes(new SyncService.ReceiveDataCallback(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void receiveData(byte[] data, SyncService.SendDataCallback sender) {
                void var8_14;
                long cloudLastUpdated = 0L;
                String cloudLastID = null;
                ArrayList<Object> cloudRecords = new ArrayList();
                while (cloudRecords.size() < 4) {
                    cloudRecords.add(new ArrayList());
                }
                try {
                    if (data.length > 0) {
                        void var8_10;
                        Bundle cloudData = Bundle.read(new ByteArrayInputStream(data));
                        boolean bl = false;
                        while (cloudData.contains("records" + (int)var8_10)) {
                            for (Bundlable record : cloudData.getCollection("records" + (int)var8_10)) {
                                ((ArrayList)cloudRecords.get((int)var8_10)).add((Rankings.Record)record);
                            }
                            ++var8_10;
                        }
                        cloudLastUpdated = cloudData.getLong("updated");
                        cloudLastID = cloudData.getString("id");
                    }
                }
                catch (Exception e) {
                    ShatteredPixelDungeon.reportException(e);
                }
                if (cloudLastUpdated == Rankings.INSTANCE.hallLastUpdated) {
                    Rankings.INSTANCE.hallLastSynced = Game.realTime;
                    return;
                }
                if (cloudLastUpdated == 0L) {
                    cloudRecords = Rankings.INSTANCE.hallRecords;
                    cloudLastUpdated = Rankings.INSTANCE.hallLastUpdated;
                } else if (Rankings.INSTANCE.hallLastUpdated == 0L) {
                    Rankings.INSTANCE.hallRecords = cloudRecords;
                    Rankings.INSTANCE.hallLastUpdated = cloudLastUpdated;
                } else if (Rankings.INSTANCE.hallID.equals(cloudLastID)) {
                    if (Rankings.INSTANCE.hallLastUpdated > cloudLastUpdated) {
                        cloudRecords = Rankings.INSTANCE.hallRecords;
                        cloudLastUpdated = Rankings.INSTANCE.hallLastUpdated;
                    } else {
                        Rankings.INSTANCE.hallRecords = cloudRecords;
                        Rankings.INSTANCE.hallLastUpdated = cloudLastUpdated;
                    }
                } else if (Rankings.INSTANCE.hallLastSynced >= Rankings.INSTANCE.hallLastUpdated) {
                    Rankings.INSTANCE.hallRecords = cloudRecords;
                    Rankings.INSTANCE.hallLastUpdated = cloudLastUpdated;
                } else {
                    for (int i2 = 0; i2 < Rankings.INSTANCE.hallRecords.size(); ++i2) {
                        for (Rankings.Record localRec : Rankings.INSTANCE.hallRecords.get(i2)) {
                            int cloudPage = -1;
                            Rankings.Record cloudRec = null;
                            for (int j = 0; j < cloudRecords.size(); ++j) {
                                if (!((ArrayList)cloudRecords.get(j)).contains(localRec)) continue;
                                cloudPage = j;
                                cloudRec = (Rankings.Record)((ArrayList)cloudRecords.get(j)).get(((ArrayList)cloudRecords.get(j)).indexOf(localRec));
                                break;
                            }
                            if (cloudRec == null) {
                                ((ArrayList)cloudRecords.get(i2)).add(localRec);
                                continue;
                            }
                            if (localRec.lastUpdatedHOH <= cloudRec.lastUpdatedHOH) continue;
                            ((ArrayList)cloudRecords.get(cloudPage)).remove(cloudRec);
                            ((ArrayList)cloudRecords.get(i2)).add(localRec);
                        }
                    }
                    for (ArrayList arrayList : cloudRecords) {
                        Collections.sort(arrayList, Rankings.scoreComparator);
                        while (arrayList.size() > 11) {
                            arrayList.remove(arrayList.size() - 1);
                        }
                    }
                    Rankings.INSTANCE.hallRecords = cloudRecords;
                    if (Rankings.INSTANCE.hallLastUpdated > cloudLastUpdated) {
                        cloudLastUpdated = Rankings.INSTANCE.hallLastUpdated;
                    } else {
                        Rankings.INSTANCE.hallLastUpdated = cloudLastUpdated;
                    }
                }
                Rankings.INSTANCE.hallLastSynced = Game.realTime;
                cloudLastID = Rankings.INSTANCE.hallID;
                Bundle bundle = new Bundle();
                boolean bl = false;
                while (var8_14 < 4) {
                    bundle.put("records" + (int)var8_14, (Collection)cloudRecords.get((int)var8_14));
                    ++var8_14;
                }
                bundle.put("updated", cloudLastUpdated);
                bundle.put("id", cloudLastID);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Bundle.write(bundle, byteArrayOutputStream);
                sender.sendData(byteArrayOutputStream.toByteArray());
                if (ShatteredPixelDungeon.scene() != null && ShatteredPixelDungeon.scene().getClass() == HallOfHeroesScene.class) {
                    ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
                }
                Rankings.INSTANCE.saveHall();
            }
        });
    }
}

