/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.sprites;

import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DM100;
import com.shatteredpixel.shatteredpixeldungeon.effects.Lightning;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MobSprite;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.PointF;

public class DM100Sprite
extends MobSprite {
    public DM100Sprite() {
        this.texture("sprites/dm100.png");
        TextureFilm frames = new TextureFilm(this.texture, 16, 14);
        this.idle = new MovieClip.Animation(1, true);
        this.idle.frames(frames, 0, 1);
        this.run = new MovieClip.Animation(12, true);
        this.run.frames(frames, 6, 7, 8, 9);
        this.attack = new MovieClip.Animation(12, false);
        this.attack.frames(frames, 2, 3, 4, 0);
        this.zap = new MovieClip.Animation(8, false);
        this.zap.frames(frames, 5, 5, 1);
        this.die = new MovieClip.Animation(12, false);
        this.die.frames(frames, 10, 11, 12, 13, 14, 15);
        this.play(this.idle);
    }

    @Override
    public void zap(int pos) {
        Char enemy = Actor.findChar(pos);
        PointF origin = this.center();
        if (this.flipHorizontal) {
            origin.y -= 6.0f * this.scale.y;
            origin.x -= 1.0f * this.scale.x;
        } else {
            origin.y -= 8.0f * this.scale.y;
            origin.x += 1.0f * this.scale.x;
        }
        if (enemy != null) {
            this.parent.add(new Lightning(origin, enemy.sprite.destinationCenter(), (Callback)((DM100)this.ch)));
        } else {
            this.parent.add(new Lightning(origin, pos, (Callback)((DM100)this.ch)));
        }
        Sample.INSTANCE.play("sounds/lightning.mp3");
        this.turnTo(this.ch.pos, pos);
        this.flash();
        this.play(this.zap);
    }

    @Override
    public void die() {
        this.emitter().burst(Speck.factory(7), 5);
        super.die();
    }

    @Override
    public void onComplete(MovieClip.Animation anim) {
        if (anim == this.zap) {
            this.idle();
        }
        super.onComplete(anim);
    }

    @Override
    public int blood() {
        return -120;
    }
}

