/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.QuickSlot;
import com.shatteredpixel.shatteredpixeldungeon.SPDAction;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LostInventory;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.Button;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.InventoryPane;
import com.shatteredpixel.shatteredpixeldungeon.ui.ItemSlot;
import com.shatteredpixel.shatteredpixeldungeon.ui.TargetHealthIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndKeyBindings;
import com.watabou.input.GameAction;
import com.watabou.noosa.Image;
import com.watabou.utils.PathFinder;

public class QuickSlotButton
extends Button {
    private static QuickSlotButton[] instance = new QuickSlotButton[QuickSlot.SIZE];
    private int slotNum;
    private ItemSlot slot;
    private static Image crossB;
    private static Image crossM;
    private static boolean targeting;
    public static Char lastTarget;
    private WndBag.ItemSelector itemSelector = new WndBag.ItemSelector(){

        @Override
        public String textPrompt() {
            return Messages.get(QuickSlotButton.class, "select_item", new Object[0]);
        }

        @Override
        public boolean itemSelectable(Item item) {
            return item.defaultAction != null;
        }

        @Override
        public void onSelect(Item item) {
            if (item != null) {
                Dungeon.quickslot.setSlot(QuickSlotButton.this.slotNum, item);
                QuickSlotButton.refresh();
            }
        }
    };

    public QuickSlotButton(int slotNum) {
        this.slotNum = slotNum;
        this.item(QuickSlotButton.select(slotNum));
        QuickSlotButton.instance[slotNum] = this;
    }

    @Override
    public void destroy() {
        super.destroy();
        QuickSlotButton.reset();
    }

    public static void reset() {
        instance = new QuickSlotButton[QuickSlot.SIZE];
        lastTarget = null;
    }

    @Override
    protected void createChildren() {
        super.createChildren();
        this.slot = new ItemSlot(){

            @Override
            protected void onClick() {
                if (!Dungeon.hero.isAlive() || !Dungeon.hero.ready) {
                    return;
                }
                if (targeting) {
                    int cell = QuickSlotButton.autoAim(lastTarget, QuickSlotButton.select(QuickSlotButton.this.slotNum));
                    if (cell != -1) {
                        GameScene.handleCell(cell);
                    } else {
                        GameScene.handleCell(QuickSlotButton.lastTarget.pos);
                    }
                } else {
                    Item item = QuickSlotButton.select(QuickSlotButton.this.slotNum);
                    if (Dungeon.hero.belongings.contains(item) && !GameScene.cancel()) {
                        GameScene.centerNextWndOnInvPane();
                        item.execute(Dungeon.hero);
                        if (item.usesTargeting) {
                            QuickSlotButton.this.useTargeting();
                        }
                    }
                }
            }

            @Override
            protected void onRightClick() {
                QuickSlotButton.this.onLongClick();
            }

            @Override
            public GameAction keyAction() {
                return QuickSlotButton.this.keyAction();
            }

            @Override
            protected boolean onLongClick() {
                return QuickSlotButton.this.onLongClick();
            }

            @Override
            protected void onPointerDown() {
                this.sprite.lightness(0.7f);
            }

            @Override
            protected void onPointerUp() {
                this.sprite.resetColor();
            }

            @Override
            protected String hoverText() {
                if (this.item == null) {
                    return Messages.titleCase(Messages.get(WndKeyBindings.class, "quickslot_" + (QuickSlotButton.this.slotNum + 1), new Object[0]));
                }
                return super.hoverText();
            }
        };
        this.slot.showExtraInfo(false);
        this.add(this.slot);
        crossB = Icons.TARGET.get();
        QuickSlotButton.crossB.visible = false;
        this.add(crossB);
        crossM = new Image();
        crossM.copy(crossB);
    }

    @Override
    protected void layout() {
        super.layout();
        this.slot.fill(this);
        QuickSlotButton.crossB.x = this.x + (this.width - QuickSlotButton.crossB.width) / 2.0f;
        QuickSlotButton.crossB.y = this.y + (this.height - QuickSlotButton.crossB.height) / 2.0f;
        PixelScene.align(crossB);
    }

    @Override
    public void update() {
        super.update();
        if (targeting && lastTarget != null && QuickSlotButton.lastTarget.sprite != null) {
            crossM.point(QuickSlotButton.lastTarget.sprite.center(crossM));
        }
    }

    @Override
    public GameAction keyAction() {
        switch (this.slotNum) {
            case 0: {
                return SPDAction.QUICKSLOT_1;
            }
            case 1: {
                return SPDAction.QUICKSLOT_2;
            }
            case 2: {
                return SPDAction.QUICKSLOT_3;
            }
            case 3: {
                return SPDAction.QUICKSLOT_4;
            }
            case 4: {
                return SPDAction.QUICKSLOT_5;
            }
            case 5: {
                return SPDAction.QUICKSLOT_6;
            }
        }
        return super.keyAction();
    }

    @Override
    protected String hoverText() {
        if (this.slot.item == null) {
            return Messages.titleCase(Messages.get(WndKeyBindings.class, "quickslot_" + (this.slotNum + 1), new Object[0]));
        }
        return super.hoverText();
    }

    @Override
    protected void onClick() {
        if (Dungeon.hero.ready && !GameScene.cancel()) {
            GameScene.selectItem(this.itemSelector);
        }
    }

    @Override
    protected boolean onLongClick() {
        if (Dungeon.hero.ready && !GameScene.cancel()) {
            GameScene.selectItem(this.itemSelector);
        }
        return true;
    }

    private static Item select(int slotNum) {
        return Dungeon.quickslot.getItem(slotNum);
    }

    public void item(Item item) {
        this.slot.item(item);
        this.enableSlot();
    }

    public void enable(boolean value) {
        this.active = value;
        if (value) {
            this.enableSlot();
        } else {
            this.slot.enable(false);
        }
    }

    private void enableSlot() {
        this.slot.enable(Dungeon.quickslot.isNonePlaceholder(this.slotNum) != false && (Dungeon.hero.buff(LostInventory.class) == null || Dungeon.quickslot.getItem((int)this.slotNum).keptThoughLostInvent));
    }

    public void slotMargins(int left, int top, int right, int bottom) {
        this.slot.setMargins(left, top, right, bottom);
    }

    public static void useTargeting(int idx) {
        instance[idx].useTargeting();
    }

    private void useTargeting() {
        if (lastTarget != null && Actor.chars().contains(lastTarget) && lastTarget.isAlive() && QuickSlotButton.lastTarget.alignment != Char.Alignment.ALLY && Dungeon.level.heroFOV[QuickSlotButton.lastTarget.pos]) {
            targeting = true;
            CharSprite sprite = QuickSlotButton.lastTarget.sprite;
            if (sprite.parent != null) {
                sprite.parent.addToFront(crossM);
                crossM.point(sprite.center(crossM));
            }
            crossB.point(this.slot.sprite.center(crossB));
            QuickSlotButton.crossB.visible = true;
        } else {
            lastTarget = null;
            targeting = false;
        }
    }

    public static int autoAim(Char target) {
        return QuickSlotButton.autoAim(target, new Item());
    }

    public static int autoAim(Char target, Item item) {
        if (item.targetingPos(Dungeon.hero, target.pos) == target.pos) {
            return target.pos;
        }
        PathFinder.buildDistanceMap(target.pos, BArray.not(new boolean[Dungeon.level.length()], null), 2);
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            if (PathFinder.distance[i] >= Integer.MAX_VALUE || item.targetingPos(Dungeon.hero, i) != target.pos) continue;
            return i;
        }
        return -1;
    }

    public static void refresh() {
        for (int i = 0; i < instance.length; ++i) {
            if (instance[i] == null) continue;
            instance[i].item(QuickSlotButton.select(i));
            instance[i].enable(QuickSlotButton.instance[i].active);
        }
    }

    public static void target(Char target) {
        if (target != null && target.alignment != Char.Alignment.ALLY) {
            lastTarget = target;
            TargetHealthIndicator.instance.target(target);
            InventoryPane.lastTarget = target;
        }
    }

    public static void cancel() {
        if (targeting) {
            QuickSlotButton.crossB.visible = false;
            crossM.remove();
            targeting = false;
        }
    }

    static {
        targeting = false;
        lastTarget = null;
    }
}

