/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.SPDAction;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTerrainTilemap;
import com.shatteredpixel.shatteredpixeldungeon.ui.Button;
import com.shatteredpixel.shatteredpixeldungeon.ui.CurrencyIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickSlotButton;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndKeyBindings;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndQuickBag;
import com.watabou.input.GameAction;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.Point;
import com.watabou.utils.PointF;

public class Toolbar
extends Component {
    private Tool btnWait;
    private Tool btnSearch;
    private Tool btnInventory;
    private QuickslotTool[] btnQuick;
    private PickedUpItem pickedUp;
    private boolean lastEnabled = true;
    public boolean examining = false;
    private static Toolbar instance;
    private static CellSelector.Listener informer;

    public Toolbar() {
        instance = this;
        this.height = this.btnInventory.height();
    }

    @Override
    protected void createChildren() {
        int quickSlots = 4;
        if (PixelScene.uiCamera.width > 152) {
            ++quickSlots;
        }
        if (PixelScene.uiCamera.width > 170) {
            ++quickSlots;
        }
        this.btnQuick = new QuickslotTool[quickSlots];
        for (int i = 0; i < quickSlots; ++i) {
            this.btnQuick[i] = new QuickslotTool(64, 0, 22, 24, i);
            this.add(this.btnQuick[i]);
        }
        this.btnWait = new Tool(24, 0, 20, 26){

            @Override
            protected void onClick() {
                if (Dungeon.hero.ready && !GameScene.cancel()) {
                    Toolbar.this.examining = false;
                    Dungeon.hero.rest(false);
                }
            }

            @Override
            public GameAction keyAction() {
                return SPDAction.WAIT;
            }

            @Override
            protected String hoverText() {
                return Messages.titleCase(Messages.get(WndKeyBindings.class, "wait", new Object[0]));
            }

            @Override
            protected boolean onLongClick() {
                if (Dungeon.hero.ready && !GameScene.cancel()) {
                    Toolbar.this.examining = false;
                    Dungeon.hero.rest(true);
                }
                return true;
            }
        };
        this.add(this.btnWait);
        this.add(new Button(){

            @Override
            protected void onClick() {
                if (Dungeon.hero.ready && !GameScene.cancel()) {
                    Toolbar.this.examining = false;
                    Dungeon.hero.rest(true);
                }
            }

            @Override
            public GameAction keyAction() {
                if (((Toolbar)Toolbar.this).btnWait.active) {
                    return SPDAction.REST;
                }
                return null;
            }
        });
        this.btnSearch = new Tool(44, 0, 20, 26){

            @Override
            protected void onClick() {
                if (Dungeon.hero.ready) {
                    if (!Toolbar.this.examining && !GameScene.cancel()) {
                        GameScene.selectCell(informer);
                        Toolbar.this.examining = true;
                    } else if (Toolbar.this.examining) {
                        informer.onSelect(null);
                        Dungeon.hero.search(true);
                    }
                }
            }

            @Override
            public GameAction keyAction() {
                return SPDAction.EXAMINE;
            }

            @Override
            protected String hoverText() {
                return Messages.titleCase(Messages.get(WndKeyBindings.class, "examine", new Object[0]));
            }

            @Override
            protected boolean onLongClick() {
                Dungeon.hero.search(true);
                return true;
            }
        };
        this.add(this.btnSearch);
        this.btnInventory = new Tool(0, 0, 24, 26){
            private CurrencyIndicator ind;
            private Image arrow;

            @Override
            protected void onClick() {
                if (Dungeon.hero.ready || !Dungeon.hero.isAlive()) {
                    if (SPDSettings.interfaceSize() == 2) {
                        GameScene.toggleInvPane();
                    } else if (!GameScene.cancel()) {
                        GameScene.show(new WndBag(Dungeon.hero.belongings.backpack));
                    }
                }
            }

            @Override
            public GameAction keyAction() {
                return SPDAction.INVENTORY;
            }

            @Override
            protected String hoverText() {
                return Messages.titleCase(Messages.get(WndKeyBindings.class, "inventory", new Object[0]));
            }

            @Override
            protected boolean onLongClick() {
                GameScene.show(new WndQuickBag(null));
                return true;
            }

            @Override
            protected void createChildren() {
                super.createChildren();
                this.arrow = Icons.get(Icons.COMPASS);
                this.arrow.originToCenter();
                this.arrow.visible = SPDSettings.interfaceSize() == 2;
                this.arrow.tint(4009496, 1.0f);
                this.add(this.arrow);
                this.ind = new CurrencyIndicator();
                this.add(this.ind);
            }

            @Override
            protected void layout() {
                super.layout();
                this.ind.fill(this);
                this.arrow.x = this.left() + (this.width - this.arrow.width()) / 2.0f;
                this.arrow.y = this.bottom() - this.arrow.height - 1.0f;
                this.arrow.angle = this.bottom() == (float)this.camera().height ? 0.0f : 180.0f;
            }
        };
        this.add(this.btnInventory);
        this.pickedUp = new PickedUpItem();
        this.add(this.pickedUp);
    }

    @Override
    protected void layout() {
        int i;
        float right = this.width;
        if (SPDSettings.interfaceSize() > 0) {
            this.btnInventory.setPos(right - this.btnInventory.width(), this.y);
            this.btnWait.setPos(this.btnInventory.left() - this.btnWait.width(), this.y);
            this.btnSearch.setPos(this.btnWait.left() - this.btnSearch.width(), this.y);
            right = this.btnSearch.left();
            for (int i2 = this.btnQuick.length - 1; i2 >= 0; --i2) {
                if (i2 == this.btnQuick.length - 1) {
                    this.btnQuick[i2].border(0, 2);
                    this.btnQuick[i2].frame(106, 0, 19, 24);
                } else if (i2 == 0) {
                    this.btnQuick[i2].border(2, 1);
                    this.btnQuick[i2].frame(86, 0, 20, 24);
                } else {
                    this.btnQuick[i2].border(0, 1);
                    this.btnQuick[i2].frame(88, 0, 18, 24);
                }
                this.btnQuick[i2].setPos(right - this.btnQuick[i2].width(), this.y + 2.0f);
                right = this.btnQuick[i2].left();
            }
            return;
        }
        for (i = 0; i < this.btnQuick.length; ++i) {
            if (i == 0 && !SPDSettings.flipToolbar() || i == this.btnQuick.length - 1 && SPDSettings.flipToolbar()) {
                this.btnQuick[i].border(0, 2);
                this.btnQuick[i].frame(106, 0, 19, 24);
                continue;
            }
            if (i == 0 && SPDSettings.flipToolbar() || i == this.btnQuick.length - 1 && !SPDSettings.flipToolbar()) {
                this.btnQuick[i].border(2, 1);
                this.btnQuick[i].frame(86, 0, 20, 24);
                continue;
            }
            this.btnQuick[i].border(0, 1);
            this.btnQuick[i].frame(88, 0, 18, 24);
        }
        switch (Mode.valueOf(SPDSettings.toolbarMode())) {
            case SPLIT: {
                this.btnWait.setPos(this.x, this.y);
                this.btnSearch.setPos(this.btnWait.right(), this.y);
                this.btnInventory.setPos(right - this.btnInventory.width(), this.y);
                this.btnQuick[0].setPos(this.btnInventory.left() - this.btnQuick[0].width(), this.y + 2.0f);
                for (i = 1; i < this.btnQuick.length; ++i) {
                    this.btnQuick[i].setPos(this.btnQuick[i - 1].left() - this.btnQuick[i].width(), this.y + 2.0f);
                }
                if (!(this.btnQuick[this.btnQuick.length - 1].left() < this.btnSearch.right())) break;
                float diff = Math.round(this.btnSearch.right() - this.btnQuick[this.btnQuick.length - 1].left()) / 2;
                for (int i3 = 0; i3 < this.btnQuick.length; ++i3) {
                    this.btnQuick[i3].setPos(this.btnQuick[i3].left() + diff, this.btnQuick[i3].top());
                }
                break;
            }
            case CENTER: {
                float toolbarWidth = this.btnWait.width() + this.btnSearch.width() + this.btnInventory.width();
                for (QuickslotTool slot : this.btnQuick) {
                    if (!slot.visible) continue;
                    toolbarWidth += slot.width();
                }
                right = (this.width + toolbarWidth) / 2.0f;
            }
            case GROUP: {
                this.btnWait.setPos(right - this.btnWait.width(), this.y);
                this.btnSearch.setPos(this.btnWait.left() - this.btnSearch.width(), this.y);
                this.btnInventory.setPos(this.btnSearch.left() - this.btnInventory.width(), this.y);
                this.btnQuick[0].setPos(this.btnInventory.left() - this.btnQuick[0].width(), this.y + 2.0f);
                for (int i4 = 1; i4 < this.btnQuick.length; ++i4) {
                    this.btnQuick[i4].setPos(this.btnQuick[i4 - 1].left() - this.btnQuick[i4].width(), this.y + 2.0f);
                }
                if (!(this.btnQuick[this.btnQuick.length - 1].left() < 0.0f)) break;
                float diff = -Math.round(this.btnQuick[this.btnQuick.length - 1].left()) / 2;
                for (int i5 = 0; i5 < this.btnQuick.length; ++i5) {
                    this.btnQuick[i5].setPos(this.btnQuick[i5].left() + diff, this.btnQuick[i5].top());
                }
                break;
            }
        }
        right = this.width;
        if (SPDSettings.flipToolbar()) {
            this.btnWait.setPos(right - this.btnWait.right(), this.y);
            this.btnSearch.setPos(right - this.btnSearch.right(), this.y);
            this.btnInventory.setPos(right - this.btnInventory.right(), this.y);
            for (int i6 = 0; i6 <= this.btnQuick.length; ++i6) {
                this.btnQuick[i6].setPos(right - this.btnQuick[i6].right(), this.y + 2.0f);
            }
        }
    }

    public static void updateLayout() {
        if (instance != null) {
            instance.layout();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.lastEnabled != (Dungeon.hero.ready && Dungeon.hero.isAlive())) {
            this.lastEnabled = Dungeon.hero.ready && Dungeon.hero.isAlive();
            for (Gizmo tool : this.members.toArray(new Gizmo[0])) {
                if (!(tool instanceof Tool)) continue;
                ((Tool)tool).enable(this.lastEnabled);
            }
        }
        if (!Dungeon.hero.isAlive()) {
            this.btnInventory.enable(true);
        }
    }

    public void pickup(Item item, int cell) {
        this.pickedUp.reset(item, cell, this.btnInventory.centerX(), this.btnInventory.centerY());
    }

    static {
        informer = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer cell) {
                instance.examining = false;
                GameScene.examineCell(cell);
            }

            @Override
            public String prompt() {
                return Messages.get(Toolbar.class, "examine_prompt", new Object[0]);
            }
        };
    }

    public static class PickedUpItem
    extends ItemSprite {
        private static final float DURATION = 0.5f;
        private float startScale;
        private float startX;
        private float startY;
        private float endX;
        private float endY;
        private float left;

        public PickedUpItem() {
            this.originToCenter();
            this.visible = false;
            this.active = false;
        }

        public void reset(Item item, int cell, float endX, float endY) {
            this.view(item);
            this.visible = true;
            this.active = true;
            PointF tile = DungeonTerrainTilemap.raisedTileCenterToWorld(cell);
            Point screen = Camera.main.cameraToScreen(tile.x, tile.y);
            PointF start = this.camera().screenToCamera(screen.x, screen.y);
            this.x = this.startX = start.x - this.width() / 2.0f;
            this.y = this.startY = start.y - this.width() / 2.0f;
            this.endX = endX - this.width() / 2.0f;
            this.endY = endY - this.width() / 2.0f;
            this.left = 0.5f;
            this.startScale = Camera.main.zoom / this.camera().zoom;
            this.scale.set(this.startScale);
        }

        @Override
        public void update() {
            float f;
            super.update();
            this.left -= Game.elapsed;
            if (f <= 0.0f) {
                this.active = false;
                this.visible = false;
                if (this.emitter != null) {
                    this.emitter.on = false;
                }
            } else {
                float p = this.left / 0.5f;
                this.scale.set(this.startScale * (float)Math.sqrt(p));
                this.x = this.startX * p + this.endX * (1.0f - p);
                this.y = this.startY * p + this.endY * (1.0f - p);
            }
        }
    }

    private static class QuickslotTool
    extends Tool {
        private QuickSlotButton slot;
        private int borderLeft = 2;
        private int borderRight = 2;

        public QuickslotTool(int x, int y, int width, int height, int slotNum) {
            super(x, y, width, height);
            this.slot = new QuickSlotButton(slotNum);
            this.add(this.slot);
        }

        public void border(int left, int right) {
            this.borderLeft = left;
            this.borderRight = right;
            this.layout();
        }

        @Override
        protected void layout() {
            super.layout();
            this.slot.setRect(this.x, this.y, this.width, this.height);
            this.slot.slotMargins(this.borderLeft, 2, this.borderRight, 2);
        }

        @Override
        public void enable(boolean value) {
            super.enable(value);
            this.slot.enable(value);
        }
    }

    private static class Tool
    extends Button {
        private final int BGCOLOR = SPDSettings.goldenUI() ? 8288856 : 8093811;
        private Image base;

        public Tool(int x, int y, int width, int height) {
            this.hotArea.blockLevel = 0;
            this.frame(x, y, width, height);
        }

        public void frame(int x, int y, int width, int height) {
            this.base.frame(x, y, width, height);
            this.width = width;
            this.height = height;
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.base = new Image(SPDSettings.goldenUI() ? "private/toolbar_gold.png" : "interfaces/toolbar.png");
            this.add(this.base);
        }

        @Override
        protected void layout() {
            super.layout();
            this.base.x = this.x;
            this.base.y = this.y;
        }

        @Override
        protected void onPointerDown() {
            this.base.brightness(1.4f);
        }

        @Override
        protected void onPointerUp() {
            if (this.active) {
                this.base.resetColor();
            } else {
                this.base.tint(this.BGCOLOR, 0.7f);
            }
        }

        public void enable(boolean value) {
            if (value != this.active) {
                if (value) {
                    this.base.resetColor();
                } else {
                    this.base.tint(this.BGCOLOR, 0.7f);
                }
                this.active = value;
            }
        }
    }

    public static enum Mode {
        SPLIT,
        GROUP,
        CENTER;

    }
}

