/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.effects.BadgeBanner;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.watabou.noosa.Image;

public class WndBadge
extends Window {
    private static final int WIDTH = 120;
    private static final int MARGIN = 4;

    public WndBadge(Badges.Badge badge, boolean unlocked) {
        Image icon = BadgeBanner.image(badge.image);
        icon.scale.set(2.0f);
        if (!unlocked) {
            icon.brightness(0.4f);
        }
        this.add(icon);
        RenderedTextBlock title = PixelScene.renderTextBlock(badge.title(), 9);
        title.hardlight(0xFFFF44);
        if (!unlocked) {
            title.hardlight(0x888822);
        }
        this.add(title);
        RenderedTextBlock info = PixelScene.renderTextBlock(badge.desc(), 6);
        info.maxWidth(112);
        info.align(2);
        if (!unlocked) {
            info.hardlight(0x888888);
        }
        this.add(info);
        float w = Math.max(icon.width(), Math.max(title.width(), info.width())) + 8.0f;
        icon.x = (w - icon.width()) / 2.0f;
        icon.y = 4.0f;
        PixelScene.align(icon);
        title.setPos((w - title.width()) / 2.0f, icon.y + icon.height() + 4.0f);
        PixelScene.align(title);
        info.setPos((w - info.width()) / 2.0f, title.bottom() + 4.0f);
        PixelScene.align(info);
        this.resize((int)w, (int)(info.bottom() + 4.0f));
        if (unlocked) {
            BadgeBanner.highlight(icon, badge.image);
        }
    }
}

