/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.TalentIcon;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.watabou.utils.Callback;

public class WndInfoTalent
extends Window {
    private static final float GAP = 2.0f;
    private static final int WIDTH = 120;

    public WndInfoTalent(Talent talent, int points, final TalentButtonCallback buttonCallback) {
        IconTitle titlebar = new IconTitle();
        titlebar.icon(new TalentIcon(talent));
        String title = Messages.titleCase(talent.title());
        if (points > 0) {
            title = title + " +" + points;
        }
        titlebar.label(title, 0xFFFF44);
        titlebar.setRect(0.0f, 0.0f, 120.0f, 0.0f);
        this.add(titlebar);
        RenderedTextBlock txtInfo = PixelScene.renderTextBlock(talent.desc(), 6);
        txtInfo.maxWidth(120);
        txtInfo.setPos(titlebar.left(), titlebar.bottom() + 4.0f);
        this.add(txtInfo);
        this.resize(120, (int)(txtInfo.bottom() + 2.0f));
        if (buttonCallback != null) {
            RedButton button = new RedButton(buttonCallback.prompt()){

                @Override
                protected void onClick() {
                    super.onClick();
                    WndInfoTalent.this.hide();
                    buttonCallback.call();
                }
            };
            button.icon(Icons.get(Icons.TALENT));
            button.setRect(0.0f, txtInfo.bottom() + 4.0f, 120.0f, 18.0f);
            this.add(button);
            this.resize(120, (int)button.bottom() + 1);
        }
    }

    public static abstract class TalentButtonCallback
    implements Callback {
        public abstract String prompt();
    }
}

