/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.HallOfHeroesScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.RankingsScene;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.Analytics;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.shatteredpixel.shatteredpixeldungeon.sprites.HeroSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.BadgesGrid;
import com.shatteredpixel.shatteredpixeldungeon.ui.BadgesList;
import com.shatteredpixel.shatteredpixeldungeon.ui.Button;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.ItemSlot;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.TalentButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.TalentsPane;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.ui.WndTextInput;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndChallenges;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndError;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoItem;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTabbed;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.ui.Component;
import java.util.ArrayList;
import java.util.Locale;

public class WndRanking
extends WndTabbed {
    private static final int WIDTH = 115;
    private static final int HEIGHT = 144;
    private static Thread thread;
    private String error = null;
    private Image busy;
    private String gameID;

    public WndRanking(final Rankings.Record rec) {
        this.resize(115, 144);
        if (thread != null) {
            this.hide();
            return;
        }
        thread = new Thread(){

            @Override
            public void run() {
                try {
                    Badges.loadGlobal();
                    Rankings.INSTANCE.loadGameData(rec);
                }
                catch (Exception e) {
                    Analytics.trackException(e);
                    WndRanking.this.error = Messages.get(WndRanking.class, "error", new Object[0]);
                }
            }
        };
        this.gameID = rec.gameID;
        this.busy = Icons.BUSY.get();
        this.busy.origin.set(this.busy.width / 2.0f, this.busy.height / 2.0f);
        this.busy.angularSpeed = 720.0f;
        this.busy.x = (115.0f - this.busy.width) / 2.0f;
        this.busy.y = (144.0f - this.busy.height) / 2.0f;
        this.add(this.busy);
        thread.start();
    }

    @Override
    public void update() {
        super.update();
        if (thread != null && !thread.isAlive() && this.busy != null) {
            if (this.error == null) {
                this.remove(this.busy);
                this.busy = null;
                if (Dungeon.hero != null) {
                    this.createControls();
                } else {
                    this.hide();
                }
            } else {
                this.hide();
                Game.scene().add(new WndError(this.error){
                    {
                        if (HallOfHeroesScene.inHOH) {
                            RedButton btnMove = new RedButton(Messages.get(WndRanking.class, "move", new Object[0])){

                                @Override
                                protected void onClick() {
                                    super.onClick();
                                    for (final Rankings.Record record : Rankings.INSTANCE.hallRecords.get(HallOfHeroesScene.page)) {
                                        if (!record.gameID.equals(WndRanking.this.gameID)) continue;
                                        ArrayList<String> pages = new ArrayList<String>();
                                        for (int i = 0; i < 4; ++i) {
                                            if (i == HallOfHeroesScene.page) continue;
                                            pages.add(Messages.get(WndRanking.class, "page", i + 1));
                                        }
                                        this.parent.add(new WndOptions("", Messages.get(WndRanking.class, "move_where", new Object[0]), new String[]{Messages.get(WndRanking.class, "remove", new Object[0]), (String)pages.get(0), (String)pages.get(1), (String)pages.get(2)}){

                                            @Override
                                            protected void onSelect(int index) {
                                                int page;
                                                int n = page = index - 1 >= HallOfHeroesScene.page ? index : index - 1;
                                                if (index == 0) {
                                                    Rankings.INSTANCE.hallRecords.get(HallOfHeroesScene.page).remove(record);
                                                    Rankings.INSTANCE.hallLastUpdated = Game.realTime;
                                                    Rankings.INSTANCE.saveHall();
                                                    ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
                                                } else if (Rankings.INSTANCE.sendToHall(record, page, HallOfHeroesScene.page)) {
                                                    ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
                                                } else {
                                                    Game.scene().add(new WndError(Messages.get(WndRanking.class, "page_full", new Object[0])));
                                                }
                                            }
                                        });
                                    }
                                }
                            };
                            btnMove.setRect(0.0f, 25.0f, 45.0f, 14.0f);
                            this.add(btnMove);
                            RedButton btnNotes = new RedButton(Messages.get(WndRanking.class, "notes", new Object[0])){

                                @Override
                                protected void onClick() {
                                    super.onClick();
                                    Rankings.Record tempRec = null;
                                    for (Rankings.Record rec : Rankings.INSTANCE.hallRecords.get(HallOfHeroesScene.page)) {
                                        if (!rec.gameID.equals(WndRanking.this.gameID)) continue;
                                        tempRec = rec;
                                        break;
                                    }
                                    final Rankings.Record record = tempRec;
                                    Game.scene().addToFront(new WndTextInput(Messages.get(WndRanking.class, "custom_note", new Object[0]), record.note, 2000, true, Messages.get(WndRanking.class, "save", new Object[0]), Messages.get(WndRanking.class, "cancel", new Object[0])){

                                        @Override
                                        public void onSelect(boolean positive, String text) {
                                            if (positive) {
                                                record.note = text;
                                                record.lastUpdatedHOH = Rankings.INSTANCE.hallLastUpdated = Game.realTime;
                                                Rankings.INSTANCE.saveHall();
                                            }
                                        }
                                    });
                                }
                            };
                            btnNotes.setRect(50.0f, 25.0f, 45.0f, 14.0f);
                            this.add(btnNotes);
                            this.resize(this.width, (int)btnMove.bottom());
                        }
                    }
                });
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        thread = null;
    }

    private void createControls() {
        Icons[] icons = new Icons[]{Icons.RANKINGS, Icons.BACKPACK_LRG, Icons.BADGES};
        Group[] pages = new Group[]{new StatsTab(), new ItemsTab(), new BadgesTab()};
        for (int i = 0; i < pages.length; ++i) {
            this.add(pages[i]);
            RankingTab tab = new RankingTab(icons[i], pages[i]);
            this.add(tab);
        }
        this.layoutTabs();
        this.select(0);
    }

    private class QuickSlotButton
    extends ItemSlot {
        public static final int HEIGHT = 23;
        private Item item;
        private ColorBlock bg;

        QuickSlotButton(Item item) {
            super(item);
            this.item = item;
        }

        @Override
        protected void createChildren() {
            this.bg = new ColorBlock(28.0f, 23.0f, -1722591667);
            this.add(this.bg);
            super.createChildren();
        }

        @Override
        protected void layout() {
            this.bg.x = this.x;
            this.bg.y = this.y;
            super.layout();
        }

        @Override
        protected void onPointerDown() {
            this.bg.brightness(1.5f);
            Sample.INSTANCE.play("sounds/click.mp3", 0.7f, 0.7f, 1.2f);
        }

        @Override
        protected void onPointerUp() {
            this.bg.brightness(1.0f);
        }

        @Override
        protected void onClick() {
            Game.scene().add(new WndInfoItem(this.item));
        }
    }

    private class ItemButton
    extends Button {
        public static final int HEIGHT = 23;
        private Item item;
        private ItemSlot slot;
        private ColorBlock bg;
        private RenderedTextBlock name;

        public ItemButton(Item item) {
            this.item = item;
            this.slot.item(item);
            if (item.cursed && item.cursedKnown) {
                this.bg.ra = 0.2f;
                this.bg.ga = -0.1f;
            } else if (!item.isIdentified()) {
                this.bg.ra = 0.1f;
                this.bg.ba = 0.1f;
            }
        }

        @Override
        protected void createChildren() {
            this.bg = new ColorBlock(28.0f, 23.0f, -1722591667);
            this.add(this.bg);
            this.slot = new ItemSlot();
            this.add(this.slot);
            this.name = PixelScene.renderTextBlock(7);
            this.add(this.name);
            super.createChildren();
        }

        @Override
        protected void layout() {
            this.bg.x = this.x;
            this.bg.y = this.y;
            this.slot.setRect(this.x, this.y, 28.0f, 23.0f);
            PixelScene.align(this.slot);
            this.name.maxWidth((int)(this.width - this.slot.width() - 2.0f));
            this.name.text(Messages.titleCase(this.item.name()));
            this.name.setPos(this.slot.right() + 2.0f, this.y + (this.height - this.name.height()) / 2.0f);
            PixelScene.align(this.name);
            super.layout();
        }

        @Override
        protected void onPointerDown() {
            this.bg.brightness(1.5f);
            Sample.INSTANCE.play("sounds/click.mp3", 0.7f, 0.7f, 1.2f);
        }

        @Override
        protected void onPointerUp() {
            this.bg.brightness(1.0f);
        }

        @Override
        protected void onClick() {
            Game.scene().add(new WndInfoItem(this.item));
        }
    }

    private class BadgesTab
    extends Group {
        public BadgesTab() {
            this.camera = WndRanking.this.camera;
            Component badges = Badges.unlocked(false) <= 7 ? new BadgesList(false) : new BadgesGrid(false);
            this.add(badges);
            badges.setSize(115.0f, 144.0f);
        }
    }

    private class ItemsTab
    extends Group {
        private float pos;

        public ItemsTab() {
            Belongings stuff = Dungeon.hero.belongings;
            if (stuff.weapon != null) {
                this.addItem(stuff.weapon);
            }
            if (stuff.armor != null) {
                this.addItem(stuff.armor);
            }
            if (stuff.artifact != null) {
                this.addItem(stuff.artifact);
            }
            if (stuff.misc != null) {
                this.addItem(stuff.misc);
            }
            if (stuff.ring != null) {
                this.addItem(stuff.ring);
            }
            this.pos = 0.0f;
            for (int i = 0; i < 4; ++i) {
                if (Dungeon.quickslot.getItem(i) != null) {
                    QuickSlotButton slot = new QuickSlotButton(Dungeon.quickslot.getItem(i));
                    slot.setRect(this.pos, 120.0f, 28.0f, 23.0f);
                    this.add(slot);
                } else {
                    ColorBlock bg = new ColorBlock(28.0f, 23.0f, -1722591667);
                    bg.x = this.pos;
                    bg.y = 120.0f;
                    this.add(bg);
                }
                this.pos += 29.0f;
            }
        }

        private void addItem(Item item) {
            ItemButton slot = new ItemButton(item);
            slot.setRect(0.0f, this.pos, WndRanking.this.width, 23.0f);
            this.add(slot);
            this.pos += slot.height() + 1.0f;
        }
    }

    private class StatsTab
    extends Group {
        private int GAP = 4;

        public StatsTab() {
            if (Payment.isTierUnlocked(2)) {
                --this.GAP;
            }
            String heroClass = Dungeon.hero.className();
            IconTitle title = new IconTitle();
            title.icon(HeroSprite.avatar(Dungeon.hero.heroClass, Dungeon.hero.tier()));
            if (Dungeon.hero.name().equals(Dungeon.hero.className())) {
                title.label(Messages.get(this, "title", Dungeon.hero.lvl, heroClass).toUpperCase(Locale.ENGLISH));
            } else {
                title.label(Dungeon.hero.name() + "\n" + Messages.get(this, "title", Dungeon.hero.lvl, heroClass).toUpperCase(Locale.ENGLISH));
            }
            title.color(0xFFFF44);
            title.setRect(0.0f, 0.0f, 115.0f, 0.0f);
            this.add(title);
            float pos = title.bottom() + (float)this.GAP;
            RedButton btnTalents = new RedButton(Messages.get(this, "talents", new Object[0])){

                @Override
                protected void onClick() {
                    int tiers = 1;
                    if (Dungeon.hero.lvl >= 6) {
                        ++tiers;
                    }
                    if (Dungeon.hero.lvl >= 12 && Dungeon.hero.subClass != HeroSubClass.NONE) {
                        ++tiers;
                    }
                    if (Dungeon.hero.lvl >= 20 && Dungeon.hero.armorAbility != null) {
                        ++tiers;
                    }
                    while (Dungeon.hero.talents.size() > tiers) {
                        Dungeon.hero.talents.remove(Dungeon.hero.talents.size() - 1);
                    }
                    Game.scene().addToFront(new Window(){
                        {
                            TalentsPane p = new TalentsPane(TalentButton.Mode.INFO);
                            this.add(p);
                            p.setPos(0.0f, 0.0f);
                            p.setSize(120.0f, p.content().height());
                            this.resize((int)p.width(), (int)p.height());
                            p.setPos(0.0f, 0.0f);
                        }
                    });
                }
            };
            btnTalents.icon(Icons.get(Icons.TALENT));
            btnTalents.setRect((115.0f - btnTalents.reqWidth() + 2.0f) / 2.0f, pos, btnTalents.reqWidth() + 2.0f, 16.0f);
            this.add(btnTalents);
            pos = btnTalents.bottom();
            if (Dungeon.challenges > 0) {
                RedButton btnChallenges = new RedButton(Messages.get(this, "challenges", new Object[0])){

                    @Override
                    protected void onClick() {
                        Game.scene().add(new WndChallenges(Dungeon.challenges, false));
                    }
                };
                btnChallenges.icon(Icons.get(Icons.CHALLENGE_ON));
                btnChallenges.setSize(btnChallenges.reqWidth() + 2.0f, 16.0f);
                this.add(btnChallenges);
                float left = (115.0f - btnTalents.width() - btnChallenges.width()) / 3.0f;
                btnTalents.setPos(left, btnTalents.top());
                btnChallenges.setPos(btnTalents.right() + left, btnTalents.top());
            }
            pos += (float)this.GAP;
            int strBonus = Dungeon.hero.STR() - Dungeon.hero.STR;
            pos = strBonus > 0 ? this.statSlot(this, Messages.get(this, "str", new Object[0]), Dungeon.hero.STR + " + " + strBonus, pos) : (strBonus < 0 ? this.statSlot(this, Messages.get(this, "str", new Object[0]), Dungeon.hero.STR + " - " + -strBonus, pos) : this.statSlot(this, Messages.get(this, "str", new Object[0]), Integer.toString(Dungeon.hero.STR), pos));
            pos = this.statSlot(this, Messages.get(this, "health", new Object[0]), Integer.toString(Dungeon.hero.HT), pos);
            pos += (float)this.GAP;
            pos = this.statSlot(this, Messages.get(this, "duration", new Object[0]), Integer.toString((int)Statistics.duration), pos);
            pos += (float)this.GAP;
            pos = this.statSlot(this, Messages.get(this, "depth", new Object[0]), Integer.toString(Statistics.deepestFloor), pos);
            pos = this.statSlot(this, Messages.get(this, "enemies", new Object[0]), Integer.toString(Statistics.enemiesSlain), pos);
            pos = this.statSlot(this, Messages.get(this, "gold", new Object[0]), Integer.toString(Statistics.goldCollected), pos);
            pos += (float)this.GAP;
            pos = this.statSlot(this, Messages.get(this, "food", new Object[0]), Integer.toString(Statistics.foodEaten), pos);
            pos = this.statSlot(this, Messages.get(this, "alchemy", new Object[0]), Integer.toString(Statistics.itemsCrafted), pos);
            pos = this.statSlot(this, Messages.get(this, "ankhs", new Object[0]), Integer.toString(Statistics.ankhsUsed), pos);
            if (Payment.isTierUnlocked(2)) {
                if (!HallOfHeroesScene.inHOH) {
                    RedButton btnHOH = new RedButton(Messages.get(WndRanking.class, "copy", new Object[0])){

                        @Override
                        protected void onClick() {
                            super.onClick();
                            Rankings.INSTANCE.loadHall();
                            for (ArrayList<Rankings.Record> records : Rankings.INSTANCE.hallRecords) {
                                for (Rankings.Record record : records) {
                                    if (!record.gameID.equals(WndRanking.this.gameID)) continue;
                                    Game.scene().add(new WndError(Messages.get(WndRanking.class, "already_there", new Object[0])));
                                    return;
                                }
                            }
                            for (final Rankings.Record record : Rankings.INSTANCE.records) {
                                ArrayList<String> pages = new ArrayList<String>();
                                for (int i = 0; i < 4; ++i) {
                                    pages.add(Messages.get(WndRanking.class, "page", i + 1));
                                }
                                if (!record.gameID.equals(WndRanking.this.gameID)) continue;
                                this.parent.add(new WndOptions("", Messages.get(WndRanking.class, "copy_where", new Object[0]), new String[]{(String)pages.get(0), (String)pages.get(1), (String)pages.get(2), (String)pages.get(3)}){

                                    @Override
                                    protected void onSelect(int index) {
                                        int page = index;
                                        if (Rankings.INSTANCE.sendToHall(record, page, HallOfHeroesScene.page)) {
                                            Sync.syncHallOfHeroes();
                                            ShatteredPixelDungeon.switchNoFade(RankingsScene.class);
                                        } else {
                                            Game.scene().add(new WndError(Messages.get(WndRanking.class, "page_full", new Object[0])));
                                        }
                                    }
                                });
                            }
                        }
                    };
                    btnHOH.icon(Icons.get(Icons.BLANKAMMY));
                    btnHOH.setRect(0.0f, pos, 115.0f, 16.0f);
                    this.add(btnHOH);
                } else {
                    RedButton btnMove = new RedButton(Messages.get(WndRanking.class, "move", new Object[0])){

                        @Override
                        protected void onClick() {
                            super.onClick();
                            for (final Rankings.Record record : Rankings.INSTANCE.hallRecords.get(HallOfHeroesScene.page)) {
                                if (!record.gameID.equals(WndRanking.this.gameID)) continue;
                                ArrayList<String> pages = new ArrayList<String>();
                                for (int i = 0; i < 4; ++i) {
                                    if (i == HallOfHeroesScene.page) continue;
                                    pages.add(Messages.get(WndRanking.class, "page", i + 1));
                                }
                                this.parent.add(new WndOptions("", Messages.get(WndRanking.class, "move_where", new Object[0]), new String[]{Messages.get(WndRanking.class, "remove", new Object[0]), (String)pages.get(0), (String)pages.get(1), (String)pages.get(2)}){

                                    @Override
                                    protected void onSelect(int index) {
                                        int page;
                                        int n = page = index - 1 >= HallOfHeroesScene.page ? index : index - 1;
                                        if (index == 0) {
                                            Game.scene().add(new WndOptions("", Messages.get(WndRanking.class, "remove_warn", new Object[0]), new String[]{Messages.get(WndRanking.class, "remove", new Object[0]), Messages.get(WndRanking.class, "cancel", new Object[0])}){

                                                @Override
                                                protected void onSelect(int index) {
                                                    if (index == 0) {
                                                        Rankings.INSTANCE.hallRecords.get(HallOfHeroesScene.page).remove(record);
                                                        Rankings.INSTANCE.saveHall();
                                                        ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
                                                    }
                                                }
                                            });
                                        } else if (Rankings.INSTANCE.sendToHall(record, page, HallOfHeroesScene.page)) {
                                            ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
                                        } else {
                                            Game.scene().add(new WndError(Messages.get(WndRanking.class, "page_full", new Object[0])));
                                        }
                                    }
                                });
                            }
                        }
                    };
                    btnMove.icon(Icons.get(Icons.BLANKAMMY));
                    btnMove.setRect(0.0f, pos, 55.0f, 16.0f);
                    this.add(btnMove);
                    RedButton btnNotes = new RedButton(Messages.get(WndRanking.class, "notes", new Object[0])){

                        @Override
                        protected void onClick() {
                            super.onClick();
                            Rankings.Record tempRec = null;
                            for (Rankings.Record rec : Rankings.INSTANCE.hallRecords.get(HallOfHeroesScene.page)) {
                                if (!rec.gameID.equals(WndRanking.this.gameID)) continue;
                                tempRec = rec;
                                break;
                            }
                            final Rankings.Record record = tempRec;
                            Game.scene().addToFront(new WndTextInput(Messages.get(WndRanking.class, "custom_note", new Object[0]), record.note, 2000, true, Messages.get(WndRanking.class, "save", new Object[0]), Messages.get(WndRanking.class, "cancel", new Object[0])){

                                @Override
                                public void onSelect(boolean positive, String text) {
                                    if (positive) {
                                        record.note = text;
                                        record.lastUpdatedHOH = Rankings.INSTANCE.hallLastUpdated = Game.realTime;
                                        Rankings.INSTANCE.saveHall();
                                    }
                                }
                            });
                        }
                    };
                    btnNotes.icon(Icons.get(Icons.RENAME_ON));
                    btnNotes.setRect(60.0f, pos, 55.0f, 16.0f);
                    this.add(btnNotes);
                }
            }
        }

        private float statSlot(Group parent, String label, String value, float pos) {
            RenderedTextBlock txt = PixelScene.renderTextBlock(label, 7);
            txt.setPos(0.0f, pos);
            parent.add(txt);
            txt = PixelScene.renderTextBlock(value, 7);
            txt.setPos(80.5f, pos);
            PixelScene.align(txt);
            parent.add(txt);
            return pos + (float)this.GAP + txt.height();
        }
    }

    private class RankingTab
    extends WndTabbed.IconTab {
        private Group page;

        public RankingTab(Icons icon, Group page) {
            super(WndRanking.this, Icons.get(icon));
            this.page = page;
        }

        @Override
        protected void select(boolean value) {
            super.select(value);
            if (this.page != null) {
                this.page.visible = this.page.active = this.selected;
            }
        }
    }
}

