/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.SupporterScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.updates.Updates;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.watabou.utils.Callback;

public class WndSupportPrompt
extends Window {
    protected static final int WIDTH_P = 120;
    protected static final int WIDTH_L = 200;

    public WndSupportPrompt() {
        int width = PixelScene.landscape() ? 200 : 120;
        IconTitle title = new IconTitle(Icons.get(Icons.SHPX), Messages.get(WndSupportPrompt.class, "title", new Object[0]));
        title.setRect(0.0f, 0.0f, width, 0.0f);
        this.add(title);
        String message = "";
        message = message + Messages.get(WndSupportPrompt.class, "intro", new Object[0]);
        message = message + "\n\n" + Messages.get(WndSupportPrompt.class, "please_consider", new Object[0]);
        if (Updates.supportsReviews()) {
            message = message + "\n\n" + Messages.get(WndSupportPrompt.class, "rating", new Object[0]);
        }
        if (Payment.isIAPSupported()) {
            message = message + "\n\n" + Messages.get(WndSupportPrompt.class, "support", new Object[0]);
        }
        message = message + "\n\n" + Messages.get(WndSupportPrompt.class, "thank_you", new Object[0]);
        message = message + "\n- Evan";
        RenderedTextBlock text = PixelScene.renderTextBlock(6);
        text.text(message, width);
        text.setPos(title.left(), title.bottom() + 4.0f);
        this.add(text);
        RedButton review = null;
        RedButton support = null;
        if (Updates.supportsReviews()) {
            review = new RedButton(Messages.get(this, "rating_prompt", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    SPDSettings.supportNagged(true);
                    Updates.launchReview(new Callback(){

                        @Override
                        public void call() {
                            ShatteredPixelDungeon.runOnRenderThread(new Callback(){

                                @Override
                                public void call() {
                                    ShatteredPixelDungeon.scene().addToFront(new WndOptions("", Messages.get(WndSupportPrompt.class, "rating_info", new Object[0]), new String[]{Messages.get(WndSupportPrompt.class, "rating_direct", new Object[0]), Messages.get(WndSupportPrompt.class, "close", new Object[0])}){

                                        @Override
                                        protected void onSelect(int index) {
                                            if (index == 0) {
                                                Updates.openReviewURI();
                                            } else {
                                                this.hide();
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            };
            this.add(review);
        }
        if (Payment.isIAPSupported()) {
            support = new RedButton(Messages.get(this, "support_prompt", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    SPDSettings.supportNagged(true);
                    ShatteredPixelDungeon.switchScene(SupporterScene.class);
                }
            };
            this.add(support);
        }
        float bottom = (int)text.bottom() + 4;
        if (PixelScene.landscape() && review != null && support != null) {
            review.setRect(0.0f, bottom, width / 2 - 1, 18.0f);
            support.setRect(width / 2 + 1, bottom, width / 2 - 1, 18.0f);
            bottom = (int)support.bottom() + 2;
        } else {
            if (review != null) {
                review.setRect(0.0f, bottom, width, 18.0f);
                bottom = review.bottom() + 2.0f;
            }
            if (support != null) {
                support.setRect(0.0f, bottom, width, 18.0f);
                bottom = support.bottom() + 2.0f;
            }
        }
        RedButton close = new RedButton(Messages.get(this, "close", new Object[0])){

            @Override
            protected void onClick() {
                super.onClick();
                SPDSettings.supportNagged(true);
                WndSupportPrompt.super.hide();
            }
        };
        close.setRect(0.0f, bottom, width, 18.0f);
        this.add(close);
        this.resize(width, (int)close.bottom());
    }

    @Override
    public void hide() {
    }
}

