/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.PaymentService;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MobSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.StyledButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.ui.Component;
import java.util.Calendar;

public class WndSupporterTiers
extends Window {
    private static final int WIDTH_P = 120;
    private static final int WIDTH_L = 180;
    private static final int TEXT_MARGIN = 5;

    private WndSupporterTiers(int tier) {
        TierInfo tierInfo;
        this.width = PixelScene.landscape() ? 180 : 120;
        switch (tier) {
            default: {
                tierInfo = new Tier1Info();
                if (SPDSettings.goldenUI()) break;
                this.chrome.hardlight(1.67f, 1.67f, 1.67f);
                break;
            }
            case 2: {
                tierInfo = new Tier2Info();
                if (SPDSettings.goldenUI()) break;
                this.chrome.hardlight(1.5f, 1.25f, 0.2f);
                break;
            }
            case 3: {
                tierInfo = new Tier3Info();
                if (SPDSettings.goldenUI()) break;
                this.chrome.hardlight(0.0f, 1.0f, 0.0f);
            }
        }
        tierInfo.setRect(0.0f, 0.0f, this.width, 0.0f);
        this.resize(this.width, (int)tierInfo.height());
        ColorBlock dark = new ColorBlock(this.width + 4, this.height + 4, 0x66000000);
        dark.x = -2.0f;
        dark.y = -2.0f;
        if (!SPDSettings.goldenUI()) {
            this.add(dark);
        }
        this.add(tierInfo);
    }

    private class RatCloudSprite
    extends MobSprite {
        public boolean festive;
        private float baseY = Float.NaN;

        public RatCloudSprite() {
            this.renderShadow = true;
            Calendar calendar = Calendar.getInstance();
            this.festive = calendar.get(2) == 11 && calendar.get(4) > 2;
            int c = this.festive ? 4 : 0;
            this.texture("private/ratcloud.png");
            TextureFilm frames = new TextureFilm(this.texture, 16, 32);
            this.idle = new MovieClip.Animation(1, true);
            this.idle.frames(frames, 0);
            this.play(this.idle);
        }

        @Override
        public void update() {
            super.update();
            if (Float.isNaN(this.baseY)) {
                this.baseY = this.y;
            }
            this.y = this.baseY + 2.0f * (float)Math.sin(4.0f * Game.timeTotal);
            this.shadowOffset = 0.25f - 1.6f * (float)Math.sin(4.0f * Game.timeTotal);
        }
    }

    private static class PaymentButton
    extends SupporterButton {
        public PaymentButton(int tier) {
            super(tier, Messages.get(PaymentButton.class, "purchase", Payment.getTierPrice(tier)));
            switch (tier) {
                default: {
                    this.icon(Icons.get(Icons.TIER1));
                    break;
                }
                case 2: {
                    this.icon(Icons.get(Icons.TIER2));
                    break;
                }
                case 3: {
                    this.icon(Icons.get(Icons.TIER3));
                }
            }
            if (Payment.isTierPending(tier)) {
                this.text(Messages.get(this, "pending", new Object[0]));
                this.enable(false);
            }
        }

        @Override
        protected void onClick() {
            super.onClick();
            Payment.initiatePurchase(this.tier, new PaymentService.RefreshCallback(){

                @Override
                public void onSuccess() {
                    ShatteredPixelDungeon.seamlessResetScene();
                }

                @Override
                public void onFail() {
                }
            });
        }
    }

    private static class IconButton
    extends SupporterButton {
        IconButton(int tier) {
            super(tier, Messages.get(IconButton.class, "normal", new Object[0]));
            this.text.hardlight(0xFFFF44);
            this.updateState();
        }

        @Override
        protected void onClick() {
            super.onClick();
            if (SPDSettings.donationIcon() == this.tier) {
                SPDSettings.donationIcon(0);
            } else {
                SPDSettings.donationIcon(this.tier);
            }
            this.updateState();
        }

        private void updateState() {
            if (SPDSettings.donationIcon() == this.tier) {
                this.text.text(Messages.get(this, "normal", new Object[0]));
            } else if (this.tier == 1) {
                this.text.text(Messages.get(this, "silver", new Object[0]));
            } else if (this.tier == 2) {
                this.text.text(Messages.get(this, "golden", new Object[0]));
            } else if (this.tier == 3) {
                this.text.text(Messages.get(this, "shattered", new Object[0]));
            }
            this.icon(new Image("private/menu_button_styled.png", 15, 16 * SPDSettings.donationIcon(), 16, 15));
        }
    }

    private static class SupporterButton
    extends StyledButton {
        protected int tier;

        SupporterButton(int tier, String text) {
            super(Chrome.Type.GREY_BUTTON, text);
            this.tier = tier;
            this.updateBG(false);
        }

        private void updateBG(boolean pressed) {
            switch (this.tier) {
                default: {
                    if (!pressed) {
                        this.bg.hardlight(1.67f, 1.67f, 1.67f);
                        break;
                    }
                    this.bg.hardlight(2.0f, 2.0f, 2.0f);
                    break;
                }
                case 2: {
                    if (!pressed) {
                        this.bg.hardlight(1.5f, 1.25f, 0.2f);
                        break;
                    }
                    this.bg.hardlight(2.1f, 1.5f, 0.25f);
                    break;
                }
                case 3: {
                    if (!pressed) {
                        this.bg.hardlight(0.0f, 1.0f, 0.0f);
                        break;
                    }
                    this.bg.hardlight(0.0f, 1.2f, 0.0f);
                }
            }
        }

        @Override
        protected void onPointerDown() {
            super.onPointerDown();
            this.updateBG(true);
        }

        @Override
        protected void onPointerUp() {
            super.onPointerUp();
            this.updateBG(false);
        }
    }

    public static class Tier3Info
    extends TierInfo {
        @Override
        protected void createChildren() {
            this.titleColor = 52224;
            this.titles = new IconTitle[]{new IconTitle(Icons.TIER3.get(), Messages.get(this, "title", new Object[0])), new IconTitle(null, Messages.get(this, "rewards", new Object[0])), new IconTitle(Icons.TIER1.get(), Messages.get(this, "silver", new Object[0])), new IconTitle(Icons.TIER2.get(), Messages.get(this, "golden", new Object[0])), new IconTitle(new Image("private/menu_button_styled.png", 15, 48, 16, 15), Messages.get(this, "menu", new Object[0])), new IconTitle(Icons.GOLDENUI.get(), Messages.get(this, "interface_title", new Object[0]))};
            this.texts = new RenderedTextBlock[]{PixelScene.renderTextBlock(Messages.get(this, "intro", new Object[0]), 6), null, null, null, null, PixelScene.renderTextBlock(Messages.get(this, "interface_desc", new Object[0]), 6)};
            if (Payment.isTierUnlocked(3)) {
                this.button1 = new IconButton(3);
                this.button2 = new SupporterButton(3, SPDSettings.goldenUI() ? Messages.get(this, "disable_gold", new Object[0]) : Messages.get(this, "enable_gold", new Object[0])){

                    @Override
                    protected void onClick() {
                        super.onClick();
                        SPDSettings.goldenUI(!SPDSettings.goldenUI());
                        ShatteredPixelDungeon.seamlessResetScene();
                    }
                };
                this.button2.textColor(0xFFFF44);
                Image icon = Icons.get(Icons.GOLDENUI);
                if (!SPDSettings.goldenUI()) {
                    icon.tint(0.0f, 0.0f, 0.0f, 0.5f);
                }
                this.button2.icon(icon);
            } else {
                this.button1 = new PaymentButton(3);
            }
        }
    }

    public static class Tier2Info
    extends TierInfo {
        @Override
        protected void createChildren() {
            this.titleColor = 16762394;
            this.titles = new IconTitle[]{new IconTitle(Icons.TIER2.get(), Messages.get(this, "title", new Object[0])), new IconTitle(null, Messages.get(this, "rewards", new Object[0])), new IconTitle(Icons.TIER1.get(), Messages.get(this, "silver", new Object[0])), new IconTitle(new Image("private/menu_button_styled.png", 15, 32, 16, 15), Messages.get(this, "menu", new Object[0])), new IconTitle(new ItemSprite(ItemSpriteSheet.WAR_HAMMER, null), Messages.get(this, "rename_title", new Object[0])), new IconTitle(Icons.BLANKAMMY.get(), Messages.get(this, "hall_title", new Object[0]))};
            this.texts = new RenderedTextBlock[]{PixelScene.renderTextBlock(Messages.get(this, "intro", new Object[0]), 6), null, null, null, PixelScene.renderTextBlock(Messages.get(this, "rename_desc", new Object[0]), 6), PixelScene.renderTextBlock(Messages.get(this, "hall_desc", new Object[0]), 6)};
            this.button1 = Payment.isTierUnlocked(2) ? new IconButton(2) : new PaymentButton(2);
        }
    }

    public static class Tier1Info
    extends TierInfo {
        @Override
        protected void createChildren() {
            this.titleColor = 0xCCCCCC;
            this.titles = new IconTitle[]{new IconTitle(Icons.TIER1.get(), Messages.get(this, "title", new Object[0])), new IconTitle(null, Messages.get(this, "rewards", new Object[0])), new IconTitle(new Image("private/menu_button_styled.png", 15, 16, 16, 15), Messages.get(this, "menu", new Object[0])), new IconTitle(new ItemSprite(ItemSpriteSheet.SCROLL_ISAZ, null), Messages.get(this, "rename_title", new Object[0])), new IconTitle(new ItemSprite(ItemSpriteSheet.GRAVE, null), Messages.get(this, "graves_title", new Object[0]))};
            this.texts = new RenderedTextBlock[]{PixelScene.renderTextBlock(Messages.get(this, "intro", new Object[0]), 6), null, null, PixelScene.renderTextBlock(Messages.get(this, "rename_desc", new Object[0]), 6), PixelScene.renderTextBlock(Messages.get(this, "graves_desc", new Object[0]), 6)};
            this.button1 = Payment.isTierUnlocked(1) ? new IconButton(1) : new PaymentButton(1);
        }
    }

    public static abstract class TierInfo
    extends Component {
        protected IconTitle[] titles;
        protected RenderedTextBlock[] texts;
        protected StyledButton button1;
        protected StyledButton button2;
        protected int titleColor;

        @Override
        protected void layout() {
            super.layout();
            float y = 0.0f;
            for (int i = 0; i < this.titles.length; ++i) {
                this.titles[i].color(this.titleColor);
                if (i == 1) {
                    this.titles[i].setRect(-13.0f, y, this.width, 0.0f);
                } else {
                    this.titles[i].setRect(0.0f, y, this.width, 0.0f);
                }
                this.add(this.titles[i]);
                y = this.titles[i].bottom() + 2.0f;
                if (this.texts[i] == null) continue;
                this.texts[i].maxWidth((int)(this.width - 10.0f));
                this.texts[i].setPos(5.0f, y);
                y = this.texts[i].bottom() + 2.0f;
                this.add(this.texts[i]);
            }
            if (this.button1 != null) {
                this.button1.setRect(0.0f, y += 2.0f, this.width, 18.0f);
                this.button1.textColor(this.titleColor);
                y += 18.0f;
                this.add(this.button1);
                if (this.button2 != null) {
                    this.button2.setRect(0.0f, y += 2.0f, this.width, 18.0f);
                    y += 18.0f;
                    this.button2.textColor(this.titleColor);
                    this.add(this.button2);
                }
            }
            this.height = y;
        }
    }

    public static class WndTier3
    extends WndSupporterTiers {
        public WndTier3() {
            super(3);
        }
    }

    public static class WndTier2
    extends WndSupporterTiers {
        public WndTier2() {
            super(2);
        }
    }

    public static class WndTier1
    extends WndSupporterTiers {
        public WndTier1() {
            super(1);
        }
    }
}

