/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.watabou.input.ControllerHandler;
import com.watabou.input.KeyBindings;
import com.watabou.input.KeyEvent;
import com.watabou.input.PointerEvent;
import com.watabou.input.ScrollEvent;
import com.watabou.noosa.Game;

public class InputHandler
extends InputAdapter {
    private InputMultiplexer multiplexer = new InputMultiplexer(){

        @Override
        public boolean touchDown(int screenX, int screenY, int pointer, int button) {
            screenX = (int)((float)screenX / ((float)Game.dispWidth / (float)Game.width));
            screenY = (int)((float)screenY / ((float)Game.dispHeight / (float)Game.height));
            return super.touchDown(screenX, screenY, pointer, button);
        }

        @Override
        public boolean touchDragged(int screenX, int screenY, int pointer) {
            screenX = (int)((float)screenX / ((float)Game.dispWidth / (float)Game.width));
            screenY = (int)((float)screenY / ((float)Game.dispHeight / (float)Game.height));
            return super.touchDragged(screenX, screenY, pointer);
        }

        @Override
        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            screenX = (int)((float)screenX / ((float)Game.dispWidth / (float)Game.width));
            screenY = (int)((float)screenY / ((float)Game.dispHeight / (float)Game.height));
            return super.touchUp(screenX, screenY, pointer, button);
        }

        @Override
        public boolean mouseMoved(int screenX, int screenY) {
            screenX = (int)((float)screenX / ((float)Game.dispWidth / (float)Game.width));
            screenY = (int)((float)screenY / ((float)Game.dispHeight / (float)Game.height));
            return super.mouseMoved(screenX, screenY);
        }
    };

    public InputHandler(Input input) {
        input.setInputProcessor(this.multiplexer);
        this.addInputProcessor(this);
        input.setCatchKey(4, true);
        input.setCatchKey(82, true);
    }

    public void addInputProcessor(InputProcessor processor) {
        this.multiplexer.addProcessor(0, processor);
    }

    public void removeInputProcessor(InputProcessor processor) {
        this.multiplexer.removeProcessor(processor);
    }

    public void processAllEvents() {
        PointerEvent.processPointerEvents();
        KeyEvent.processKeyEvents();
        ScrollEvent.processScrollEvents();
    }

    @Override
    public synchronized boolean touchDown(int screenX, int screenY, int pointer, int button) {
        ControllerHandler.setControllerPointer(false);
        Gdx.input.setOnscreenKeyboardVisible(false);
        PointerEvent.addPointerEvent(new PointerEvent(screenX, screenY, pointer, PointerEvent.Type.DOWN, button));
        return true;
    }

    @Override
    public synchronized boolean touchUp(int screenX, int screenY, int pointer, int button) {
        PointerEvent.addPointerEvent(new PointerEvent(screenX, screenY, pointer, PointerEvent.Type.UP, button));
        return true;
    }

    @Override
    public synchronized boolean touchDragged(int screenX, int screenY, int pointer) {
        PointerEvent.addPointerEvent(new PointerEvent(screenX, screenY, pointer, PointerEvent.Type.DOWN));
        return true;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        ControllerHandler.setControllerPointer(false);
        PointerEvent.addPointerEvent(new PointerEvent(screenX, screenY, -1, PointerEvent.Type.HOVER));
        return true;
    }

    @Override
    public synchronized boolean keyDown(int keyCode) {
        if (KeyBindings.isKeyBound(keyCode)) {
            KeyEvent.addKeyEvent(new KeyEvent(keyCode, true));
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean keyUp(int keyCode) {
        if (KeyBindings.isKeyBound(keyCode)) {
            KeyEvent.addKeyEvent(new KeyEvent(keyCode, false));
            return true;
        }
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        ScrollEvent.addScrollEvent(new ScrollEvent(PointerEvent.currentHoverPos(), amountY));
        return true;
    }
}

