//------------------------------------------------------------------------------
//
//	File: CLAudioCD.H
//
//	Desc : Filter definition file for CLAudioCD.ax
//------------------------------------------------------------------------------

#ifndef __CLAUDIOCD_H__
#define __CLAUDIOCD_H__

#ifndef _OBJBASE_H_
// This <objbase.h> is the definition of DEFINE_GUID(), it must be included for 
// self-contain reason.
//
// Each dll/exe must initialize the GUIDs once.  This is done in one of
// two ways.  If you are not using precompiled headers for the file(s) which
// initializes the GUIDs, define INITGUID before including objbase.h.  This
// is how OLE builds the initialized versions of the GUIDs which are included
// in ole2.lib.  The GUIDs in ole2.lib are all defined in the same text
// segment GUID_TEXT.
//
// The alternative (which some versions of the compiler don't handle properly;
// they wind up with the initialized GUIDs in a data, not a text segment),
// is to use a precompiled version of objbase.h and then include initguid.h
// after objbase.h followed by one or more of the guid defintion files.
#include <objbase.h>
#endif //~_OBJBASE_H_

//==================== GUID definition =================
//
// {54F4C1CD-D46A-11d4-9D0E-DA91C8F4645E}
DEFINE_GUID(CLSID_CLAudioCD, 
0x54F4C1CD, 0xd46a, 0x11d4, 0x9d, 0xe, 0xda, 0x91, 0xc8, 0xf4, 0x64, 0x5e);

// {9984EEFC-CA47-43bc-BDDE-AD55D74B9798}
DEFINE_GUID(CLSID_CLAudioCDProp, 
0x9984eefc, 0xca47, 0x43bc, 0xbd, 0xde, 0xad, 0x55, 0xd7, 0x4b, 0x97, 0x98);

#ifndef _CYBERLINK_AUDIOCD_
#define _CYBERLINK_AUDIOCD_
// Mei 030305: used for CLAudioCD.ax, support AudioCD and DTS-CD
// {48A228F3-3112-4e5f-919A-B5A315A56F12}
DEFINE_GUID(MEDIASUBTYPE_CYBERLINK_AUDIOCD, 
0x48a228f3, 0x3112, 0x4e5f, 0x91, 0x9a, 0xb5, 0xa3, 0x15, 0xa5, 0x6f, 0x12);
#endif //!_CYBERLINK_AUDIOCD_

//==================== Type definition =================
// none

//==================== Interface definition =================
// Note: This filter is created as a standard File Source Filter.
// So, please use this filter by interface IFileSourceFilter as follow.
//
//DECLARE_INTERFACE_(IFileSourceFilter, IUnknown)
//{
//	STDMETHOD( Load ) ( 
//		/* [in] */ LPCOLESTR pszFileName, 
//		/* [unique][in] */ const AM_MEDIA_TYPE *pmt ) PURE;
//
//	STDMETHOD( GetCurFile) (
//		/* [out] */ LPOLESTR *ppszFileName,
//		/* [out] */ AM_MEDIA_TYPE *pmt) PURE;
//};


// Implement Current Position function
// {FF5DCFFC-01CE-45cf-9159-C0BDC63FDDD9}
DEFINE_GUID(IID_ICLAudioCD, 
0xff5dcffc, 0x1ce, 0x45cf, 0x91, 0x59, 0xc0, 0xbd, 0xc6, 0x3f, 0xdd, 0xd9);

DECLARE_INTERFACE_(ICLAudioCD, IUnknown)
{
public:
	STDMETHOD (GetCurrentPosition)(LONGLONG* pllPos) PURE;
};

#endif // __CLAUDIOCD_H__

