#include <koan.fx>

sampler baseTex : register(s0) = sampler_state
{
    addressu = clamp;
    addressv = clamp;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

float2 g_vPtBegin = float2(0, 0);
float2 g_vPtEnd   = float2(0, 0);

struct OutputVS
{
    float4 posH : POSITION0;
    float2 tex0 : TEXCOORD0;
};

OutputVS TransformVS(float3 posL : POSITION0, float2 tex0 : TEXCOORD0)
{
    // Zero out our output.
    OutputVS outVS = (OutputVS)0;      

    // Transform to homogeneous clip space.
    outVS.posH = mul(mul(mul(float4(posL, 1.0f), g_mWorld), g_mView), g_mProject);

    outVS.tex0 = tex0;

    // Done--return the output.
    return outVS;
}

float4 ImageWarpPS(float2 tex0 : TEXCOORD0) : COLOR
{
    float dx = g_vPtEnd.x - g_vPtBegin.x;
    float dy = g_vPtEnd.y - g_vPtBegin.y;
    float d  = 2 * sqrt(dx*dx + dy*dy);
    float x1 = max(0, g_vPtEnd.x-d);
    float y1 = max(0, g_vPtEnd.y-d);
    float x2 = min(1, g_vPtEnd.x+d);
    float y2 = min(1, g_vPtEnd.y+d);

    float4 color = float4(0, 0, 0, 1);
    if (d <= 0)
        color = tex2D(baseTex, tex0);
    else if (tex0.x < x1 || tex0.y < y1 || tex0.x > x2 || tex0.y > y2)
        color = tex2D(baseTex, tex0);
    else
    {
        float  w = 0;
        float  h = 0;
        float4 r = float4(0, 0, 0, 0);

        // l: left, r: right, t: top, b: bottom
        float2 lt = float2(0, 0);
        float2 lb = float2(0, 0); 
        float2 rt = float2(0, 0); 
        float2 rb = float2(0, 0); 
        if (tex0.x < g_vPtEnd.x && tex0.y < g_vPtEnd.y)
        {
            w = g_vPtEnd.x - x1;
            h = g_vPtEnd.y - y1;
            r = float4(x1, y1, w, h);

            lt = float2(r.x, r.y);
            lb = float2(r.x, r.y+h);
            rt = float2(r.x+w, r.y);
            rb = float2(g_vPtBegin.x, g_vPtBegin.y);
        }
        else if (tex0.x < g_vPtEnd.x && tex0.y > g_vPtEnd.y)
        {
            w = g_vPtEnd.x - x1;
            h = y2 - g_vPtEnd.y;
            r = float4(x1, g_vPtEnd.y, w, h);

            lt = float2(r.x, r.y);
            lb = float2(r.x, r.y+h);
            rt = float2(g_vPtBegin.x, g_vPtBegin.y);
            rb = float2(r.x+w, r.y+h);
        }
        else if (tex0.x > g_vPtEnd.x && tex0.y < g_vPtEnd.y)
        {
            w = x2 - g_vPtEnd.x;
            h = g_vPtEnd.y - y1;
            r = float4(g_vPtEnd.x, y1, w, h);

            lt = float2(r.x, r.y);
            lb = float2(g_vPtBegin.x, g_vPtBegin.y);
            rt = float2(r.x+w, r.y);
            rb = float2(r.x+w, r.y+h);
        }
        else if (tex0.x > g_vPtEnd.x && tex0.y > g_vPtEnd.y)
        {
            w = x2 - g_vPtEnd.x;
            h = y2 - g_vPtEnd.y;
            r = float4(g_vPtEnd.x, g_vPtEnd.y, w, h);

            lt = float2(g_vPtBegin.x, g_vPtBegin.y);
            lb = float2(r.x, r.y+h);
            rt = float2(r.x+w, r.y);
            rb = float2(r.x+w, r.y+h);
        }

        float a  = tex0.x - r.x;
        float aa = a / w;
        float u1 = lt.x + (rt.x - lt.x) * aa;
	    float v1 = lt.y + (rt.y - lt.y) * aa;
    	float u2 = lb.x + (rb.x - lb.x) * aa;
	    float v2 = lb.y + (rb.y - lb.y) * aa;

        float duin = (u2 - u1) / h;
    	float dvin = (v2 - v1) / h;

        float b = tex0.y - r.y;
        float u = u1 + b * duin;
        float v = v1 + b * dvin;
        color = tex2D(baseTex, float2(u, v));
    }
    return color;
}

technique BasicEffect
{
    pass P0
    {
        vertexShader = compile vs_2_0 TransformVS();
        PixelShader = compile ps_3_0 ImageWarpPS();
    }   
}


