#include "koan.fx"

float  gRatioL = 0; //left
float  gRatioT = 0; //top
float  gRatioR = 1; //right
float  gRatioB = 1; //bottom

struct OutputVS
{
      float4 posH    : POSITION0;
      float2 tex0    : TEXCOORD0;
};

OutputVS RenderVS(float3 posL : POSITION0, float2 tex0 : TEXCOORD0)
{
      // Zero out our output.
      OutputVS outVS = (OutputVS)0;
      
      // Transform to homogeneous clip space.
      outVS.posH = mul(mul(mul(float4(posL, 1.0f), g_mWorld), g_mView), g_mProject);
      
      // Convert the 4 points of Rectangle to correct ratio for crop the redundant area
      if( tex0.x == 0 && tex0.y == 0 )
        tex0 = float2(gRatioL, gRatioT);
      else if( tex0.x == 1 && tex0.y == 0 )
        tex0 = float2(gRatioR, gRatioT);
      else if( tex0.x == 0 && tex0.y == 1 )
        tex0 = float2(gRatioL, gRatioB);
      else if( tex0.x == 1 && tex0.y == 1 )
        tex0 = float2(gRatioR, gRatioB);
      
      outVS.tex0 = tex0;
      return outVS;
}


technique BasicEffect
{
    pass P1
    {
        vertexShader = compile vs_2_0 RenderVS();
    }
}
