#include "koan.fx"
sampler base : register(s0) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};

sampler frame : register(s1) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};

float gAlpha    = 1.0;
float gUsingPhotoframe = 0;
float gNoLight = 0;
float gNoCorrect = 0;
float rotate    = 0;
float ax_mesh   = 1.0;
float ax_tex    = 1.0;
float4 view_rect = float4(0, 0, 1, 1);

float4 gEyePosW = float4(0, 0, 0, 0);
float4 gAmbientLight = float4(0.2, 0.2, 0.2, 0);
float4 gDiffuseLight = float4(0.8, 0.8, 0.8, 0);
float4 gSpecularLight = float4(0.2, 0.2, 0.2, 0);
float  gSpecularPower = 1;

float2 CalUV(float2 uv)
{
    float u = uv.x * ax_mesh;
    float v = uv.y;
    
    if (ax_tex >= ax_mesh)
    {
        u = uv.x;
        v = (v-view_rect.y) * (1/(view_rect.w-view_rect.y));        
    }
    else
    {
        u = (u-view_rect.x) * (1/(view_rect.z-view_rect.x));
        v = uv.y;
    }
    
    return float2(u, v);
}

float2 CalOrientation(float2 uv)
{
    float x = uv.x;
    float y = uv.y;
    if (rotate == 90)
    {
        x = uv.y;
        y = 1-uv.x;
    }
    else if (rotate == 180)
    {
        x = 1-uv.x;
        y = 1-uv.y;
    }
    else if (rotate == 270)
    {
        x = 1-uv.y;
        y = uv.x;
    }
    
    return float2(x, y);
}


struct OutputVS
{
      float4 posH    : POSITION0;
      float4 posW    : TEXCOORD0;
      float3 normalW  : TEXCOORD1;
      float2 tex0    : TEXCOORD2;
      float4 light  : TEXCOORD3;
};

OutputVS RenderVS(float3 posL : POSITION0, float3 normalL : NORMAL0, float2 tex0 : TEXCOORD0)
{
      // Zero out our output.
      OutputVS outVS = (OutputVS)0;
      
      // Transform to homogeneous clip space.
      if (gUsingPhotoframe)
      {        
        float4x4 matrixScale=float4x4(ax_tex/ax_mesh, 0.0, 0.0, 0.0,
                                                      0.0, 1.0, 0.0, 0.0,
                                                      0.0, 0.0, 1.0, 0.0,
                                                      0.0, 0.0, 0.0, 1.0);
        outVS.posH = mul(mul(mul(mul(float4(posL, 1.0f), matrixScale), g_mWorld), g_mView), g_mProject);
        }
      else
        outVS.posH = mul(mul(mul(float4(posL, 1.0f), g_mWorld), g_mView), g_mProject);
      
      float4 posW = mul(float4(posL, 1.0f), g_mWorld);
      outVS.posW = posW;
      
      float3 normalW = mul(float4(normalL, 0.0f), g_mWorld).xyz;
      normalW = normalize(normalW);
      outVS.normalW = normalW;
      
      // Lighting
      if (!gNoLight)
      {
        float3 toEye = normalize(gEyePosW - posW).xyz;
        float3 LightVecW = -toEye;
        
        // Compute the reflection vector.
        float3 r = reflect(-LightVecW, normalW);
        
        // Determine how much (if any) specular light makes it into the eye.
        float t  = pow(max(dot(r, toEye), 0.0f), gSpecularPower);
        
        // Determine the diffuse light intensity that strikes the vertex.    
        float s = max(dot(-LightVecW, normalW), 0.0f);
        
        float4 spec  	= t * gSpecularLight;
        float4 diffuse 	= s * gDiffuseLight;
        outVS.light = float4( (gAmbientLight + diffuse + spec).rgb, 1.0 );
      }else
        outVS.light = float4( 1.0, 1.0, 1.0, 1.0 );
      
      
      float2 uv_texture = tex0;
    
      if (!gNoCorrect)
      {
        //uv_texture = CalUV(uv_texture);
        uv_texture = CalOrientation(uv_texture);
      }
      
      outVS.tex0 = uv_texture;
      return outVS;
}



float4 RenderPS( float4 posW  : TEXCOORD0, float3 normalW  : TEXCOORD1, float2 uv : TEXCOORD2, float4 light : TEXCOORD3) : COLOR
{
    float2 uv_texture = uv;    
    float4 color = tex2D(base, float2(uv_texture.x, uv_texture.y));    
    if (color.a == 0)
        clip(-1);
    color = float4 ((color * light).rgb, color.a*gAlpha);
    return color;
}

technique BasicEffect
{
    pass P1
    {
        vertexShader = compile vs_2_0 RenderVS();
        PixelShader = compile ps_2_0 RenderPS();
        cullmode = CW;        
        //AlphaTestEnable = true;
        //AlphaFunc = Greater;
        //AlphaRef = 0;
    }
}
